import{_ as c}from"./chunks/js-profiler-bigpic.BteOd1sF.js";import{_ as d,h,ak as r,O as o,z as i,L as n,g as p,j as e,x as t}from"./chunks/framework.BpCjdwm5.js";const C=JSON.parse('{"title":"Teamscale JavaScript Profiler","description":"","frontmatter":{},"headers":[],"relativePath":"reference/coverage-profilers/teamscale-javascript-profiler/index.md","filePath":"reference/coverage-profilers/teamscale-javascript-profiler/index.md"}'),u={name:"reference/coverage-profilers/teamscale-javascript-profiler/index.md"};function g(m,a,f,b,k,v){const s=n("PluginTabsTab"),l=n("PluginTabs");return p(),h("div",null,[a[6]||(a[6]=r('<h1 id="teamscale-javascript-profiler" tabindex="-1">Teamscale JavaScript Profiler <a class="header-anchor" href="#teamscale-javascript-profiler" aria-label="Permalink to &quot;Teamscale JavaScript Profiler&quot;">​</a></h1><p>The <em>Teamscale JavaScript Profiler</em> can be used to collect test coverage for JavaScript/TypeScript applications in the browser. It consists of two parts, the <a href="#instrumenter">instrumenter</a> and the <a href="#collector">coverage collector</a>. The instrumenter adds statements to the code that signal reaching a particular code line when running it in the browser. The obtained coverage is aggregated in the Web browser and sent to a collecting server (the collector) once a second. Besides the coverage information, also the source maps of the code in the browser are sent to the collector once. The collector uses the source map to map the coverage information back to the original code and builds a coverage report that can be handed over to Teamscale. Teamscale uses the coverage information, for example, for <a href="./../../test-gap-analysis/">Test Gap analysis</a>.</p><p>An overview of the Teamscale JavaScript Profiler components and their interactions is given in the following illustration:</p><p><img src="'+c+'" alt="Overview" width="969" height="538" data-zoom="true"></p><div class="warning custom-block"><p class="custom-block-title">Public Beta</p><p>The Teamscale JavaScript Profiler is still in the public beta phase. Your development and testing environment might not yet be fully supported by this approach. Please contact our support (<a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>) in case you encounter any issues.</p></div><div class="info custom-block"><p class="custom-block-title">How-To</p><p>If you are looking for a quick guide on how to use the Teamscale JavaScript Profiler to collect coverage in the browser, please have a look at our <a href="./../../../howto/setting-up-profiler-tga/javascript/#how-to-record-test-coverage-for-javascript-applications-in-the-browser">how-to page</a>.</p></div><h2 id="prerequisites" tabindex="-1">Prerequisites <a class="header-anchor" href="#prerequisites" aria-label="Permalink to &quot;Prerequisites&quot;">​</a></h2><p>To use the Teamscale JavaScript Profiler, a number of prerequisites have to be in place.</p><p>The instrumented code must be executed in a (possibly headless) browser environment that supports at least <em>ECMAScript 2015</em>. Furthermore, we require that a <em>DOM</em> and <em>WebSockets</em> are available in that execution environment. In other words, the approach supports Edge &gt;= v79, Firefox &gt;= v54, Chrome &gt;= v51, and Safari &gt;= v10. Instrumented applications will fail in Node.js.</p><p>To run the components of the profiler, we recommend using the latest Node.js LTS version, at least, version 14 is needed.</p><h3 id="source-maps" tabindex="-1">Source Maps <a class="header-anchor" href="#source-maps" aria-label="Permalink to &quot;Source Maps&quot;">​</a></h3><p>The code which is executed in the browser often does not correspond to the code written by the developers. It can be the result of several transformation steps, for example, compilation (transpilation) from other languages, source code minimization, or bundling.</p><p>The presence of source map files in the code of the test subject ensures that the tested code can be mapped back to the original. Depending on your build pipeline, a different approach must be chosen to add the source maps to the test subject&#39;s code bundle.</p><p>In the following we provide pointers to relevant configuration options for some of the popular tools used in the context of JavaScript applications:</p>',14)),o(l,null,{default:i(()=>[o(s,{label:"TypeScript"},{default:i(()=>a[0]||(a[0]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// tsconfig.json")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"{ "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"compilerOptions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourceMap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"inlineSources"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }, "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[t("See the "),e("a",{href:"https://www.typescriptlang.org/tsconfig#inlineSourceMap",target:"_blank",rel:"noreferrer"},"Typescript documentation"),t(" for more details and options.")],-1)])),_:1,__:[0]}),o(s,{label:"Webpack"},{default:i(()=>a[1]||(a[1]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// webpack.config.js")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"module"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"."),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"exports"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," ="),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," { devtool: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'source-map'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[t("See the "),e("a",{href:"https://webpack.js.org/configuration/devtool/",target:"_blank",rel:"noreferrer"},"Webpack documentation"),t(" for more details on options to control the generation of source maps.")],-1),e("p",null,[t("Please use the "),e("a",{href:"https://webpack.js.org/loaders/source-map-loader/",target:"_blank",rel:"noreferrer"},[e("code",null,"source-map-loader"),t(" package")]),t(" to ensure that source maps from a previous transformation step are not lost.")],-1)])),_:1,__:[1]}),o(s,{label:"Angular ng-build"},{default:i(()=>a[2]||(a[2]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// angular.json")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"configurations"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": {")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'    "production"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": {")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'        "sourceMap"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"        ...")])])])],-1),e("p",null,[t("See the "),e("a",{href:"https://angular.io/guide/workspace-config#source-map-configuration",target:"_blank",rel:"noreferrer"},"Angular documentation"),t(" for more details and options.")],-1)])),_:1,__:[2]}),o(s,{label:"Vite"},{default:i(()=>a[3]||(a[3]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// vite.config.ts")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourcemap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'inline'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[t("See the "),e("a",{href:"https://vitejs.dev/config/#build-sourcemap",target:"_blank",rel:"noreferrer"},"Vite documentation"),t(" for more options and details.")],-1)])),_:1,__:[3]}),o(s,{label:"Rollup"},{default:i(()=>a[4]||(a[4]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// rollup.config.js")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"output"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourceMap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[t("See the "),e("a",{href:"https://rollupjs.org/guide/en/#outputsourcemap",target:"_blank",rel:"noreferrer"},"Rollup documentation"),t(" for more details and options.")],-1)])),_:1,__:[4]}),o(s,{label:"esbuild"},{default:i(()=>a[5]||(a[5]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// esbuild.js")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"require"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'esbuild'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")."),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"buildSync"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"({")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  entryPoints: ["),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'app.ts'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"],")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  sourcemap: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'inline'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  outfile: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'out.js'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"})")])])])],-1),e("p",null,[t("The "),e("a",{href:"https://esbuild.github.io/api/#sourcemap",target:"_blank",rel:"noreferrer"},"esbuild documentation"),t(" provides details and options on producing source map files.")],-1)])),_:1,__:[5]})]),_:1}),a[7]||(a[7]=r(`<h3 id="content-security-policy" tabindex="-1">Content Security Policy <a class="header-anchor" href="#content-security-policy" aria-label="Permalink to &quot;Content Security Policy&quot;">​</a></h3><p>To use the profiler, the application&#39;s Cross-Origin Resource Sharing (CORS) has to be adjusted. The instrumented application sends coverage information via WebSockets to a collecting server. That is, communication via WebSockets must be allowed. Whether this is allowed is determined by the <code>Content-Security-Policy</code> attribute. This attribute is either part of the HTTP header sent by the Web server delivering the Web application, or by a corresponding <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy" target="_blank" rel="noreferrer">HTML entry</a>. If the collecting server is running on the same machine as the browser, then communicating with localhost must be allowed by adding <code>ws://localhost:*</code> for <code>connect-src</code>, <code>blob</code>, and <code>worker-src</code> to the <code>Content-Security-Policy</code> header.</p><p>The following snippet shows the content security policy that has to be added for allowing accessing the collector at host <code>&lt;collectorHost&gt;</code> on port <code>&lt;port&gt;</code>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>connect-src &#39;self&#39; ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span>
<span class="line"><span>script-src &#39;self&#39; blob: ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span>
<span class="line"><span>worker-src &#39;self&#39; blob: ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span></code></pre></div><p>By not specifying a content security policy, everything would be allowed. This can also be specified explicitly, for testing environments:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>default-src * data: blob: filesystem: about: ws: wss: &#39;unsafe-inline&#39; &#39;unsafe-eval&#39; &#39;unsafe-dynamic&#39;; script-src * data: blob: &#39;unsafe-inline&#39; &#39;unsafe-eval&#39;; connect-src * data: blob: &#39;unsafe-inline&#39;; img-src * data: blob: &#39;unsafe-inline&#39;; frame-src * data: blob: ; style-src * data: blob: &#39;unsafe-inline&#39;; font-src * data: blob: &#39;unsafe-inline&#39;;</span></span></code></pre></div><p>The place to configure the content security policy depends on the backend framework that serves the frontend code. See, for example, the <a href="https://docs.spring.io/spring-security/site/docs/5.2.0.RELEASE/reference/html/default-security-headers-2.html#webflux-headers-csp" target="_blank" rel="noreferrer">Spring documentation</a> on that topic.</p><h2 id="instrumenter" tabindex="-1">Instrumenter <a class="header-anchor" href="#instrumenter" aria-label="Permalink to &quot;Instrumenter&quot;">​</a></h2><p>The Instrumenter instruments a given (set of) JavaScript file(s) such that (1) coverage information is produced and then (2) forwarded to the <a href="#collector">Collector</a>.</p><h3 id="usage" tabindex="-1">Usage <a class="header-anchor" href="#usage" aria-label="Permalink to &quot;Usage&quot;">​</a></h3><p>The instrumenter is available as a Node.js package with the name <code>@teamscale/javascript-instrumenter</code>. You can execute the instrumenter via <code>npx</code>, for example, the following command is used to instrument an example app:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">npx</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> @teamscale/javascript-instrumenter</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --input</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ./dist/</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --collector</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> localhost:54678</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --config-id</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> rc-testing-js-frontend</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --commit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> 55fde99d17fc8c6d0814931718aa95f1048aead5</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --in-place</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --include-origin</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;src/app/**/*&#39;</span></span></code></pre></div><h3 id="options" tabindex="-1">Options <a class="header-anchor" href="#options" aria-label="Permalink to &quot;Options&quot;">​</a></h3><p>In the following, we have provided a listing of available Instrumenter command line parameters.</p><div class="info custom-block"><p class="custom-block-title">Environment Variables</p><p>All relevant parameters can also be set via environment variables. For example, instead of the parameter <code>--collector</code>, you can define the environment variable <code>COLLECTOR</code>. Environment variables are written in <code>UPPERCASE_LETTERS_SEPARATED_BY_UNDERSCORES</code>.</p></div><h4 id="instrumenter-input-and-output" tabindex="-1">Instrumenter Input and Output <a class="header-anchor" href="#instrumenter-input-and-output" aria-label="Permalink to &quot;Instrumenter Input and Output&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-i, --input &lt;path …&gt;</code></td><td>The input file(s) or folder(s) to instrument.</td></tr><tr><td><code>-o, --to &lt;path&gt;</code></td><td>Path (directory or file name) where the instrumented version is written.</td></tr><tr><td><code>-l, --in-place</code></td><td>If set, the original files are replaced by their instrumented counterparts.</td></tr><tr><td><code>-e, --exclude-bundle &lt;pattern …&gt;</code></td><td>Glob pattern(s) of input (bundle) files to keep unchanged (i.e. <strong>not</strong> instrumented).</td></tr><tr><td><code>-k, --include-origin &lt;pattern …&gt;</code></td><td>Glob pattern(s) of files in the source origin to <em>include</em> in the coverage report. Multiple patterns can be separated by space.</td></tr><tr><td><code>-x, --exclude-origin &lt;pattern …&gt;</code></td><td>Glob pattern(s) of files in the source origin to <em>exclude</em> from the coverage report. Multiple patterns can be separated by space.</td></tr><tr><td><code>--source-map &lt;path&gt;</code></td><td>External location of source-map files to be considered during instrumentation.</td></tr></tbody></table><h4 id="coverage-target-parameters" tabindex="-1">Coverage Target Parameters <a class="header-anchor" href="#coverage-target-parameters" aria-label="Permalink to &quot;Coverage Target Parameters&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-a, --app-name &lt;name&gt;</code></td><td>Name of the application for which coverage is reported. Improves readability of the autogenerated application ID.</td></tr><tr><td><code>-c, --collector &lt;url&gt;</code></td><td>Collector address (<code>host:port</code>, <code>wss://host:port/</code> or <code>ws://host:port/</code>) that receives the coverage data. Default: <code>ws://localhost:54678</code>.</td></tr><tr><td><code>-t, --collector-config-file &lt;file&gt;</code></td><td>Path to a configuration file that specifies or overrides collector settings.</td></tr><tr><td><code>--collector-option &lt;key=value …&gt;</code></td><td>Sets a collector configuration option (may be given multiple times).</td></tr><tr><td><code>--collector-options-list</code></td><td>Lists all collector options that can be configured via <code>--collector-option</code> or a config file.</td></tr><tr><td><code>-r, --commit &lt;commit&gt;</code></td><td>Commit descriptor (<code>&lt;branch name&gt;:&lt;UNIX timestamp ms&gt;</code> or Git hash) identifying the code revision the coverage belongs to.</td></tr><tr><td><code>-f, --config-id &lt;id&gt;</code></td><td>Profiler configuration ID to use. The configuration is re-fetched from Teamscale every minute.</td></tr><tr><td><code>--relative-collector &lt;pattern&gt;</code></td><td>Derives the collector URL from the application host name (handy in Kubernetes). See command-line help for available operations.</td></tr></tbody></table><div class="warning custom-block"><p class="custom-block-title">Security Risk</p><p>When specifying credentials of other services via <code>--collector-config-file</code> or <code>--collector-option</code>, the credentials will be included in the instrumented source code and are thus visible to anyone that can access your deployed application. We recommend you instead give these credentials to the collector directly when launching it.</p></div><h4 id="troubleshooting" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-m, --dump-origin-matches-to &lt;file&gt;</code></td><td>Writes a JSON file containing the names of source files that matched the origin include/exclude patterns.</td></tr><tr><td><code>-p, --dump-origins-to &lt;file&gt;</code></td><td>Writes a JSON file containing source-origin file names derived from source maps.</td></tr><tr><td><code>--log-level &lt;level&gt;</code></td><td>Sets the log level (<code>trace</code>, <code>debug</code>, <code>info</code>, <code>warn</code>, <code>error</code>). Default: <code>info</code>.</td></tr></tbody></table><h4 id="instrumentation-excludes" tabindex="-1">Instrumentation Excludes <a class="header-anchor" href="#instrumentation-excludes" aria-label="Permalink to &quot;Instrumentation Excludes&quot;">​</a></h4><p>We provide two types of patters for excluding code from being instrumented: based on the origin of the code and based on the bundles the code was combined into.</p><h5 id="origin-based" tabindex="-1">Origin-based <a class="header-anchor" href="#origin-based" aria-label="Permalink to &quot;Origin-based&quot;">​</a></h5><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-x [EXCLUDE_ORIGIN ...], --exclude-origin [EXCLUDE_ORIGIN ...]</span></span></code></pre></div><p>Glob pattern(s) of files in the source origin to exclude from instrumentation. These patterns match file names found in the <em>original</em> source code files.</p><h5 id="bundle-based" tabindex="-1">Bundle-based <a class="header-anchor" href="#bundle-based" aria-label="Permalink to &quot;Bundle-based&quot;">​</a></h5><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-e [EXCLUDE_BUNDLE ...], --exclude-bundle [EXCLUDE_BUNDLE ...]</span></span></code></pre></div><p>Glob pattern(s) of input <em>bundle</em> files to keep unchanged (to not instrument). This pattern matches the name of the final bundle files passed to the instrumenter as inputs.</p><h4 id="relative-collector" tabindex="-1">Relative Collector <a class="header-anchor" href="#relative-collector" aria-label="Permalink to &quot;Relative Collector&quot;">​</a></h4><p>As specified via the <code>--relative-collector</code> option. Useful for Kubernetes deployments where the collector URL is not known at instrumentation time.</p><h5 id="example" tabindex="-1">Example <a class="header-anchor" href="#example" aria-label="Permalink to &quot;Example&quot;">​</a></h5><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">--relative-collector</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> replace-in-host:app</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> collector,scheme:wss</span></span></code></pre></div><p>This causes the first occurrence of <code>app</code> in the application hostname to be replaced with <code>collector</code> and the URL scheme changed to <code>wss</code>.</p><p>Available operations:</p><ul><li><code>replace-in-host:SEARCH REPLACE</code> replaces the literal term <code>SEARCH</code> once in the hostname with <code>REPLACE</code>.</li><li><code>port:NUMBER</code> changes the port to <code>NUMBER</code>.</li><li><code>port:keep</code> keeps the port of the application (instead of using the chosen scheme&#39;s default port).</li><li><code>scheme:SCHEME</code> changes the URL scheme to one of <code>ws</code>, <code>wss</code>, <code>http</code> or <code>https</code>.</li><li><code>path:PATH</code> uses <code>PATH</code> as the URL path (instead of no path).</li></ul><h4 id="commit" tabindex="-1">Commit <a class="header-anchor" href="#commit" aria-label="Permalink to &quot;Commit&quot;">​</a></h4><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-r COMMIT, --commit COMMIT</span></span></code></pre></div><p>The application you are testing was typically from a specific revision of your source code, and you might want to test different revisions of the same application concurrently. To differentiate between coverage collected for different revisions, specify the revision the application was built from via the parameter <code>--commit</code>, for example, <code>--commit main:1741709771000</code> (branch and Unix epoch timestamp) or <code>--commit bb918e2b666b226553e791187c94c7811cf0da9e</code> (Git commit hash). You can either specify a commit as a pair of branch name and Unix epoch timestamp in milliseconds, separated by colon, or provide a revision string, for example, a Git hash.</p><h4 id="coverage-collection-options" tabindex="-1">Coverage Collection Options <a class="header-anchor" href="#coverage-collection-options" aria-label="Permalink to &quot;Coverage Collection Options&quot;">​</a></h4><p>The instrumenter can pass configuration options to the collector. These options determine how the collector behaves, such as the frequency of coverage dumping.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>  -f CONFIG_ID, --config-id CONFIG_ID</span></span>
<span class="line"><span>	The ID of the profiler configuration to use; this configuration is refetched</span></span>
<span class="line"><span>	from Teamscale once a minute.</span></span></code></pre></div><p>Teamscale enables you to specify configuration parameters for coverage profilers <a href="/reference/ui/project/coverage-profilers/#profiler-configurations">directly in its UI</a>, where profiler configurations are defined using a configuration ID. By providing this configuration ID via <code>--config-id</code> to the instrumented application, the Coverage Collector retrieves the configuration to determine its coverage dumping behavior, such as specifying the coverage dump interval. The configuration format and the available options are the same as to those that can be provided via the instrumenter parameter <code>--collector-config-file</code>; see below for a list of available options.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>  -t COLLECTOR_CONFIG_FILE, --collector-config-file COLLECTOR_CONFIG_FILE</span></span>
<span class="line"><span>	Provide a configuration file that specifies or overwrites the configuration of</span></span>
<span class="line"><span>	the Coverage Collector.</span></span>
<span class="line"><span>  --collector-option COLLECTOR_OPTION, .., COLLECTOR_OPTION</span></span>
<span class="line"><span>	Sets a given collector configuration option. Provided as key=value pairs.</span></span>
<span class="line"><span>  --collector-options-list</span></span>
<span class="line"><span>	Lists the options that can be set for the collector, via a</span></span>
<span class="line"><span>	--collector-config-file or via --collector-option.</span></span></code></pre></div><p>Configuration options can also be passed to the collector either individually via <code>--collector-option KEY=VALUE</code> or grouped together in a configuration file (file with pairs of <code>KEY=VALUE</code>, each on a separate line) via <code>--collector-config-file CONFIG_FILE</code>. The latter option is recommended since it allows for easier maintenance of multiple configuration options. The list of all available collector options that can be configured from the instrumented application can be listed via the <code>--collector-options-list</code> flag. Here is an example of a configuration file content:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>teamscaleProject=powersense</span></span>
<span class="line"><span>teamscalePartition=GenU25-aarch</span></span>
<span class="line"><span>dumpAfterMins=90</span></span></code></pre></div><p>In the paragraphs that follow, we describe the parameters that are available for configuration (corresponding to the listing provided by the <code>--collector-options-list</code> argument).</p><p>The first set of parameters defines the behavior of the <em>Upload to Teamscale</em>:</p><table tabindex="0"><thead><tr><th>Parameter</th><th>Type</th><th>Description</th></tr></thead><tbody><tr><td><code>teamscaleMessage</code></td><td>string</td><td>The commit message shown within Teamscale for the coverage upload.<br>Default: JavaScript coverage upload</td></tr><tr><td><code>teamscalePartition</code></td><td>string</td><td>The partition to upload coverage to.</td></tr><tr><td><code>teamscaleProject</code></td><td>string</td><td>The project ID to upload coverage to.</td></tr><tr><td><code>teamscaleRepository</code></td><td>string</td><td>The repository to upload coverage for. Optional: Only needed when uploading via revision to a project that has more than one connector.</td></tr></tbody></table><p>The <em>Coverage Dumping</em> behavior can be adjusted using the following parameters:</p><table tabindex="0"><thead><tr><th>Parameter</th><th>Type</th><th>Description</th></tr></thead><tbody><tr><td><code>dumpAfterMins</code></td><td>int</td><td>Dump the coverage information every N minutes.<br>Default: 120</td></tr><tr><td><code>dumpToFolder</code></td><td>string</td><td>Coverage should be dumped to a folder on the server that the collector is running on. Specifies the name of the subfolder within the collector&#39;s dump folder (--dump-folder of the collector) where coverage files should be placed.</td></tr><tr><td><code>keepCoverageFiles</code></td><td>bool</td><td>Whether to keep the coverage files on disk after a successful upload to Teamscale</td></tr></tbody></table><p>An <em>Upload to Artifactory</em> can be configured using the following parameters:</p><table tabindex="0"><thead><tr><th>Parameter</th><th>Type</th><th>Description</th></tr></thead><tbody><tr><td><code>artifactoryAccessToken</code></td><td>string</td><td>The access_token for uploading coverage to Artifactory.</td></tr><tr><td><code>artifactoryPassword</code></td><td>string</td><td>The password for uploading coverage to Artifactory. Only needed when not using the --artifactory-access-token option</td></tr><tr><td><code>artifactoryPathSuffix</code></td><td>string</td><td>(optional): The path within the storage location between the default path and the uploaded artifact.</td></tr><tr><td><code>artifactoryServerUrl</code></td><td>string</td><td>Upload the coverage to the given Artifactory server URL. The URL may include a subpath on the artifactory server, e.g. <a href="https://artifactory.acme.com/my-repo/my/subpath" target="_blank" rel="noreferrer">https://artifactory.acme.com/my-repo/my/subpath</a></td></tr><tr><td><code>artifactoryUser</code></td><td>string</td><td>The user for uploading coverage to Artifactory. Only needed when not using the --artifactory-access-token option</td></tr></tbody></table><div class="warning custom-block"><p class="custom-block-title">Security Risk</p><p>When specifying credentials of other services via <code>--collector-config-file</code> or <code>--collector-option</code>, the credentials will be included in the instrumented source code and are thus visible to anyone that can access your deployed application. We recommend you instead give these credentials to the collector directly when launching it.</p></div><h2 id="collector" tabindex="-1">Collector <a class="header-anchor" href="#collector" aria-label="Permalink to &quot;Collector&quot;">​</a></h2><p>The collector is responsible for collecting the coverage which was recorded for your application in the browser, converting it to a coverage report and (optionally) sending it to Teamscale.</p><h3 id="usage-1" tabindex="-1">Usage <a class="header-anchor" href="#usage-1" aria-label="Permalink to &quot;Usage&quot;">​</a></h3><p>The collector is available as a Node.js package with the name <code>@teamscale/coverage-collector</code>. It can be installed and started using the <code>npx</code> command.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">npx</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> @teamscale/coverage-collector</span></span></code></pre></div><p>This will start the collector, listen to coverage on the default port <code>54678</code> and dump it to the <code>./coverage</code> folder.</p><h3 id="options-1" tabindex="-1">Options <a class="header-anchor" href="#options-1" aria-label="Permalink to &quot;Options&quot;">​</a></h3><p>In the following, we have provided a listing of available Coverage Collector command line parameters.</p><div class="info custom-block"><p class="custom-block-title">Environment Variables</p><p>All relevant parameters can also be set via environment variables. For example, instead of the parameter <code>--teamscale-access-token</code>, you can define the environment variable <code>TEAMSCALE_ACCESS_TOKEN</code>. Environment variables are written in <code>UPPERCASE_LETTERS_SEPARATED_BY_UNDERSCORES</code>.</p></div><h4 id="collector-connectivity" tabindex="-1">Collector Connectivity <a class="header-anchor" href="#collector-connectivity" aria-label="Permalink to &quot;Collector Connectivity&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-c, --enable-control-port</code></td><td>Enables the remote control API on the specified port (&lt;=0 means &quot;disabled&quot;). Default <code>0</code></td></tr><tr><td><code>--http-proxy</code></td><td>(optional): The HTTP/HTTPS proxy address that should be used in the format: <code>http://host:port/</code> or <code>http://username:password@host:port/</code>.</td></tr><tr><td><code>-p, --port</code></td><td>The port to receive coverage information on. Default <code>54678</code></td></tr></tbody></table><h4 id="teamscale-server" tabindex="-1">Teamscale Server <a class="header-anchor" href="#teamscale-server" aria-label="Permalink to &quot;Teamscale Server&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-a, --teamscale-access-token</code></td><td>The API key to use for uploading to Teamscale.</td></tr><tr><td><code>-s, --teamscale-server-url</code></td><td>Upload the coverage to the given Teamscale server URL. For example, <code>https://teamscale.dev.example.com:8080</code>.</td></tr><tr><td><code>-u, --teamscale-user</code></td><td>The user for uploading coverage to Teamscale.</td></tr><tr><td><code>--teamscale-project</code></td><td>The project ID to upload coverage to.</td></tr><tr><td><code>--teamscale-partition</code></td><td>The partition to upload coverage to.</td></tr><tr><td><code>--teamscale-revision</code></td><td>The revision (commit hash, version id) to upload coverage for.</td></tr><tr><td><code>--teamscale-commit</code></td><td>The branch and timestamp to upload coverage for, separated by colon. Used if <code>--teamscale-revision</code> can&#39;t be used.</td></tr><tr><td><code>--teamscale-repository</code></td><td>The repository to upload coverage for. Optional: Only needed when uploading via revision to a project that has more than one connector.</td></tr><tr><td><code>--teamscale-message</code></td><td>The commit message shown within Teamscale for the coverage upload.</td></tr></tbody></table><h4 id="coverage-dumping" tabindex="-1">Coverage Dumping <a class="header-anchor" href="#coverage-dumping" aria-label="Permalink to &quot;Coverage Dumping&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-t, --dump-after-mins</code></td><td>Dump the coverage information to the target file every N minutes and (if configured) send it to Teamscale. Default <code>360</code></td></tr><tr><td><code>-f, --dump-folder</code></td><td>Target folder for coverage files. Default <code>./coverage</code></td></tr><tr><td><code>-k, --keep-coverage-files</code></td><td>Whether to keep the coverage files on disk after a successful upload to Teamsacle. Default <code>false</code></td></tr></tbody></table><h4 id="upload-to-artifactory" tabindex="-1">Upload to Artifactory <a class="header-anchor" href="#upload-to-artifactory" aria-label="Permalink to &quot;Upload to Artifactory&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>--artifactory-access-token</code></td><td>The access_token for uploading coverage to Artifactory.</td></tr><tr><td><code>--artifactory-password</code></td><td>The password for uploading coverage to Artifactory. Only needed when not using the <code>--artifactory-access-token</code> option.</td></tr><tr><td><code>--artifactory-path-suffix</code></td><td>(optional): The path within the storage location between the default path and the uploaded artifact.</td></tr><tr><td><code>--artifactory-server-url</code></td><td>Upload the coverage to the given Artifactory server URL. The URL may include a subpath on the artifactory server, e.g. <code>https://artifactory.acme.com/my-repo/my/subpath</code>.</td></tr><tr><td><code>--artifactory-user</code></td><td>The user for uploading coverage to Artifactory. Only needed when not using the <code>--artifactory-access-token</code> option.</td></tr></tbody></table><h4 id="logging-behavior" tabindex="-1">Logging Behavior <a class="header-anchor" href="#logging-behavior" aria-label="Permalink to &quot;Logging Behavior&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>-j, --json-log</code></td><td>Additional JSON-like log file format. Default <code>false</code></td></tr><tr><td><code>-e, --log-level</code></td><td>Log level (<code>trace</code>, <code>debug</code>, <code>info</code>, <code>warn</code>, <code>error</code>). Default <code>info</code></td></tr><tr><td><code>-l, --log-to-file</code></td><td>Log file. Default <code>./logs/collector-combined.log</code></td></tr></tbody></table><h3 id="direct-upload-from-the-collector-to-artifactory" tabindex="-1">Direct Upload from the Collector to Artifactory <a class="header-anchor" href="#direct-upload-from-the-collector-to-artifactory" aria-label="Permalink to &quot;Direct Upload from the Collector to Artifactory&quot;">​</a></h3><p>In case the collector cannot automatically send the coverage to Teamscale because of network restrictions, it can be configured to send the collected coverage directly to your Artifactory. The upload is enabled by setting the URL of the Artifactory server using parameter <code>--artifactory-server-url</code>, along with parameters that define the target partition and commit of the upload:</p><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>--artifactory-server-url</code></td><td>Upload the coverage to the given Artifactory server URL. The URL may include a subpath on the artifactory server, e.g. <code>https://artifactory.acme.com/my-repo/my/subpath</code>.</td></tr><tr><td><code>--artifactory-user</code></td><td>The user for uploading coverage to Artifactory. Only needed when not using the <code>--artifactory-access-token</code> option.</td></tr><tr><td><code>--artifactory-password</code></td><td>The password for uploading coverage to Artifactory. Only needed when not using the <code>--artifactory-access-token</code> option.</td></tr><tr><td><code>--artifactory-access-token</code></td><td>The access_token for uploading coverage to Artifactory.</td></tr><tr><td><code>--artifactory-path-suffix</code></td><td>(optional): The path within the storage location between the default path and the uploaded artifact.</td></tr></tbody></table><h3 id="control-api" tabindex="-1">Control API <a class="header-anchor" href="#control-api" aria-label="Permalink to &quot;Control API&quot;">​</a></h3><p>The upload parameters of the coverage collector can be controlled and queried remotely via a REST API. This API is enabled using the command line parameter <code>--enable-control-port</code>. For example, starting the collector with <code>--enable-control-port 9872</code> makes the API available on port <code>9872</code> via HTTP.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-c ENABLE_CONTROL_PORT, --enable-control-port ENABLE_CONTROL_PORT</span></span></code></pre></div><p>Enables the remote control API on the specified port (&lt;=0 means &quot;disabled&quot;); disabled by default.</p><p>The following REST API methods are available:</p><ul><li><code>[POST] /refresh</code> Instructs the coverage collector to reload all configurations from the Teamscale server.</li><li><code>[POST] /dump</code> Instructs the coverage collector to dump the collected coverage for all applications.</li><li><code>[POST] /dump/{configId}</code> Instructs the coverage collector to dump the collected coverage for all applications with the given config ID for which <code>{configId}</code> is a placeholder.</li><li><code>[POST] /reset</code> Instructs the coverage collector to reset the collected coverage for all applications. This will discard all coverage collected in the current session.</li><li><code>[POST] /reset/{configId}</code> Instructs the coverage collector to reset the collected coverage. This will discard all coverage collected for all applications with the given config ID.</li></ul><p>Note that neither authentication nor transport encryption are required to control the collector. In case this is a strict requirement of your organization, please set up a corresponding reverse proxy that establishes and ensures these properties.</p><h2 id="troubleshooting-1" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting-1" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h2><h3 id="collector-unable-to-verify-the-first-certificate" tabindex="-1">Collector: Unable To Verify The First Certificate <a class="header-anchor" href="#collector-unable-to-verify-the-first-certificate" aria-label="Permalink to &quot;Collector: Unable To Verify The First Certificate&quot;">​</a></h3><p>In many cases, coverage will be uploaded via HTTPS to Teamscale or other REST services that can receive coverage reports. By default, Node.js checks the certificates of these endpoints. That means that uploads to services, for which the certificate cannot be checked, fail with the error <code>unable to verify the first certificate</code>.</p><p>Setting the environment variable <code>NODE_TLS_REJECT_UNAUTHORIZED</code> to <code>0</code> for the Coverage Collector disables the check and is a workaround for this problem. Instead of failing, a warning will be shown in the log that hints at the disabled check.</p><p>We recommend setting up proper CA certificates via the environment variable <code>NODE_EXTRA_CA_CERTS</code>. More details can be found in the official <a href="https://nodejs.org/api/cli.html#node_extra_ca_certsfile" target="_blank" rel="noreferrer">Node.js documentation</a>.</p><h3 id="instrumenter-runs-out-of-memory" tabindex="-1">Instrumenter Runs Out Of Memory <a class="header-anchor" href="#instrumenter-runs-out-of-memory" aria-label="Permalink to &quot;Instrumenter Runs Out Of Memory&quot;">​</a></h3><p>In case the application to instrument is too big, the instrumenter might run out of memory. In this case, you can increase the memory available to Node.js by setting parameter <code>max-old-space-size</code> in the <code>NODE_OPTIONS</code> environment variable.</p><p>We recommend using the <code>cross-env</code> package for setting the <code>NODE_OPTIONS</code> in Node.js environments. For example, <code>cross-env NODE_OPTIONS=&#39;--max-old-space-size=8192&#39; npx @teamscale/javascript-instrumenter</code> will increase the memory limit to 8GB for the given instrumenter invocation.</p><h3 id="instrumented-app-is-slow" tabindex="-1">Instrumented App Is Slow <a class="header-anchor" href="#instrumented-app-is-slow" aria-label="Permalink to &quot;Instrumented App Is Slow&quot;">​</a></h3><p>After instrumenting your application for recording coverage information, it might become significantly slower. One cause of this could be that not only the application code was instrumented, but also the code of the frameworks (for example, Angular or React) and other libraries.</p><p>We recommend instrumenting only that fraction of the application for which you would like to collect coverage information for. See <a href="#instrumentation-excludes">Instrumentation Excludes</a>.</p>`,95))])}const T=d(u,[["render",g]]);export{C as __pageData,T as default};
