/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;

public class StringPatternValidator {
    public static final String COMMON_PATTERN_FOR_KEYS = "^[a-z0-9_]+$";
    private static final String IDENTIFIER_REGEX_DEFINITION = "For %s the entry has to match the regexp %s";
    private final String fieldUnderValidation;
    private final String validCharacterRegex;

    public StringPatternValidator(String fieldUnderValidation, String validCharacterRegex) {
        this.fieldUnderValidation = fieldUnderValidation;
        this.validCharacterRegex = validCharacterRegex;
    }

    public static StringPatternValidator validatorWithCommonPatternForKeys(String fieldUnderValidation) {
        return new StringPatternValidator(fieldUnderValidation, COMMON_PATTERN_FOR_KEYS);
    }

    public boolean isValid(@Nullable String entry) {
        return StringUtils.isNotBlank(entry) && entry.matches(this.validCharacterRegex);
    }

    public String validate(String entry) {
        if (!this.isValid(entry)) {
            throw new IllegalArgumentException(String.format("Entry '%s' is invalid. For %s the entry has to match the regexp %s", entry, this.fieldUnderValidation, this.validCharacterRegex));
        }
        return entry;
    }

    public void validate(Collection<String> entries) {
        Set invalidEntries = entries.stream().filter(entry -> !this.isValid((String)entry)).collect(Collectors.toSet());
        if (!invalidEntries.isEmpty()) {
            throw new IllegalArgumentException(String.format("Entries '%s' are invalid. For %s the entry has to match the regexp %s", String.join((CharSequence)", ", invalidEntries), this.fieldUnderValidation, this.validCharacterRegex));
        }
    }
}

