/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S3972")
public class ConditionalOnNewLineCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S3972";
    private SyntaxToken previousClosingBracketToken;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.IF_STATEMENT, Tree.Kind.ELSEIF_CLAUSE, Tree.Kind.ELSE_CLAUSE);
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken ifToken;
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.previousClosingBracketToken = null;
            return;
        }
        if (tree.is(Tree.Kind.IF_STATEMENT) && this.previousClosingBracketToken != null && (ifToken = ((IfStatementTree)tree).ifToken()).line() == this.previousClosingBracketToken.line()) {
            this.context().newIssue(this, ifToken, "Move this \"if\" to a new line or add the missing \"else\".").secondary(this.previousClosingBracketToken, null);
        }
        this.setPreviousToken(tree);
    }

    private void setPreviousToken(Tree tree) {
        BlockTree blockTree;
        StatementTree statementTree = ConditionalOnNewLineCheck.getConditionalStatement(tree);
        if (statementTree.is(Tree.Kind.BLOCK) && ConditionalOnNewLineCheck.isMultilineBlock(blockTree = (BlockTree)statementTree)) {
            this.previousClosingBracketToken = blockTree.closeCurlyBraceToken();
            return;
        }
        this.previousClosingBracketToken = null;
    }

    private static boolean isMultilineBlock(BlockTree blockTree) {
        return blockTree.openCurlyBraceToken().line() != blockTree.closeCurlyBraceToken().line();
    }

    private static StatementTree getConditionalStatement(Tree tree) {
        List<StatementTree> statementTrees = tree.is(Tree.Kind.IF_STATEMENT) ? ((IfStatementTree)tree).statements() : (tree.is(Tree.Kind.ELSEIF_CLAUSE) ? ((ElseifClauseTree)tree).statements() : ((ElseClauseTree)tree).statements());
        return statementTrees.get(0);
    }
}

