/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.cfg.LiveVariablesAnalysis;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1226")
public class ReassignedBeforeUsedCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Introduce a new variable instead of reusing the parameter \"%s\".";
    private static final String SECONDARY_MESSAGE = "Initial value.";
    private final Set<Symbol> investigatedParameters = new HashSet<Symbol>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.investigatedParameters.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.visitFunctionTree(tree);
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.visitFunctionTree(tree);
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.visitFunctionTree(tree);
        super.visitFunctionExpression(tree);
    }

    private void visitFunctionTree(FunctionTree tree) {
        ControlFlowGraph cfg = ControlFlowGraph.build(tree, this.context());
        if (cfg == null) {
            return;
        }
        LiveVariablesAnalysis analysis = LiveVariablesAnalysis.analyze(cfg, this.context().symbolTable());
        Set<Symbol> live = analysis.getLiveVariables(cfg.start()).getIn();
        for (ParameterTree parameterTree : tree.parameters().parameters()) {
            Symbol symbol;
            if (parameterTree.referenceToken() != null || live.contains(symbol = this.context().symbolTable().getSymbol(parameterTree.variableIdentifier()))) continue;
            this.investigatedParameters.add(symbol);
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            VariableIdentifierTree identifier = (VariableIdentifierTree)tree.variable();
            Symbol reference = this.context().symbolTable().getSymbol(identifier);
            if (reference != null && (reference.is(Symbol.Kind.PARAMETER) || reference.is(Symbol.Kind.VARIABLE)) && this.investigatedParameters.contains(reference)) {
                this.context().newIssue(this, tree, String.format(MESSAGE, reference.name())).secondary(reference.declaration(), SECONDARY_MESSAGE);
                this.investigatedParameters.remove(reference);
            }
        }
        super.visitAssignmentExpression(tree);
    }
}

