/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Define a constant instead of duplicating this literal \"%s\" %s times.";
    private static final String SECONDARY_MESSAGE = "Duplication.";
    private static final Pattern ALLOWED_DUPLICATED_LITERALS = Pattern.compile("^[a-zA-Z_][.\\-\\w]+$");
    private final Map<String, LiteralTree> firstOccurrenceTrees = new HashMap<String, LiteralTree>();
    private final Map<String, List<LiteralTree>> sameLiteralOccurrences = new HashMap<String, List<LiteralTree>>();
    public static final int THRESHOLD_DEFAULT = 3;
    public static final int MINIMAL_LITERAL_LENGTH_DEFAULT = 5;
    @RuleProperty(key="threshold", defaultValue="3")
    int threshold = 3;
    @RuleProperty(key="minimal_literal_length", defaultValue="5")
    int minimalLiteralLength = 5;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.firstOccurrenceTrees.clear();
        this.sameLiteralOccurrences.clear();
        super.visitCompilationUnit(tree);
        this.finish();
    }

    private void finish() {
        for (Map.Entry<String, List<LiteralTree>> literalOccurrences : this.sameLiteralOccurrences.entrySet()) {
            List<LiteralTree> occurrences = literalOccurrences.getValue();
            if (occurrences.size() < this.threshold) continue;
            String literal = literalOccurrences.getKey();
            String message = String.format(MESSAGE, literal, occurrences.size());
            LiteralTree firstOccurrenceTree = this.firstOccurrenceTrees.get(literal);
            PreciseIssue issue = this.context().newIssue(this, firstOccurrenceTree, message).cost(occurrences.size());
            occurrences.stream().filter(o -> !o.equals(firstOccurrenceTree)).forEach(occurrence -> issue.secondary((Tree)occurrence, SECONDARY_MESSAGE));
        }
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal;
        String value;
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && (value = StringUtils.substring(literal = tree.value(), 1, literal.length() - 1)).length() >= this.minimalLiteralLength && !ALLOWED_DUPLICATED_LITERALS.matcher(value).find()) {
            if (!this.sameLiteralOccurrences.containsKey(value)) {
                ArrayList<LiteralTree> occurrences = new ArrayList<LiteralTree>();
                occurrences.add(tree);
                this.sameLiteralOccurrences.put(value, occurrences);
                this.firstOccurrenceTrees.put(value, tree);
            } else {
                this.sameLiteralOccurrences.get(value).add(tree);
            }
        }
    }
}

