/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S905")
public class UselessExpressionStatementCheck
extends PHPVisitorCheck {
    public static final String KEY = "S905";
    private static final String MESSAGE = "Remove or refactor this statement.";
    private static final String MESSAGE_PARTIAL = "This statement part is useless, remove or refactor it.";
    private static final String MESSAGE_OPERATOR = "This binary operation is useless, remove it.";
    private static final Pattern STRING_LITERAL_EXCEPTION_PATTERN = Pattern.compile("@phan-var");
    private static final Tree.Kind[] BINARY_KINDS = new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.REMAINDER, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.INSTANCE_OF, Tree.Kind.ALTERNATIVE_NOT_EQUAL_TO, Tree.Kind.CONCATENATION};
    private static final Tree.Kind[] USELESS_KINDS = new Tree.Kind[]{Tree.Kind.ARROW_FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.EXPANDABLE_STRING_LITERAL, Tree.Kind.NAME_IDENTIFIER, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL};
    private boolean fileContainsHTML;
    private List<Tree> uselessNodes;
    private List<Pair<Tree, Tree>> uselessPartialNodes;
    private List<Tree> uselessOperatorNodes;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.fileContainsHTML = false;
        this.uselessNodes = new ArrayList<Tree>();
        this.uselessPartialNodes = new ArrayList<Pair<Tree, Tree>>();
        this.uselessOperatorNodes = new ArrayList<Tree>();
        super.visitCompilationUnit(tree);
        if (!this.fileContainsHTML) {
            for (Tree tree2 : this.uselessNodes) {
                this.context().newIssue(this, tree2, MESSAGE);
            }
            for (Pair pair : this.uselessPartialNodes) {
                this.context().newIssue(this, (Tree)pair.getLeft(), (Tree)pair.getRight(), MESSAGE_PARTIAL);
            }
            for (Tree tree3 : this.uselessOperatorNodes) {
                this.context().newIssue(this, tree3, MESSAGE_OPERATOR);
            }
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression.is(BINARY_KINDS)) {
            this.checkBinaryExpression((BinaryExpressionTree)expression);
        }
        if (expression.is(USELESS_KINDS)) {
            this.uselessNodes.add(tree);
        }
        if (expression.is(Tree.Kind.REGULAR_STRING_LITERAL) && !STRING_LITERAL_EXCEPTION_PATTERN.matcher(((LiteralTree)expression).value()).find()) {
            this.uselessNodes.add(tree);
        }
        super.visitExpressionStatement(tree);
    }

    private void checkBinaryExpression(BinaryExpressionTree binaryExpression) {
        boolean isLeftUseless = UselessExpressionStatementCheck.isUseless(binaryExpression.leftOperand());
        boolean isRightUseless = UselessExpressionStatementCheck.isUseless(binaryExpression.rightOperand());
        if (isLeftUseless && isRightUseless) {
            this.uselessNodes.add(binaryExpression);
        } else if (isLeftUseless) {
            this.uselessPartialNodes.add(Pair.of(binaryExpression.leftOperand(), binaryExpression.operator()));
        } else if (isRightUseless) {
            this.uselessPartialNodes.add(Pair.of(binaryExpression.operator(), binaryExpression.rightOperand()));
        } else {
            this.uselessOperatorNodes.add(binaryExpression.operator());
        }
    }

    private static boolean isUseless(ExpressionTree expression) {
        if (expression.is(Tree.Kind.FUNCTION_CALL)) {
            return false;
        }
        if (expression.is(BINARY_KINDS)) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)expression;
            return UselessExpressionStatementCheck.isUseless(binaryExpression.leftOperand()) && UselessExpressionStatementCheck.isUseless(binaryExpression.rightOperand());
        }
        return true;
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN) && !CheckUtils.isClosingTag(token)) {
            this.fileContainsHTML = true;
        }
    }
}

