/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.cfg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.php.api.cfg.PhpCfgBlock;
import org.sonar.plugins.php.api.tree.Tree;

class PhpCfgBranchingBlock
extends PhpCfgBlock
implements CfgBranchingBlock {
    private CfgBlock trueSuccessor;
    private CfgBlock falseSuccessor;
    private Tree branchingTree;

    public PhpCfgBranchingBlock(Tree branchingTree, PhpCfgBlock trueSuccessor, PhpCfgBlock falseSuccessor) {
        this.trueSuccessor = trueSuccessor;
        this.falseSuccessor = falseSuccessor;
        this.branchingTree = branchingTree;
    }

    @Override
    public CfgBlock trueSuccessor() {
        return this.trueSuccessor;
    }

    @Override
    public CfgBlock falseSuccessor() {
        return this.falseSuccessor;
    }

    @Override
    public Tree branchingTree() {
        return this.branchingTree;
    }

    @Override
    public Set<CfgBlock> successors() {
        return Collections.unmodifiableSet(new HashSet<CfgBlock>(Arrays.asList(this.trueSuccessor, this.falseSuccessor)));
    }

    @Override
    public void replaceSuccessors(Map<PhpCfgBlock, PhpCfgBlock> replacements) {
        this.trueSuccessor = PhpCfgBranchingBlock.replacement(this.trueSuccessor, replacements);
        this.falseSuccessor = PhpCfgBranchingBlock.replacement(this.falseSuccessor, replacements);
    }
}

