/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.psalm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.php.reports.ExternalIssuesSensor;
import org.sonar.plugins.php.reports.JsonReportReader;
import org.sonar.plugins.php.reports.psalm.PsalmJsonReportReader;
import org.sonar.plugins.php.reports.psalm.PsalmRulesDefinition;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

@ScannerSide
public class PsalmSensor
extends ExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(PsalmSensor.class);
    public static final String PSALM_REPORT_KEY = "psalm";
    public static final String PSALM_REPORT_NAME = "Psalm";
    public static final String PSALM_REPORT_PATH_KEY = "sonar.php.psalm.reportPaths";

    public PsalmSensor(PsalmRulesDefinition psalmRulesDefinition, AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(psalmRulesDefinition, analysisWarningsWrapper);
    }

    @Override
    public void importReport(File report, SensorContext context) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(report);
        LOG.info("Importing {}", (Object)report);
        PsalmJsonReportReader.read(in, issue -> this.saveIssue(context, (JsonReportReader.Issue)issue));
    }

    @Override
    public String reportName() {
        return PSALM_REPORT_NAME;
    }

    @Override
    protected String reportKey() {
        return PSALM_REPORT_KEY;
    }

    @Override
    public String reportPathKey() {
        return PSALM_REPORT_PATH_KEY;
    }

    @Override
    public Logger logger() {
        return LOG;
    }
}

