/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import java.util.ArrayList;
import java.util.Arrays;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class SequenceExpression
implements ParsingExpression {
    private final ParsingExpression[] subExpressions;

    public SequenceExpression(ParsingExpression ... subExpressions) {
        this.subExpressions = subExpressions;
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        for (ParsingExpression subExpression : this.subExpressions) {
            Instruction.addAll(result, compiler.compile(subExpression));
        }
        return result.toArray(new Instruction[result.size()]);
    }

    public String toString() {
        return "Sequence" + Arrays.toString(this.subExpressions);
    }
}

