/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import org.sonarsource.analyzer.commons.ShannonEntropy;

public class EntropyDetector {
    public static final int DEFAULT_MIN_SECRET_LENGTH_FOR_GIVEN_ENTROPY = 25;
    public static final double DEFAULT_ENTROPY_INCREASE_FACTOR_BY_MISSING_CHARACTER = 1.034;
    public static final double DEFAULT_ENTROPY_SCORE_INCREMENT = 0.6;
    private final double minEntropyThreshold;
    private final int minimumSecretLengthForGivenEntropy;
    private final double entropyIncreaseFactorByMissingCharacter;

    public EntropyDetector(double randomnessSensibility) {
        this(randomnessSensibility, 25, 1.034, 0.6);
    }

    public EntropyDetector(double randomnessSensibility, int minimumSecretLengthForGivenEntropy, double entropyIncreaseFactorByMissingCharacter, double entropyScoreIncrement) {
        this.minimumSecretLengthForGivenEntropy = minimumSecretLengthForGivenEntropy;
        this.entropyIncreaseFactorByMissingCharacter = entropyIncreaseFactorByMissingCharacter;
        this.minEntropyThreshold = randomnessSensibility * entropyScoreIncrement;
    }

    public boolean hasEnoughEntropy(String literal) {
        double effectiveMinEntropyThreshold = this.minEntropyThreshold;
        if (literal.length() < this.minimumSecretLengthForGivenEntropy) {
            int missingCharacterCount = this.minimumSecretLengthForGivenEntropy - literal.length();
            effectiveMinEntropyThreshold *= Math.pow(this.entropyIncreaseFactorByMissingCharacter, missingCharacterCount);
        }
        return ShannonEntropy.calculate(literal) >= effectiveMinEntropyThreshold;
    }
}

