/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.error;

import java.util.ArrayList;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExceptionUtils {
    public static void trimStackOverFlowTrace(StackOverflowError e) {
        ArrayList<StackTraceElement> trimmedStackTrace = new ArrayList<StackTraceElement>();
        StackTraceElement previousElement = null;
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement currentElement = stackTrace[i];
            if (currentElement.equals(previousElement)) continue;
            trimmedStackTrace.add(stackTrace[i]);
            previousElement = currentElement;
        }
        e.setStackTrace(trimmedStackTrace.toArray(new StackTraceElement[trimmedStackTrace.size()]));
    }

    public static String getStacktraceAsString(Throwable t) {
        return StringUtils.obtainStackTrace(t);
    }

    public static <T extends Throwable> T withSuppressed(@NonNull T suppressing, @NonNull Throwable suppressed) {
        suppressing.addSuppressed(suppressed);
        return suppressing;
    }

    public static Optional<String> getFirstNonNullCauseMessage(Throwable e) {
        if (e.getMessage() != null) {
            return Optional.of(e.getMessage());
        }
        Throwable currentStack = e;
        while (currentStack.getCause() != null) {
            if ((currentStack = currentStack.getCause()).getMessage() == null) continue;
            return Optional.of(currentStack.getMessage());
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <E extends Exception> void runAllAndAddAsSuppressed(Class<E> exceptionClass, RunnableWithException<? extends E> ... runnables) throws E {
        ExceptionHolder<E> holder = null;
        for (RunnableWithException<E> runnableWithException : runnables) {
            try {
                runnableWithException.run();
            }
            catch (Exception e) {
                if (holder != null) {
                    holder.addSuppressed(e);
                    continue;
                }
                holder = new ExceptionHolder<E>(exceptionClass, e);
            }
        }
        if (holder != null) {
            holder.rethrow();
        }
    }

    private ExceptionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static final class ExceptionHolder<E extends Exception> {
        private final Exception exception;

        private ExceptionHolder(Class<E> exceptionType, Exception exception) {
            CCSMAssert.isNotNull(exceptionType, () -> String.format("Expected \"%s\" to be not null", "exceptionType"));
            CCSMAssert.isNotNull((Object)exception, () -> String.format("Expected \"%s\" to be not null", "exception"));
            if (!(exception instanceof RuntimeException) && !exceptionType.isInstance(exception)) {
                throw new AssertionError("The Expected exception was not of type RuntimeException or " + String.valueOf(exceptionType), exception);
            }
            this.exception = exception;
        }

        private void addSuppressed(Throwable suppressed) {
            if (suppressed != this.exception) {
                this.exception.addSuppressed(suppressed);
            }
        }

        private void rethrow() throws E {
            throw this.exception;
        }
    }
}

