/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ChunkOutputStream
extends OutputStream {
    private int chunkSize;
    private List<byte[]> chunks;
    private byte[] currentChunk;
    private int currentOffset;

    public ChunkOutputStream() {
        this(0x100000);
    }

    public ChunkOutputStream(int chunkSize) {
        CCSMAssert.isTrue(chunkSize >= 1, "chunkSize must be >= 1, is " + chunkSize);
        this.chunkSize = chunkSize;
        this.currentOffset = 0;
        this.chunks = new ArrayList<byte[]>();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public void write(int b) {
        this.updateChunk();
        this.currentChunk[this.currentOffset++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        int writeNow;
        for (int alreadyWritten = 0; alreadyWritten < length; alreadyWritten += writeNow) {
            this.updateChunk();
            writeNow = Math.min(length - alreadyWritten, this.chunkSize - this.currentOffset);
            System.arraycopy(b, offset + alreadyWritten, this.currentChunk, this.currentOffset, writeNow);
            this.currentOffset += writeNow;
        }
    }

    private void updateChunk() {
        if (this.currentOffset == this.chunkSize || this.chunks.isEmpty()) {
            this.currentChunk = new byte[this.chunkSize];
            this.chunks.add(this.currentChunk);
            this.currentOffset = 0;
        }
    }

    public List<byte[]> getChunks() {
        return this.chunks;
    }

    public int getLastChunkSize() {
        return this.currentOffset;
    }

    @Override
    public void close() {
    }
}

