/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.error.MultiIOException;

public class MultiplexedOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public MultiplexedOutputStream(OutputStream ... streams) {
        this.streams = streams;
    }

    @Override
    public void close() throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (OutputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiplexedOutputStream.checkExceptions(exceptions);
    }

    @Override
    public void flush() throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (OutputStream stream : this.streams) {
            try {
                stream.flush();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiplexedOutputStream.checkExceptions(exceptions);
    }

    @Override
    public void write(int b) throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiplexedOutputStream.checkExceptions(exceptions);
    }

    private static void checkExceptions(Collection<IOException> exceptions) throws MultiIOException {
        if (!exceptions.isEmpty()) {
            throw new MultiIOException(exceptions);
        }
    }
}

