/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.net;

import com.google.common.net.UrlEscapers;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class UrlUtils {
    public static final String FILE_PROTOCOL = "file://";
    public static final Pattern URL_PATTERN = Pattern.compile("\\p{Alpha}[\\p{Alnum}+\\-.]*://[\\p{Alnum}:?#/@%_\\-~.\\]\\[!$&')(*+,;=]*");
    private static final Pattern ABSOLUTE_WINDOWS_PATH_PATTERN = Pattern.compile("[a-zA-Z]:([\\\\/](.+[\\\\/])*.*)?");

    public static URI parseUri(String uri) throws URISyntaxException {
        if (uri.startsWith(FILE_PROTOCOL)) {
            uri = uri.replace("+", "%2B");
            uri = UrlUtils.decodeFromUtf8(uri.substring(FILE_PROTOCOL.length()));
            return new File(uri).toURI();
        }
        return new URI(uri);
    }

    public static String ensureParseable(String url) {
        if (ABSOLUTE_WINDOWS_PATH_PATTERN.matcher((CharSequence)url).matches()) {
            url = "/" + (String)url;
        }
        return ((String)url).replace("\\", "/");
    }

    public static String encodeMultiplePathSegments(String pathSegments) {
        return Arrays.stream(pathSegments.split("/")).map(UrlUtils::encodePathSegment).collect(Collectors.joining("/"));
    }

    public static String encodePathSegment(String pathSegment) {
        return UrlEscapers.urlPathSegmentEscaper().escape(pathSegment);
    }

    public static String encodeQueryParameter(String queryParameter) {
        return UrlEscapers.urlFormParameterEscaper().escape(queryParameter);
    }

    public static String decodeFromUtf8(String urlString) {
        return URLDecoder.decode(urlString, StandardCharsets.UTF_8);
    }

    private UrlUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

