/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public interface IDetailedInstanceComparisonContribution
extends Serializable {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static InstanceComparisonDiffEntryExamples computeExamples(String key, @Nullable IDetailedInstanceComparisonContribution localDetails, @Nullable IDetailedInstanceComparisonContribution remoteDetails) {
        @Nullable Map localDetailedValues = Optional.ofNullable(localDetails).map(d -> d.getDetailedValues(key)).orElseGet(Collections::emptyMap);
        @Nullable Map remoteDetailedValues = Optional.ofNullable(remoteDetails).map(d -> d.getDetailedValues(key)).orElseGet(Collections::emptyMap);
        return IDetailedInstanceComparisonContribution.computeExamples(localDetailedValues, remoteDetailedValues);
    }

    private static @NonNull InstanceComparisonDiffEntryExamples computeExamples(@NonNull Map<String, @Nullable DetailedInstanceComparisonValue> localDetailedValues, @NonNull Map<String, @Nullable DetailedInstanceComparisonValue> remoteDetailedValues) {
        Consumer<DetailedInstanceComparisonValue> consumerForValuesFromLargerMap;
        Map<String, DetailedInstanceComparisonValue> largerValues;
        Consumer<DetailedInstanceComparisonValue> consumerForValuesFromSmallerMap;
        Map<String, DetailedInstanceComparisonValue> smallerValues;
        InstanceComparisonDiffEntryExamples examples = new InstanceComparisonDiffEntryExamples();
        if (localDetailedValues.size() > remoteDetailedValues.size()) {
            smallerValues = remoteDetailedValues;
            consumerForValuesFromSmallerMap = examples::addMissingLocal;
            largerValues = localDetailedValues;
            consumerForValuesFromLargerMap = examples::addMissingRemote;
        } else {
            smallerValues = localDetailedValues;
            consumerForValuesFromSmallerMap = examples::addMissingRemote;
            largerValues = remoteDetailedValues;
            consumerForValuesFromLargerMap = examples::addMissingLocal;
        }
        largerValues = new LinkedHashMap<String, DetailedInstanceComparisonValue>(largerValues);
        for (Map.Entry<String, DetailedInstanceComparisonValue> detailedValue : smallerValues.entrySet()) {
            String key = detailedValue.getKey();
            if (!largerValues.containsKey(key)) {
                consumerForValuesFromSmallerMap.accept(detailedValue.getValue());
            }
            largerValues.remove(key);
        }
        largerValues.values().forEach(consumerForValuesFromLargerMap);
        return examples;
    }

    public @NonNull Map<String, @Nullable DetailedInstanceComparisonValue> getDetailedValues(String var1);
}

