/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.write;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.backup.BackupUtils;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.EBackupZipFileVersion;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupWritingParameters;
import com.teamscale.index.backup.write.EBackupExportExcludeOptions;
import com.teamscale.index.backup.write.EExternalDataExportGranularity;
import com.teamscale.index.backup.write.EExternalDataExportTarget;
import com.teamscale.index.backup.write.ExternalUploadExportOption;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import com.teamscale.index.configuration.service.EMetricThresholdConfigurationVersion;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.ExternalUploadIndexUtils;
import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.tools.ExternalAnalysisResultIndexUtils;
import com.teamscale.index.external.tools.ExternalArchitectureUploadIndexMinimizer;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.ExternalNonCodeMetricsDescriptionIndex;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.crypto.EncryptingStore;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.transaction.TransactionalStore;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.persistence.store.util.StoreFactory;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.string.StringUtils;

public class BackupWriter {
    public static final String TEAMSCALE_VERSION_ENTRY_NAME = "Teamscale-Version";
    public static final String BACKUP_ZIP_FILE_VERSION_ENTRY_NAME = "Backup-Zip-File-Version";
    public static final String ENCRYPTED_STORES_ENTRY_NAME = "Encrypted-Stores";
    public static final String ENCRYPTED_STORES_PREFIX = "Following stores have been encrypted:";
    public static final String PROJECT_CONFIGURATION_ENTRY_NAME = "Project-Config";
    private static final String GLOBAL_DATA_FOLDER_PREFIX = "__";
    public static final String ANALYSIS_PROFILE_ENTRY_PREFIX = "__analysis_profiles/";
    public static final String METRIC_THRESHOLD_CONFIGURATION_ENTRY_PREFIX = "__threshold_configurations/";
    public static final String[] GLOBAL_DATA_PREFIXES = new String[]{"__analysis_profiles/", "__threshold_configurations/"};
    private final BackupWritingParameters parameters;
    private final ICancelable cancelable;
    private final List<String> encryptedStores = new ArrayList<String>();

    public BackupWriter(BackupWritingParameters parameters, ICancelable cancelable) {
        this.parameters = parameters;
        this.cancelable = cancelable;
    }

    public void writeBackupZip(OutputStream out, BackupExportStatus exportStatus) throws IOException, StorageException, ExecutionCanceledException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(out);){
            zos.setUseZip64(Zip64Mode.Always);
            BackupWriter.writeVersionEntries(zos, this.getBackupArtifactVersion(EStorageSystemVersion.class));
            StoreFactory.runWithTemporaryOnDiskStoreFactory(storeFactory -> {
                try {
                    this.writeGlobalAndProjectStores(exportStatus, zos, (StoreFactory)storeFactory);
                }
                catch (IOException | JsonSerializationException e) {
                    throw new StorageException(e);
                }
                catch (ExecutionCanceledException executionCanceledException) {
                    // empty catch block
                }
            }, (File)StoreFactory.createTemporaryStorageDirectory((File)this.parameters.getTempDataStorageDirectory(), (String)"__write"), (DatabaseConfiguration)this.parameters.getInstanceConfiguration().getDatabaseConfiguration());
            this.cancelable.verifyNotCanceled();
            this.writeEncryptedStores(zos);
            exportStatus.setStatusAndMessage(EBackupStatus.SUCCESS, "Backup export completed");
        }
    }

    private void writeGlobalAndProjectStores(BackupExportStatus exportStatus, ZipArchiveOutputStream zos, StoreFactory storeFactory) throws IOException, StorageException, ExecutionCanceledException, JsonSerializationException {
        if (this.parameters.getBackupExportOptions().isExportGlobalData()) {
            this.writeGlobalStores(zos, exportStatus, storeFactory);
        }
        this.writeProjectStores(zos, exportStatus, storeFactory);
    }

    private static void writeVersionEntries(ZipArchiveOutputStream zos, EStorageSystemVersion storageSystemVersion) throws IOException {
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(TEAMSCALE_VERSION_ENTRY_NAME);
        zos.putArchiveEntry(zipEntry);
        zos.write(StringUtils.stringToBytes((String)storageSystemVersion.name()));
        zos.closeArchiveEntry();
        ZipArchiveEntry fileVersionEntry = new ZipArchiveEntry(BACKUP_ZIP_FILE_VERSION_ENTRY_NAME);
        zos.putArchiveEntry(fileVersionEntry);
        zos.write(StringUtils.stringToBytes((String)EBackupZipFileVersion.CURRENT_VERSION.name()));
        zos.closeArchiveEntry();
    }

    public static void writeVersionEntries(ZipArchiveOutputStream zos) throws IOException {
        BackupWriter.writeVersionEntries(zos, EStorageSystemVersion.CURRENT_VERSION);
    }

    private <T extends MetaIndex.IMetaIndexEntry> T getBackupArtifactVersion(Class<T> clazz) throws StorageException {
        MetaIndex.IMetaIndexEntry artifactVersion = this.parameters.getIndexLayer().openMetaIndex().getValue(clazz);
        CCSMAssert.isNotNull((Object)artifactVersion, (String)("Artifact version for " + String.valueOf(clazz) + " not in meta index"));
        return (T)artifactVersion;
    }

    private void writeEncryptedStores(ZipArchiveOutputStream zos) throws IOException, StorageException {
        StringBuilder builder = new StringBuilder("Following stores have been encrypted:\n");
        this.encryptedStores.stream().sorted().forEach(store -> builder.append((String)store).append("\n"));
        byte[] content = StringUtils.stringToBytes((String)builder.toString());
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(ENCRYPTED_STORES_ENTRY_NAME);
        zos.putArchiveEntry(zipEntry);
        zos.write(EncryptedStorageHandler.encrypt((byte[])content, (SecretKeySpec)BackupWriter.determineEncryptionKey()));
        zos.closeArchiveEntry();
    }

    private static SecretKeySpec determineEncryptionKey() throws IOException {
        if (EncryptedStorageHandler.isPrimaryKeySet()) {
            return EncryptedStorageHandler.getPrimaryKey();
        }
        try {
            return EncryptedStorageHandler.getDefaultKey();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProjectStores(ZipArchiveOutputStream zos, BackupExportStatus exportStatus, StoreFactory storeFactory) throws IOException, StorageException, ExecutionCanceledException, JsonSerializationException {
        ProjectIndex projectIndex = this.parameters.getIndexLayer().openProjectIndex();
        for (PublicProjectId projectId : projectIndex.getAllPrimaryPublicProjectIds()) {
            if (!this.parameters.getBackupExportOptions().isProjectIncluded(projectId)) continue;
            this.cancelable.verifyNotCanceled();
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
            PublicProjectId publicId = projectInfo.getPrimaryPublicId();
            InternalProjectId internalId = projectInfo.getInternalId();
            BackupWriter.writeDirectoryEntry(zos, publicId);
            Lock projectLock = this.parameters.getLockProvider().obtainLock("re_analyze_project_store_" + String.valueOf(projectId));
            Lock tempProjectLock = this.parameters.getLockProvider().obtainLock("re_analyze_temp_store_" + String.valueOf(projectId));
            Lock lock = BackupWriter.getLock(projectLock, tempProjectLock, (ProjectInfo)projectIndex.getProjectWithoutPublicIdResolution(internalId).orElseThrow());
            try {
                InternalProjectId internalProjectId = internalId;
                if (lock == tempProjectLock) {
                    internalProjectId = new InternalProjectId("re_analyze_temp_partition_" + String.valueOf(internalId));
                }
                this.importStoresInBackup(zos, exportStatus, storeFactory, projectId, internalProjectId, publicId, projectInfo);
            }
            finally {
                lock.unlock();
            }
            exportStatus.info("Backup of project " + BackupWriter.formatProjectName(projectInfo) + " completed");
        }
    }

    private void importStoresInBackup(ZipArchiveOutputStream zos, BackupExportStatus exportStatus, StoreFactory storeFactory, PublicProjectId projectId, InternalProjectId internalProjectId, PublicProjectId publicId, ProjectInfo projectInfo) throws StorageException, IOException, JsonSerializationException, ExecutionCanceledException {
        CommitResolvingStorageSystem projectStorageSystem = this.parameters.getIndexLayer().openProjectStorageSystem((IProjectId)internalProjectId);
        this.writeProjectConfigurationEntry(zos, publicId, (ProjectStorageSystem)projectStorageSystem);
        IndexSchema projectSchema = projectStorageSystem.getSchema();
        Set<String> storesToBackup = this.getStoresToBackup(projectSchema);
        int count = 0;
        for (String storeName : storesToBackup) {
            this.cancelable.verifyNotCanceled();
            exportStatus.setStatusMessage("Exporting store " + storeName + " for project " + BackupWriter.formatProjectName(projectInfo) + " (" + ++count + " of " + storesToBackup.size() + ")");
            this.writeStore(zos, projectId, storeName, projectStorageSystem.openStore(storeName), projectSchema.getEntry(storeName), storeFactory);
        }
    }

    private static String formatProjectName(ProjectInfo projectInfo) {
        return projectInfo.getName() + " (" + String.valueOf(projectInfo.getPrimaryPublicId()) + ")";
    }

    private static Lock getLock(Lock projectLock, Lock tempProjectLock, ProjectInfo projectInfo) {
        while (!projectLock.tryLock()) {
            if (projectInfo.isDeletingOrReanalyzing() && tempProjectLock.tryLock()) {
                return tempProjectLock;
            }
            ThreadUtils.sleep((long)1000L);
        }
        return projectLock;
    }

    private static void writeDirectoryEntry(ZipArchiveOutputStream zos, PublicProjectId directory) throws IOException {
        ZipArchiveEntry dir = new ZipArchiveEntry(String.valueOf(directory) + "/");
        zos.putArchiveEntry(dir);
        zos.closeArchiveEntry();
    }

    private void writeProjectConfigurationEntry(ZipArchiveOutputStream zos, PublicProjectId project, ProjectStorageSystem projectStorageSystem) throws IOException, StorageException, JsonSerializationException {
        ProjectConfiguration configuration = ProjectConfigurationUtils.getProjectConfigurationWithoutEmbeddedProfile((ProjectStorageSystem)projectStorageSystem);
        EProjectConfigurationVersion projectConfigurationVersion = this.getBackupArtifactVersion(EProjectConfigurationVersion.class);
        String xmlContent = TeamscaleVersionContainer.toJson((Object)configuration, (Enum)projectConfigurationVersion);
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(String.valueOf(project) + "/Project-Config");
        zos.putArchiveEntry(zipEntry);
        zos.write(StringUtils.stringToBytes((String)xmlContent));
        zos.closeArchiveEntry();
    }

    private void writeGlobalStores(ZipArchiveOutputStream zipOutputStream, BackupExportStatus exportStatus, StoreFactory storeFactory) throws IOException, StorageException, ExecutionCanceledException, JsonSerializationException {
        GlobalStorageSystem globalStorageSystem = this.parameters.getIndexLayer().openGlobalStorageSystem();
        IndexSchema schema = globalStorageSystem.getSchema();
        Set<String> storesToBackup = this.getStoresToBackup(schema);
        int count = 0;
        block11: for (String storeName : storesToBackup) {
            this.cancelable.verifyNotCanceled();
            exportStatus.setStatusMessage("Exporting global store " + storeName + " (" + ++count + " of " + storesToBackup.size() + ")");
            switch (storeName) {
                case "metric-threshold-configurations": {
                    this.exportThresholdConfigurations(zipOutputStream, (MetricThresholdConfigurationIndex)globalStorageSystem.openGlobalIndex(MetricThresholdConfigurationIndex.class));
                    continue block11;
                }
                case "external-findings-groups-descriptions": 
                case "external-metrics": 
                case "external-non-code-metrics": 
                case "analysis-profiles": {
                    continue block11;
                }
            }
            this.writeStore(zipOutputStream, null, storeName, globalStorageSystem.openStore(storeName), schema.getEntry(storeName), storeFactory);
        }
        this.writeAnalysisProfiles(zipOutputStream, (AnalysisProfileIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class));
        BackupWriter.writeExternalFindingsDefinitions(zipOutputStream, (ExternalFindingsGroupDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class));
        BackupWriter.writeExternalMetricsDefinitions(zipOutputStream, "custom-external-metrics/metric-entries.json", (ExternalMetricsDescriptionIndexBase)globalStorageSystem.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class));
        BackupWriter.writeExternalMetricsDefinitions(zipOutputStream, "custom-external-metrics/non-code-metric-entries.json", (ExternalMetricsDescriptionIndexBase)globalStorageSystem.openGlobalIndex(ExternalNonCodeMetricsDescriptionIndex.class));
        exportStatus.info("Completed backup of global data");
    }

    private void writeAnalysisProfiles(ZipArchiveOutputStream zipOutputStream, AnalysisProfileIndex analysisProfileIndex) throws IOException, StorageException, JsonSerializationException {
        if (this.parameters.getBackupExportOptions().getExportExcludeOptions().contains((Object)EBackupExportExcludeOptions.ANALYSIS_PROFILES)) {
            return;
        }
        List analysisProfiles = analysisProfileIndex.getAllProfiles();
        EAnalysisProfileVersion analysisProfileVersion = this.getBackupArtifactVersion(EAnalysisProfileVersion.class);
        FunctionWithException toJsonFunction = configuration -> TeamscaleVersionContainer.toJson((Object)((AnalysisProfile)configuration), (Enum)analysisProfileVersion);
        BackupWriter.exportJsonConfiguration(zipOutputStream, analysisProfiles, ANALYSIS_PROFILE_ENTRY_PREFIX, "tsanalysisprofile", (FunctionWithException<NamedConfigurableObjectBase, String, JsonSerializationException>)toJsonFunction);
    }

    private void exportThresholdConfigurations(ZipArchiveOutputStream zipOutputStream, MetricThresholdConfigurationIndex thresholdConfigurationIndex) throws IOException, StorageException, JsonSerializationException {
        List configurationEntries = thresholdConfigurationIndex.getAllThresholdConfigurations().extractSecondList();
        EMetricThresholdConfigurationVersion metricThresholdConfigurationVersion = this.getBackupArtifactVersion(EMetricThresholdConfigurationVersion.class);
        FunctionWithException toJsonFunction = configuration -> TeamscaleVersionContainer.toJson((Object)((MetricThresholdConfiguration)configuration), (Enum)metricThresholdConfigurationVersion);
        BackupWriter.exportJsonConfiguration(zipOutputStream, configurationEntries, METRIC_THRESHOLD_CONFIGURATION_ENTRY_PREFIX, "tsthresholds", (FunctionWithException<NamedConfigurableObjectBase, String, JsonSerializationException>)toJsonFunction);
    }

    private static void exportJsonConfiguration(ZipArchiveOutputStream zipOutputStream, List<? extends NamedConfigurableObjectBase> configurationEntries, String folderPrefix, String fileExtension, FunctionWithException<NamedConfigurableObjectBase, String, JsonSerializationException> toJsonFunction) throws IOException, JsonSerializationException {
        HashSet<String> usedNames = new HashSet<String>();
        for (NamedConfigurableObjectBase namedConfigurableObjectBase : configurationEntries) {
            String name = FileSystemUtils.toSafeFilename((String)namedConfigurableObjectBase.getName());
            name = StringUtils.createUniqueName((String)name, usedNames);
            usedNames.add(name);
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(folderPrefix + name + "." + fileExtension);
            zipOutputStream.putArchiveEntry(zipEntry);
            String xml = (String)toJsonFunction.apply((Object)namedConfigurableObjectBase);
            zipOutputStream.write(StringUtils.stringToBytes((String)xml));
            zipOutputStream.closeArchiveEntry();
        }
    }

    private void writeStore(ZipArchiveOutputStream zipOutputStream, @Nullable PublicProjectId projectId, String storeName, IStore store, SchemaEntry schemaEntry, StoreFactory storeFactory) throws IOException, StorageException {
        boolean encrypted;
        if (projectId != null) {
            storeName = String.valueOf(projectId) + "/" + (String)storeName;
        }
        if (encrypted = EncryptedStorageHandler.isEncrypted((SchemaEntry)schemaEntry)) {
            store = new EncryptingStore(store);
            this.encryptedStores.add((String)storeName);
        }
        ZipArchiveEntry zipEntry = new ZipArchiveEntry((String)storeName);
        zipOutputStream.putArchiveEntry(zipEntry);
        IStore storeToWrite = this.applyExternalDataFiltering(projectId, store, schemaEntry, storeFactory);
        if (encrypted) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StorageUtils.exportStore((IStore)storeToWrite, (DataOutputStream)dos);
            dos.close();
            zipOutputStream.write(EncryptedStorageHandler.encrypt((byte[])baos.toByteArray(), (SecretKeySpec)BackupWriter.determineEncryptionKey()));
        } else {
            DataOutputStream dos = new DataOutputStream((OutputStream)zipOutputStream);
            StorageUtils.exportStore((IStore)storeToWrite, (DataOutputStream)dos);
            dos.flush();
        }
        zipOutputStream.closeArchiveEntry();
    }

    private IStore applyExternalDataFiltering(@Nullable PublicProjectId projectId, IStore store, SchemaEntry schemaEntry, StoreFactory storeFactory) throws StorageException {
        if (ExternalAnalysisResultIndex.class.getName().equals(schemaEntry.getIndexClass())) {
            return this.applyExternalDataFiltering(projectId, store, schemaEntry, storeFactory, EExternalDataExportTarget.EXTERNAL_DATA, (commitDescriptor, skippedCommits, inputStore, outputStore) -> ExternalAnalysisResultIndexUtils.copyCommit(commitDescriptor, inputStore, outputStore), (BiFunctionWithException<IStore, CommitDescriptor, String, StorageException>)((BiFunctionWithException)(store1, commit) -> ((ExternalAnalysisCommitInfo)((Object)((Object)ExternalAnalysisResultIndexUtils.createInputIndex(commit, store1).getCommitInfo()))).getPartition()));
        }
        if (ExternalArchitectureUploadIndex.class.getName().equals(schemaEntry.getIndexClass())) {
            return this.applyExternalDataFiltering(projectId, store, schemaEntry, storeFactory, EExternalDataExportTarget.ARCHITECTURES, BackupWriter::copyArchitectureCommit, (BiFunctionWithException<IStore, CommitDescriptor, String, StorageException>)((BiFunctionWithException)(ignoredStore, ignoredCommit) -> null));
        }
        if (DotNetVersionIndex.class.getName().equals(schemaEntry.getIndexClass())) {
            return this.applyStoreFiltering(projectId, store, schemaEntry, storeFactory, EExternalDataExportTarget.DOTNET_PDBS, BackupWriter::applyDotNetVersionFiltering);
        }
        if (DotNetMethodMappingIndex.class.getName().equals(schemaEntry.getIndexClass())) {
            return this.applyExternalDataFiltering(projectId, store, schemaEntry, storeFactory, EExternalDataExportTarget.DOTNET_PDBS, (copyCommit, skippedCommits, inputStore, outputStore) -> BackupWriter.copyDotNetMethodMapping(copyCommit, inputStore, outputStore, storeFactory), (BiFunctionWithException<IStore, CommitDescriptor, String, StorageException>)((BiFunctionWithException)(ignoredStore, ignoredCommit) -> null));
        }
        return store;
    }

    private IStore applyStoreFiltering(@Nullable PublicProjectId projectId, IStore rawInputStore, SchemaEntry schemaEntry, StoreFactory storeFactory, EExternalDataExportTarget target, IExternalDataStoreTransfer storeTransfer) throws StorageException {
        List<ExternalUploadExportOption> exportOptions = this.geApplicableExternalUploadExportOptions(target);
        if (exportOptions.isEmpty()) {
            return rawInputStore;
        }
        IStore rawOutputStore = storeFactory.create();
        IStore outputStore = BackupWriter.compressIfNeeded(rawOutputStore, schemaEntry);
        IStore inputStore = BackupWriter.compressIfNeeded(rawInputStore, schemaEntry);
        storeTransfer.copyStore(projectId, exportOptions, inputStore, outputStore);
        return rawOutputStore;
    }

    private IStore applyExternalDataFiltering(@Nullable PublicProjectId projectId, IStore rawInputStore, SchemaEntry schemaEntry, StoreFactory storeFactory, EExternalDataExportTarget target, IExternalDataCommitTransfer commitTransfer, BiFunctionWithException<IStore, CommitDescriptor, @Nullable String, StorageException> partitionResolver) throws StorageException {
        return this.applyStoreFiltering(projectId, rawInputStore, schemaEntry, storeFactory, target, (project, exportOptions, inputStore, outputStore) -> BackupWriter.applyExternalDataFiltering(project, commitTransfer, partitionResolver, exportOptions, inputStore, outputStore));
    }

    private static void applyExternalDataFiltering(@Nullable PublicProjectId projectId, IExternalDataCommitTransfer commitTransfer, BiFunctionWithException<IStore, CommitDescriptor, @Nullable String, StorageException> partitionResolver, List<ExternalUploadExportOption> exportOptions, IStore inputStore, IStore outputStore) throws StorageException {
        CommitLayeringBranchingLayer branchingLayer = new CommitLayeringBranchingLayer(inputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        List commits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)branchingLayer);
        ByBranchAndPartitionCommitManager lastAddedCommitManager = new ByBranchAndPartitionCommitManager();
        HashMap skippedCommitsByBranch = new HashMap();
        for (ParentedCommitDescriptor commit : commits) {
            String branchName = commit.getBranchName();
            String partition = (String)partitionResolver.apply((Object)inputStore, (Object)commit);
            if (BackupWriter.shouldSkipCommit(projectId, exportOptions, (CommitDescriptor)commit, partition, (CommitDescriptor)lastAddedCommitManager.getByBranchAndPartition(commit.getBranchName(), partition))) {
                skippedCommitsByBranch.computeIfAbsent(commit.getBranchName(), x -> new ArrayList()).add(commit);
                continue;
            }
            ParentedCommitDescriptor lastAddedCommit = lastAddedCommitManager.getByBranch(branchName);
            List<ParentedCommitDescriptor> skippedCommits = skippedCommitsByBranch.getOrDefault(branchName, Collections.emptyList());
            ParentedCommitDescriptor commitToAdd = BackupWriter.buildNewCommit(branchName, commit.getTimestamp(), lastAddedCommit);
            BackupWriter.transferCommitWithRetry(inputStore, commitTransfer, commitToAdd, skippedCommits, outputStore, branchingLayer);
            skippedCommits.clear();
            lastAddedCommitManager.setCommit(branchName, partition, commitToAdd);
        }
    }

    private static void applyDotNetVersionFiltering(@Nullable PublicProjectId projectId, List<ExternalUploadExportOption> exportOptions, IStore inputStore, IStore outputStore) throws StorageException {
        DotNetVersionIndex inputIndex = new DotNetVersionIndex(inputStore);
        DotNetVersionIndex outputIndex = new DotNetVersionIndex(outputStore);
        PairList allVersions = (PairList)inputIndex.getAllVersions().stream().filter(entry -> !BackupWriter.shouldSkipCommit(projectId, exportOptions, (CommitDescriptor)entry.getSecond(), null, null)).collect(PairList.toPairList());
        outputIndex.setVersions((PairList<String, CommitDescriptor>)allVersions);
    }

    private static void transferCommitWithRetry(IStore inputStore, IExternalDataCommitTransfer commitTransfer, ParentedCommitDescriptor commitToAdd, List<ParentedCommitDescriptor> skippedCommits, IStore outputStore, CommitLayeringBranchingLayer branchingLayer) throws StorageException {
        ExternalUploadIndexUtils.copyCommitWithRetry((CommitDescriptor)commitToAdd, () -> commitTransfer.copyCommit(commitToAdd, skippedCommits, inputStore, outputStore), (RunnableWithException<StorageException>)((RunnableWithException)() -> branchingLayer.recalculateHeadCommitPointer(commitToAdd.getBranchName())));
    }

    private static IStore compressIfNeeded(IStore store, SchemaEntry schemaEntry) {
        if (schemaEntry.usesOption(EStorageOption.COMPRESSED)) {
            return new CompressingStore(store);
        }
        return store;
    }

    private static boolean shouldSkipCommit(@Nullable PublicProjectId projectId, List<ExternalUploadExportOption> exportOptions, CommitDescriptor commit, String partition, CommitDescriptor lastAddedCommit) {
        EExternalDataExportGranularity granularity = BackupWriter.determineGranularity(projectId, exportOptions, commit.getBranchName(), partition, commit.getTimestamp());
        return !BackupWriter.shouldAddCommit(commit.getTimestamp(), granularity, lastAddedCommit);
    }

    private static ParentedCommitDescriptor buildNewCommit(String branchName, long timestamp, ParentedCommitDescriptor lastAddedCommit) {
        if (lastAddedCommit == null) {
            return new ParentedCommitDescriptor(branchName, timestamp, new CommitDescriptor[0]);
        }
        return new ParentedCommitDescriptor(branchName, timestamp, new CommitDescriptor[]{new CommitDescriptor((CommitDescriptor)lastAddedCommit)});
    }

    private static void copyArchitectureCommit(ParentedCommitDescriptor copyCommit, List<ParentedCommitDescriptor> skippedCommits, IStore inputStore, IStore outputStore) throws StorageException {
        HashMap<String, String> latestContentByPath = new HashMap<String, String>();
        HashSet<String> deletedArchitecturePaths = new HashSet<String>();
        for (ParentedCommitDescriptor commit : skippedCommits) {
            BackupWriter.updateArchitectureChanges(commit, inputStore, deletedArchitecturePaths, latestContentByPath);
        }
        ArchitectureUploadInfo latestArchitectureUpload = BackupWriter.updateArchitectureChanges(copyCommit, inputStore, deletedArchitecturePaths, latestContentByPath);
        ArrayList uniformPaths = CollectionUtils.sort(latestContentByPath.keySet());
        List architectures = CollectionUtils.map((Collection)uniformPaths, latestContentByPath::get);
        ArchitectureUploadInfo newArchitectureUpload = new ArchitectureUploadInfo(latestArchitectureUpload.getUsername(), latestArchitectureUpload.getMessage(), uniformPaths, architectures, CollectionUtils.sort(deletedArchitecturePaths));
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)copyCommit.getBranchName(), (long)copyCommit.getTimestamp());
        if (!copyCommit.getParentCommits().isEmpty()) {
            historyAccess.setExplicitParentCommit(copyCommit.getFirstParentCommit().getBranchName(), copyCommit.getFirstParentCommit().getTimestamp());
        }
        ExternalArchitectureUploadIndex index = new ExternalArchitectureUploadIndex(historyAccess.createStore(outputStore, ExternalArchitectureUploadIndexMinimizer.EXTERNAL_ARCHITECTURE_UPLOAD_INDEX_SCHEMA));
        index.setCommitInfo(newArchitectureUpload);
    }

    private static void copyDotNetMethodMapping(ParentedCommitDescriptor copyCommit, IStore inputStore, IStore outputStore, StoreFactory storeFactory) throws StorageException {
        SchemaEntry schemaEntry = new SchemaEntry(DotNetMethodMappingIndex.class);
        DotNetMethodMappingIndex inputIndex = new DotNetMethodMappingIndex(HistoryAccessOption.readTimestamp((String)copyCommit.getBranchName(), (long)copyCommit.getTimestamp()).createStore(inputStore, schemaEntry));
        PairList<String, SourceLocation> sourceLocations = inputIndex.getAllMappings();
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)copyCommit.getBranchName(), (long)copyCommit.getTimestamp());
        if (!copyCommit.getParentCommits().isEmpty()) {
            historyAccess.setExplicitParentCommit(copyCommit.getFirstParentCommit().getBranchName(), copyCommit.getFirstParentCommit().getTimestamp());
        }
        TransactionalStore writeStore = new TransactionalStore(historyAccess.createStore(outputStore, schemaEntry), (IFactory)storeFactory);
        DotNetMethodMappingIndex outputIndex = new DotNetMethodMappingIndex((IStore)writeStore);
        outputIndex.removeAllMappings();
        outputIndex.setMappings(sourceLocations);
        writeStore.commit();
    }

    private static ArchitectureUploadInfo updateArchitectureChanges(ParentedCommitDescriptor commit, IStore inputStore, Set<String> deletedArchitecturePaths, Map<String, String> latestArchitectureContent) throws StorageException {
        ExternalArchitectureUploadIndex index = new ExternalArchitectureUploadIndex(HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()).createStore(inputStore, ExternalArchitectureUploadIndexMinimizer.EXTERNAL_ARCHITECTURE_UPLOAD_INDEX_SCHEMA));
        ArchitectureUploadInfo commitInfo = (ArchitectureUploadInfo)index.getCommitInfo();
        deletedArchitecturePaths.addAll(commitInfo.getDeletedArchitectures());
        CollectionUtils.removeAll(latestArchitectureContent.keySet(), commitInfo.getDeletedArchitectures());
        for (int i = 0; i < commitInfo.getUniformPaths().size(); ++i) {
            String uniformPath = commitInfo.getUniformPaths().get(i);
            String content = commitInfo.getArchitectures().get(i);
            deletedArchitecturePaths.remove(uniformPath);
            latestArchitectureContent.put(uniformPath, content);
        }
        return commitInfo;
    }

    private static boolean shouldAddCommit(long commitTimestamp, EExternalDataExportGranularity exportGranularity, CommitDescriptor commit) {
        return switch (exportGranularity) {
            default -> throw new MatchException(null, null);
            case EExternalDataExportGranularity.DISCARD_ALL -> false;
            case EExternalDataExportGranularity.KEEP_ALL -> true;
            case EExternalDataExportGranularity.KEEP_DAILY -> {
                if (commit == null || commitTimestamp - commit.getTimestamp() > 86400000L) {
                    yield true;
                }
                yield false;
            }
            case EExternalDataExportGranularity.KEEP_WEEKLY -> commit == null || commitTimestamp - commit.getTimestamp() > 604800000L;
        };
    }

    private static EExternalDataExportGranularity determineGranularity(@Nullable PublicProjectId projectId, List<ExternalUploadExportOption> options, String branchName, @Nullable String partition, long timestamp) {
        for (ExternalUploadExportOption option : options) {
            if (!option.isApplicableFor(projectId, branchName, partition, timestamp)) continue;
            return option.getGranularity();
        }
        return EExternalDataExportGranularity.KEEP_ALL;
    }

    private List<ExternalUploadExportOption> geApplicableExternalUploadExportOptions(EExternalDataExportTarget target) {
        return CollectionUtils.filter(this.parameters.getBackupExportOptions().getExternalUploadExportOptions(), option -> option.isApplicableFor(target));
    }

    private Set<String> getStoresToBackup(IndexSchema indexSchema) {
        HashSet<String> storesToBackup = new HashSet<String>();
        UnmodifiableSet storeNames = indexSchema.getEntryNames();
        Set<EBackupExportExcludeOptions> exportExcludeOptions = this.parameters.getBackupExportOptions().getExportExcludeOptions();
        Set excludedIndexes = exportExcludeOptions.stream().filter(option -> !option.setExcludeIndexBasedOnSuffix()).map(EBackupExportExcludeOptions::getIndexesToExclude).flatMap(Collection::stream).collect(Collectors.toSet());
        Set excludedIndexSuffixes = exportExcludeOptions.stream().filter(EBackupExportExcludeOptions::setExcludeIndexBasedOnSuffix).map(EBackupExportExcludeOptions::getIndexesToExclude).flatMap(Collection::stream).collect(Collectors.toSet());
        for (String storeName : storeNames) {
            SchemaEntry entry = indexSchema.getEntry(storeName);
            if (excludedIndexes.contains(storeName)) continue;
            if (excludedIndexSuffixes.stream().anyMatch(storeName::endsWith) || !entry.getStorageOptions().contains((Object)EStorageOption.BACKUP)) continue;
            storesToBackup.add(storeName);
        }
        return storesToBackup;
    }

    private static void writeExternalMetricsDefinitions(ZipArchiveOutputStream zipOutputStream, String entryName, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws IOException, StorageException {
        String json = JsonUtils.serializeToJSON(externalMetricsDescriptionIndex.getAllMetrics());
        BackupWriter.writeByteArrayToZipFile(zipOutputStream, json.getBytes(StandardCharsets.UTF_8), entryName);
    }

    private static void writeExternalFindingsDefinitions(ZipArchiveOutputStream zipOutputStream, ExternalFindingsGroupDescriptionIndex index) throws IOException, StorageException {
        for (EAnalysisTool analysisTool : EAnalysisTool.CUSTOM_FINDINGS_TOOLS) {
            String descriptionStoragePath = BackupUtils.getExternalFindingDescriptionsPath(analysisTool);
            String groupStoragePath = BackupUtils.getExternalFindingGroupsPath(analysisTool);
            String descriptionsJson = JsonUtils.serializeToJSON(index.getDescriptions(analysisTool));
            BackupWriter.writeByteArrayToZipFile(zipOutputStream, StringUtils.stringToBytes((String)descriptionsJson), descriptionStoragePath);
            String groupsJson = JsonUtils.serializeToJSON(index.getGroups(analysisTool));
            BackupWriter.writeByteArrayToZipFile(zipOutputStream, StringUtils.stringToBytes((String)groupsJson), groupStoragePath);
        }
    }

    public static void writeByteArrayToZipFile(ZipArchiveOutputStream zipOutputStream, byte[] data, String storagePath) throws IOException {
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(storagePath);
        zipOutputStream.putArchiveEntry(zipEntry);
        zipOutputStream.write(data);
        zipOutputStream.closeArchiveEntry();
    }

    @FunctionalInterface
    private static interface IExternalDataCommitTransfer {
        public void copyCommit(ParentedCommitDescriptor var1, List<ParentedCommitDescriptor> var2, IStore var3, IStore var4) throws StorageException, InconsistentCommitException;
    }

    @FunctionalInterface
    private static interface IExternalDataStoreTransfer {
        public void copyStore(@Nullable PublicProjectId var1, List<ExternalUploadExportOption> var2, IStore var3, IStore var4) throws StorageException;
    }

    private static class ByBranchAndPartitionCommitManager {
        private final Map<ImmutablePair<String, String>, ParentedCommitDescriptor> commitByBranchAndPartition = new HashMap<ImmutablePair<String, String>, ParentedCommitDescriptor>();
        private final Map<String, ParentedCommitDescriptor> commitByBranch = new HashMap<String, ParentedCommitDescriptor>();

        private ByBranchAndPartitionCommitManager() {
        }

        public ParentedCommitDescriptor getByBranchAndPartition(String branch, String partition) {
            return this.commitByBranchAndPartition.get(new ImmutablePair((Object)branch, (Object)partition));
        }

        public ParentedCommitDescriptor getByBranch(String branch) {
            return this.commitByBranch.get(branch);
        }

        public void setCommit(String branch, String partition, ParentedCommitDescriptor commit) {
            this.commitByBranchAndPartition.put((ImmutablePair<String, String>)new ImmutablePair((Object)branch, (Object)partition), commit);
            this.commitByBranch.put(branch, commit);
        }
    }
}

