/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.baseline;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="baselines", options={EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK})
public class BaselineIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "baselines";
    private final ValueIndex<BaselineInfo> delegate;

    public BaselineIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable BaselineInfo getBaseline(String baselineName) throws StorageException {
        return (BaselineInfo)this.delegate.getValue(baselineName);
    }

    public List<BaselineInfo> getAllBaselines() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public List<String> getAllBaselineNames() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public void setBaseline(String baselineName, BaselineInfo baseline) throws StorageException {
        this.delegate.setValue(baselineName, (Object)baseline);
    }

    public void removeBaseline(String baselineName) throws StorageException {
        this.delegate.removeValue(baselineName);
    }
}

