/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import com.teamscale.core.analysis.configuration.model.option.JsonOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.NumberOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholdsOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringListOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringSetOptionDescriptor;
import eu.cqse.check.framework.core.option.ICheckOption;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CheckOptionDescriptor<T>
implements IConfigOptionDescriptorBehaviour {
    private static final Set<Class<?>> TYPES_WITHOUT_MULTILINE_EDIT_SUPPORT = CollectionUtils.asHashSet((Object[])new Class[]{Boolean.class, Integer.class, Long.class, NumericThresholds.class});
    private T value = null;
    private final ICheckOption<T> option;

    public CheckOptionDescriptor(ICheckOption<T> option) {
        CCSMAssert.isNotNull(option);
        this.option = option;
    }

    public String getName() {
        return this.option.getName();
    }

    public Class<T> getType() {
        return this.option.getType();
    }

    public String getTypeName() {
        return this.getType().getSimpleName();
    }

    public T retrieveValue(CodeScopeName codeScopeName) {
        if (this.value == null) {
            return (T)this.option.getDefaultValue();
        }
        return this.value;
    }

    public @NonNull UnmodifiableList<T> retrieveValues() {
        return CollectionUtils.asUnmodifiable(Collections.singletonList(this.retrieveValue(null)));
    }

    public Object retrieveDefaultValue() {
        return this.option.getDefaultValue();
    }

    public void storeValue(Object value, CodeScopeName codeScopeName) {
        this.value = this.getType().cast(value);
    }

    public T getValue() {
        return this.value;
    }

    public ConfigOptionDescriptorBase wrapIntoConfigOptionDescriptor() {
        Class<T> type = this.getType();
        this.assertValidMultilineSupportUsage(type);
        if (type == Boolean.class) {
            return new BooleanOptionDescriptor(this.option.getName(), this.option.getDescription(), (IConfigOptionDescriptorBehaviour)this);
        }
        if (type == Integer.class) {
            return new NumberOptionDescriptor(this.option.getName(), this.option.getDescription(), (IConfigOptionDescriptorBehaviour)this, Integer::valueOf);
        }
        if (type == Long.class) {
            return new NumberOptionDescriptor(this.option.getName(), this.option.getDescription(), (IConfigOptionDescriptorBehaviour)this, Long::valueOf);
        }
        if (type == String.class) {
            return new StringOptionDescriptor(this.option.getName(), this.option.getDescription(), this.option.isMultilineText(), (IConfigOptionDescriptorBehaviour)this);
        }
        if (type == NumericThresholds.class) {
            return new NumericThresholdsOptionDescriptor(this.option.getName(), this.option.getDescription(), (IConfigOptionDescriptorBehaviour)this);
        }
        if (type == JsonNode.class) {
            return new JsonOptionDescriptor(this.option.getName(), this.option.getDescription(), (IConfigOptionDescriptorBehaviour)this);
        }
        if (List.class.isAssignableFrom(type)) {
            return new StringListOptionDescriptor(this.option.getName(), this.option.getDescription(), this.option.isMultilineText(), (IConfigOptionDescriptorBehaviour)this);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new StringSetOptionDescriptor(this.option.getName(), this.option.getDescription(), this.option.isMultilineText(), (IConfigOptionDescriptorBehaviour)this);
        }
        throw new AssertionError((Object)("Unsupported option type: " + String.valueOf(type)));
    }

    private void assertValidMultilineSupportUsage(Class<T> type) throws AssertionError {
        CCSMAssert.isFalse((this.option.isMultilineText() && TYPES_WITHOUT_MULTILINE_EDIT_SUPPORT.contains(type) ? 1 : 0) != 0, (String)("Multiline editing not supported for option with type " + type.getSimpleName()));
    }
}

