/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.code_clones.CloneAnalysisUtils;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CloneChunkIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @StepParameter(value="ignored-pattern", optional=true)
    private final List<String> ignoredUniformPathPatterns = new ArrayList<String>();
    @StepParameter(value="clone-detection-enablement", optional=true)
    private CodeScopeAware<Boolean> cloneDetectionEnablement = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @StepParameter(value="chunk-length", optional=true)
    private int chunkLength = 5;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CloneChunkByPathIndex cloneChunkIndex;

    public void execute() throws StorageException, ExecutionException {
        List addedOrChangedKeysAsStrings;
        this.cloneChunkIndex.setChunkLength(this.chunkLength);
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            this.cloneChunkIndex.removePaths(this.contentDelta.getDeletedKeysAsStrings());
        }
        if ((addedOrChangedKeysAsStrings = this.contentDelta.getAddedOrChangedKeysAsStrings()).isEmpty()) {
            return;
        }
        PatternList compiledIgnoredUniformPathPatterns = CloneAnalysisUtils.compileUniformPathPatterns(this.ignoredUniformPathPatterns);
        this.executeInParallelBatches(addedOrChangedKeysAsStrings, paths -> {
            List<TokenElementInfo> tokenElementInfos = this.contentIndex.getTokenElements((List<String>)paths, true);
            List filteredElements = CollectionUtils.filter(tokenElementInfos, element -> CloneAnalysisUtils.isNonIgnoredElement(element, this.cloneDetectionEnablement, compiledIgnoredUniformPathPatterns));
            this.cloneChunkIndex.insertFiles(filteredElements, this.chunkLength);
        });
    }
}

