/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.google.common.base.Verify;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.code_clones.CloneAnalysisUtils;
import com.teamscale.index.code_clones.CloneClassIndex;
import com.teamscale.index.code_clones.CloneClassInfo;
import com.teamscale.index.code_clones.CloneComponentHelper;
import com.teamscale.index.code_clones.CloneInfo;
import com.teamscale.index.code_clones.CloneListIndex;
import com.teamscale.index.code_clones.CloneToInfoConverter;
import com.teamscale.index.code_clones.CloneWiaUtils;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.wia.WiaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;

public class CloneDetectionResultSynchronizer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CLONES_FINDING_GROUP = "Clones";
    public static final String CROSS_COMPONENT_CLONES_FINDING_GROUP = "Cross Component Clones";
    public static final String INTRA_COMPONENT_CLONES_FINDING_GROUP = "Intra Component Clones";
    public static final String SPECIFICATION_CLONES_FINDING_GROUP = "Specification Clones";
    private static final int MAX_CLONE_SIBLINGS = 16;
    public static final String INSTANCES_PROPERTY = "Instances";
    public static final String LENGTH_PROPERTY = "Length";
    public static final String GAPS_PROPERTY = "Gaps";
    private static final String COMPONENT_PROPERTY = "Components";
    static final String CLONE_FINDINGS_PARTITION = "clones";
    private static final String CROSS_COMPONENT_CLONE_FINDINGS_PARTITION = "cross-component-clones";
    private static final String INTRA_COMPONENT_CLONE_FINDINGS_PARTITION = "intra-component-clones";
    public static final String UNITS_PARTITION = "units";
    public static final String CLONED_UNITS_PARTITION = "cloned-units";
    public static final String CROSS_COMPONENT_CLONED_UNITS_PARTITION = "cross-component-cloned-units";
    public static final String INTRA_COMPONENT_CLONED_UNITS_PARTITION = "intra-component-cloned-units";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CloneListIndex cloneListIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CloneClassIndex cloneClassIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;
    public static final String ENABLE_CLONE_COVERAGE_METRIC_PARAMETER = "enable-clone-coverage-metric";
    public static final String REPORT_NORMAL_CLONES_PARAMETER = "report-normal-clones";
    @StepParameter(value="enable-clone-coverage-metric")
    private CodeScopeAware<Boolean> enableCloneCoverageMetric = CodeScopeAware.empty();
    @StepParameter(value="report-normal-clones")
    private CodeScopeAware<Boolean> reportNormalClones = CodeScopeAware.empty();
    public static final String REPORT_CROSS_COMPONENT_CLONES_PARAMETER = "report-cross-component-clones";
    public static final String REPORT_INTRA_COMPONENT_CLONES_PARAMETER = "report-intra-component-clones";
    @StepParameter(value="report-cross-component-clones", optional=true)
    private boolean reportCrossComponentClones = false;
    @StepParameter(value="report-intra-component-clones", optional=true)
    private boolean reportIntraComponentClones = false;
    public static final String CROSS_COMPONENT_CLONES_ARCHITECTURE_PARAMETER = "cross-component-clones-architecture";
    public static final String EXCLUSIVE_INTRA_COMPONENT_DETECTION_PARAMETER = "exclusive-intra-component-detection";
    public static final String DEFAULT_CROSS_COMPONENT_CLONES_ARCHITECTURE = "clone_analysis_components.architecture";
    @StepParameter(value="cross-component-clones-architecture", optional=true)
    private String crossComponentClonesArchitecture = "clone_analysis_components.architecture";
    @StepParameter(value="exclusive-intra-component-detection", optional=true)
    private boolean exclusiveIntraComponentDetection = false;
    private CloneComponentHelper componentHelper = null;
    private final Map<String, CloneClassInfo> newCloneClassValues = new HashMap<String, CloneClassInfo>();

    public boolean reportCrossOrIntraComponentClones() {
        return this.reportCrossComponentClones || this.reportIntraComponentClones;
    }

    public String getCrossComponentClonesArchitectureFile() {
        return this.crossComponentClonesArchitecture;
    }

    public boolean useExclusiveIntraComponentDetection() {
        return this.exclusiveIntraComponentDetection;
    }

    public void verifyCodeScopeConfiguration() throws ProjectConfigurationException {
        Set scopesWithFindings = this.reportNormalClones.parameter().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (scopesWithFindings.isEmpty()) {
            return;
        }
        List<String> scopesWithMetricButNoFinding = this.enableCloneCoverageMetric.parameter().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).filter(Predicate.not(scopesWithFindings::contains)).map(CodeScopeName::toString).sorted().toList();
        if (!scopesWithMetricButNoFinding.isEmpty()) {
            throw new ProjectConfigurationException("Since code clone findings are enabled in at least one code scope, the code clone coverage metric can be enabled only if code clone findings are also enabled in the respective code scope. The following code scopes violate this constraint: " + String.join((CharSequence)", ", scopesWithMetricButNoFinding));
        }
    }

    public List<String> getPathsOfChangedCloneClasses(List<String> inputPaths) throws StorageException {
        List<String> cloneClassIds = this.cloneListIndex.getCloneLists(inputPaths).stream().filter(Objects::nonNull).flatMap(Collection::stream).map(CloneInfo::getCloneClassId).distinct().toList();
        List<String> result = this.cloneClassIndex.getCloneClasses(cloneClassIds).stream().filter(Objects::nonNull).flatMap(cloneClass -> cloneClass.getClones().stream()).map(CloneInfo::getUniformPath).toList();
        this.cloneClassIndex.removeCloneClasses(cloneClassIds);
        return result;
    }

    public void persistDetectionResults(List<String> uniformPaths, Collection<CloneClass> cloneClasses, Map<String, Integer> uniformPathToUnitCount, CloneComponentHelper componentHelper, Map<String, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        this.componentHelper = componentHelper;
        ListMap uniformPathToIntraComponentClones = new ListMap();
        ListMap uniformPathToCrossComponentClones = new ListMap();
        if (this.exclusiveIntraComponentDetection) {
            cloneClasses.stream().flatMap(cloneClass -> cloneClass.getClones().stream()).forEach(clone -> uniformPathToIntraComponentClones.add((Object)clone.getUniformPath(), clone));
            this.persistClonesAndFindingsForExclusiveIntra(uniformPaths, (ListMap<String, Clone>)uniformPathToIntraComponentClones, uniformPathToCodeScope);
        } else {
            Predicate<CloneClass> isCrossComponent = null;
            if (componentHelper != null) {
                isCrossComponent = componentHelper.getCrossComponentPredicate(CloneAnalysisUtils.getCloneUniformPaths(cloneClasses));
            }
            CloneDetectionResultSynchronizer.partitionCrossAndIntraComponentClones(cloneClasses, isCrossComponent, (ListMap<String, Clone>)uniformPathToCrossComponentClones, (ListMap<String, Clone>)uniformPathToIntraComponentClones);
            this.persistClonesAndFindings(uniformPaths, (ListMap<String, Clone>)uniformPathToIntraComponentClones, (ListMap<String, Clone>)uniformPathToCrossComponentClones, uniformPathToCodeScope);
        }
        this.persistMetrics(uniformPaths, (ListMap<String, Clone>)uniformPathToIntraComponentClones, (ListMap<String, Clone>)uniformPathToCrossComponentClones, uniformPathToUnitCount, uniformPathToCodeScope);
    }

    private static void partitionCrossAndIntraComponentClones(@NonNull Collection<CloneClass> cloneClasses, @Nullable Predicate<CloneClass> isCrossComponent, @NonNull ListMap<String, Clone> uniformPathToCrossComponentClones, @NonNull ListMap<String, Clone> uniformPathToIntraComponentClones) {
        for (CloneClass cloneClass : cloneClasses) {
            if (isCrossComponent != null && isCrossComponent.test(cloneClass)) {
                cloneClass.getClones().forEach(clone -> uniformPathToCrossComponentClones.add((Object)clone.getUniformPath(), clone));
                continue;
            }
            cloneClass.getClones().forEach(clone -> uniformPathToIntraComponentClones.add((Object)clone.getUniformPath(), clone));
        }
    }

    private void persistClonesAndFindings(List<String> uniformPaths, ListMap<String, Clone> uniformPathToIntraComponentClones, ListMap<String, Clone> uniformPathToCrossComponentClones, Map<String, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        PairList newCloneListValues = new PairList();
        PairList newCloneFindingValues = new PairList();
        PairList newCrossComponentCloneFindingValues = new PairList();
        PairList newIntraComponentCloneFindingValues = new PairList();
        this.collectValues(uniformPaths, uniformPathToIntraComponentClones, uniformPathToCrossComponentClones, (PairList<String, ArrayList<CloneInfo>>)newCloneListValues, (PairList<String, ArrayList<IndexFinding>>)newCloneFindingValues, (PairList<String, ArrayList<IndexFinding>>)newCrossComponentCloneFindingValues, (PairList<String, ArrayList<IndexFinding>>)newIntraComponentCloneFindingValues, uniformPathToCodeScope);
        if (!newCloneListValues.isEmpty()) {
            this.cloneListIndex.setCloneLists((PairList<String, ArrayList<CloneInfo>>)newCloneListValues);
        }
        CodeScopeAware<FindingsSchema> findingSchemasPerCodeScope = this.getFindingSchemasPerCodeScope(uniformPathToCodeScope);
        if (!this.reportCrossOrIntraComponentClones() && !newCloneFindingValues.isEmpty()) {
            this.findingsIndex.setFindings(CLONE_FINDINGS_PARTITION, newCloneFindingValues, findingSchemasPerCodeScope, uniformPathToCodeScope);
        }
        if (this.reportCrossComponentClones && !newCrossComponentCloneFindingValues.isEmpty()) {
            this.findingsIndex.setFindings(CROSS_COMPONENT_CLONE_FINDINGS_PARTITION, newCrossComponentCloneFindingValues, findingSchemasPerCodeScope, uniformPathToCodeScope);
        }
        if (this.reportIntraComponentClones && !newIntraComponentCloneFindingValues.isEmpty()) {
            this.findingsIndex.setFindings(INTRA_COMPONENT_CLONE_FINDINGS_PARTITION, newIntraComponentCloneFindingValues, findingSchemasPerCodeScope, uniformPathToCodeScope);
        }
    }

    private CodeScopeAware<FindingsSchema> getFindingSchemasPerCodeScope(Map<String, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        LinkedHashSet<CodeScopeName> codeScopeNames = new LinkedHashSet<CodeScopeName>(uniformPathToCodeScope.values());
        return this.findingsSchemaIndex.getFindingSchemasPerCodeScope(codeScopeNames);
    }

    private void collectValues(List<String> uniformPaths, ListMap<String, Clone> uniformPathToIntraComponentClones, ListMap<String, Clone> uniformPathToCrossComponentClones, PairList<String, ArrayList<CloneInfo>> newCloneListValues, PairList<String, ArrayList<IndexFinding>> newCloneFindingValues, PairList<String, ArrayList<IndexFinding>> newCrossComponentCloneFindingValues, PairList<String, ArrayList<IndexFinding>> newIntraComponentCloneFindingValues, Map<String, CodeScopeName> uniformPathToCodeScope) {
        CloneToInfoConverter cloneToInfoConverter = new CloneToInfoConverter(this.newCloneClassValues);
        for (String uniformPath : uniformPaths) {
            ArrayList<Clone> clones = new ArrayList<Clone>(uniformPathToIntraComponentClones.getCollectionOrEmpty((Object)uniformPath));
            clones.addAll(uniformPathToCrossComponentClones.getCollectionOrEmpty((Object)uniformPath));
            newCloneListValues.add((Object)uniformPath, cloneToInfoConverter.convertClones(clones));
            if (WiaUtils.isWorkItemPath((String)uniformPath)) {
                newCloneFindingValues.add((Object)uniformPath, this.convertToFindings(clones, SPECIFICATION_CLONES_FINDING_GROUP, ""));
            } else if (((Boolean)this.reportNormalClones.getValue(uniformPathToCodeScope.get(uniformPath))).booleanValue()) {
                newCloneFindingValues.add((Object)uniformPath, this.convertToFindings(clones, CLONES_FINDING_GROUP, ""));
            }
            if (this.reportCrossComponentClones) {
                newCrossComponentCloneFindingValues.add((Object)uniformPath, this.convertToFindings((List)uniformPathToCrossComponentClones.getCollectionOrEmpty((Object)uniformPath), CROSS_COMPONENT_CLONES_FINDING_GROUP, "Cross Component "));
            }
            if (!this.reportIntraComponentClones) continue;
            newIntraComponentCloneFindingValues.add((Object)uniformPath, this.convertToFindings((List)uniformPathToIntraComponentClones.getCollectionOrEmpty((Object)uniformPath), INTRA_COMPONENT_CLONES_FINDING_GROUP, "Intra Component "));
        }
    }

    private void persistClonesAndFindingsForExclusiveIntra(List<String> uniformPaths, ListMap<String, Clone> uniformPathToIntraComponentClones, Map<String, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        Verify.verify((this.exclusiveIntraComponentDetection && this.reportIntraComponentClones && !this.reportCrossComponentClones ? 1 : 0) != 0);
        Verify.verifyNotNull((Object)this.componentHelper);
        PairList newCloneListValues = new PairList();
        PairList newIntraComponentCloneFindingValues = new PairList();
        this.collectValuesIntra(uniformPaths, uniformPathToIntraComponentClones, (PairList<String, ArrayList<CloneInfo>>)newCloneListValues, (PairList<String, ArrayList<IndexFinding>>)newIntraComponentCloneFindingValues);
        if (!newCloneListValues.isEmpty()) {
            this.cloneListIndex.setCloneLists((PairList<String, ArrayList<CloneInfo>>)newCloneListValues);
        }
        if (!newIntraComponentCloneFindingValues.isEmpty()) {
            CodeScopeAware<FindingsSchema> findingSchemasPerCodeScope = this.getFindingSchemasPerCodeScope(uniformPathToCodeScope);
            this.findingsIndex.setFindings(INTRA_COMPONENT_CLONE_FINDINGS_PARTITION, newIntraComponentCloneFindingValues, findingSchemasPerCodeScope, uniformPathToCodeScope);
        }
    }

    private void collectValuesIntra(List<String> uniformPaths, ListMap<String, Clone> uniformPathToIntraComponentClones, PairList<String, ArrayList<CloneInfo>> newCloneListValues, PairList<String, ArrayList<IndexFinding>> newIntraComponentCloneFindingValues) {
        TypeToComponentMapper.MappingResult componentMapping = this.componentHelper.createComponentMappingForPaths(uniformPaths);
        CloneToInfoConverter cloneToInfoConverter = new CloneToInfoConverter(this.newCloneClassValues);
        for (String uniformPath : uniformPaths) {
            List clones = (List)uniformPathToIntraComponentClones.getCollection((Object)uniformPath);
            Set<ComponentNode> componentsForPath = componentMapping.getMappedComponentsForType(uniformPath);
            if (clones == null || clones.isEmpty()) {
                if (componentsForPath.isEmpty()) continue;
                newCloneListValues.add((Object)uniformPath, new ArrayList(0));
                newIntraComponentCloneFindingValues.add((Object)uniformPath, new ArrayList(0));
                continue;
            }
            if (componentsForPath.isEmpty()) {
                LOGGER.error("Encountered path that is not mapped to a component but contains clones. Skipping.\npath='{}'\nclones={}", (Object)uniformPath, (Object)clones);
                continue;
            }
            newCloneListValues.add((Object)uniformPath, cloneToInfoConverter.convertClones(clones));
            ArrayList<IndexFinding> findings = new ArrayList<IndexFinding>(clones.size());
            if (componentsForPath.size() > 1) {
                CloneDetectionResultSynchronizer.collectExclusiveIntraFindingsInSharedPath(clones, findings);
            } else {
                CloneDetectionResultSynchronizer.collectExclusiveIntraFindingsInUnsharedPath(clones, findings);
            }
            newIntraComponentCloneFindingValues.add((Object)uniformPath, findings);
        }
    }

    private static void collectExclusiveIntraFindingsInUnsharedPath(@NonNull Collection<Clone> clones, @NonNull ArrayList<IndexFinding> findings) {
        for (Clone clone : clones) {
            CloneClass cloneClass = clone.getCloneClass();
            TextRegionLocation cloneLocation = clone.getLocation();
            String message = "Intra-component Clone in '%s' with %d instances of length %d".formatted(clone.getComponent(), cloneClass.size(), clone.getLengthInUnits());
            List<TextRegionLocation> siblings = cloneClass.getClones().stream().map(Clone::getLocation).filter(location -> !location.equals((Object)cloneLocation)).distinct().toList();
            IndexFinding finding = CloneDetectionResultSynchronizer.createExclusiveIntraFinding(message, cloneLocation, cloneClass.size(), clone.getLengthInUnits(), List.of(clone.getComponent()), siblings);
            findings.add(finding);
        }
    }

    private static void collectExclusiveIntraFindingsInSharedPath(@NonNull Collection<Clone> clones, @NonNull ArrayList<IndexFinding> findings) {
        ListMap locationToClones = new ListMap();
        clones.forEach(clone -> locationToClones.add((Object)clone.getLocation(), clone));
        for (Map.Entry entry : locationToClones.entrySet()) {
            List locationClones = (List)entry.getValue();
            TextRegionLocation location = (TextRegionLocation)entry.getKey();
            if (locationClones.size() < 2) {
                CloneDetectionResultSynchronizer.collectExclusiveIntraFindingsInUnsharedPath(Collections.singletonList((Clone)locationClones.getFirst()), findings);
                continue;
            }
            List<String> componentNames = locationClones.stream().map(Clone::getComponent).distinct().sorted().toList();
            List totalClones = locationClones.stream().flatMap(clone -> clone.getCloneClass().getClones().stream()).toList();
            List<TextRegionLocation> siblings = totalClones.stream().map(Clone::getLocation).filter(cloneLocation -> !cloneLocation.equals((Object)location)).distinct().toList();
            int instanceCount = siblings.size() + 1;
            int lengthInUnits = ((Clone)locationClones.getFirst()).getLengthInUnits();
            String message = "Intra-component Clone for %d components with %d instances of length %d".formatted(componentNames.size(), instanceCount, lengthInUnits);
            IndexFinding finding = CloneDetectionResultSynchronizer.createExclusiveIntraFinding(message, location, instanceCount, lengthInUnits, componentNames, siblings);
            findings.add(finding);
        }
    }

    private static @NonNull IndexFinding createExclusiveIntraFinding(String message, TextRegionLocation location, int instanceCount, int lengthInUnits, Collection<String> componentNames, Collection<TextRegionLocation> siblings) {
        IndexFinding finding = new IndexFinding(INTRA_COMPONENT_CLONES_FINDING_GROUP, "Redundancy", message, (ElementLocation)location);
        finding.setProperty(INSTANCES_PROPERTY, (Object)instanceCount);
        finding.setProperty(LENGTH_PROPERTY, (Object)lengthInUnits);
        finding.setProperty(COMPONENT_PROPERTY, (Object)String.join((CharSequence)", ", componentNames));
        siblings.stream().limit(16L).forEach(arg_0 -> ((IndexFinding)finding).addSiblingLocation(arg_0));
        return finding;
    }

    private ArrayList<IndexFinding> convertToFindings(List<Clone> clones, String findingGroup, String messagePrefix) {
        return new ArrayList<IndexFinding>(CollectionUtils.map(clones, clone -> this.convertToFinding((Clone)clone, findingGroup, messagePrefix)));
    }

    private IndexFinding convertToFinding(Clone clone, String findingGroup, String messagePrefix) {
        String message = messagePrefix + "Clone with " + clone.getCloneClass().size() + " instances of length " + clone.getLengthInUnits();
        IndexFinding finding = new IndexFinding(findingGroup, "Redundancy", message, (ElementLocation)CloneWiaUtils.getWorkItemCloneLocation(clone).orElse(clone.getLocation()));
        finding.setProperty(INSTANCES_PROPERTY, (Object)clone.getCloneClass().size());
        finding.setProperty(LENGTH_PROPERTY, (Object)clone.getLengthInUnits());
        finding.setProperty(GAPS_PROPERTY, (Object)clone.gapCount());
        int siblingCount = 0;
        for (Clone sibling : clone.getCloneClass().getClones()) {
            if (sibling.equals(clone)) continue;
            finding.addSiblingLocation((ElementLocation)CloneWiaUtils.getWorkItemCloneLocation(sibling).orElse(sibling.getLocation()));
            if (++siblingCount < 16) continue;
            break;
        }
        if (this.componentHelper != null && findingGroup.equals(CROSS_COMPONENT_CLONES_FINDING_GROUP)) {
            finding.setProperty(COMPONENT_PROPERTY, (Object)this.componentHelper.getCachedCrossComponentNames(clone).orElse("-UNKNOWN-"));
        }
        return finding;
    }

    private void persistMetrics(List<String> uniformPaths, ListMap<String, Clone> uniformPathToIntraComponentClones, ListMap<String, Clone> uniformPathToCrossComponentClones, Map<String, Integer> uniformPathToUnitCount, Map<String, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        ListMap uniformPathToAllClones = new ListMap(uniformPathToIntraComponentClones);
        uniformPathToAllClones.addAll(uniformPathToCrossComponentClones);
        PairList unitsValues = new PairList();
        PairList allClonedUnitsValues = new PairList();
        PairList crossComponentClonedUnitsValues = new PairList();
        PairList intraComponentClonedUnitsValues = new PairList();
        for (String uniformPath : uniformPaths) {
            if (WiaUtils.isWorkItemPath((String)uniformPath)) continue;
            Integer unitCount = uniformPathToUnitCount.get(uniformPath);
            if (unitCount == null) {
                LOGGER.error("Missing unit count for {}. Cannot update metrics.", (Object)uniformPath);
                continue;
            }
            unitsValues.add((Object)uniformPath, (Object)unitCount);
            if (((Boolean)this.enableCloneCoverageMetric.getValue(uniformPathToCodeScope.get(uniformPath))).booleanValue()) {
                allClonedUnitsValues.add((Object)uniformPath, (Object)CloneDetectionResultSynchronizer.calculateCloneUnits((List)uniformPathToAllClones.getCollectionOrEmpty((Object)uniformPath)));
            }
            if (!this.reportCrossOrIntraComponentClones()) continue;
            crossComponentClonedUnitsValues.add((Object)uniformPath, (Object)CloneDetectionResultSynchronizer.calculateCloneUnits((List)uniformPathToCrossComponentClones.getCollectionOrEmpty((Object)uniformPath)));
            intraComponentClonedUnitsValues.add((Object)uniformPath, (Object)CloneDetectionResultSynchronizer.calculateCloneUnits((List)uniformPathToIntraComponentClones.getCollectionOrEmpty((Object)uniformPath)));
        }
        this.metricsIndex.setMetricValues(Arrays.asList(unitsValues, allClonedUnitsValues), Arrays.asList(UNITS_PARTITION, CLONED_UNITS_PARTITION));
        if (this.reportCrossOrIntraComponentClones()) {
            this.metricsIndex.setMetricValues(List.of(crossComponentClonedUnitsValues), List.of(CROSS_COMPONENT_CLONED_UNITS_PARTITION));
            this.metricsIndex.setMetricValues(List.of(intraComponentClonedUnitsValues), List.of(INTRA_COMPONENT_CLONED_UNITS_PARTITION));
        }
    }

    private static int calculateCloneUnits(List<Clone> clones) {
        if (CollectionUtils.isNullOrEmpty(clones)) {
            return 0;
        }
        RegionSet regions = new RegionSet();
        for (Clone clone : clones) {
            regions.add(new Region(clone.getStartUnitIndexInElement(), clone.getStartUnitIndexInElement() + clone.getLengthInUnits() - 1));
        }
        return regions.getPositionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCloneClasses() throws StorageException {
        Map<String, CloneClassInfo> map = this.newCloneClassValues;
        synchronized (map) {
            if (!this.newCloneClassValues.isEmpty()) {
                this.cloneClassIndex.setCloneClasses((PairList<String, CloneClassInfo>)PairList.fromMap(this.newCloneClassValues));
            }
        }
    }

    public void persistDeletions(List<String> deletedPaths) throws StorageException {
        if (deletedPaths.isEmpty()) {
            return;
        }
        this.cloneListIndex.removeEntries(deletedPaths);
        this.findingsIndex.removeFindingsForPartitionsAndPaths(CLONE_FINDINGS_PARTITION, deletedPaths);
        this.metricsIndex.removeEntries(deletedPaths, Arrays.asList(UNITS_PARTITION, CLONED_UNITS_PARTITION));
        if (this.reportCrossComponentClones) {
            this.findingsIndex.removeFindingsForPartitionsAndPaths(CROSS_COMPONENT_CLONE_FINDINGS_PARTITION, deletedPaths);
        }
        if (this.reportIntraComponentClones) {
            this.findingsIndex.removeFindingsForPartitionsAndPaths(INTRA_COMPONENT_CLONE_FINDINGS_PARTITION, deletedPaths);
        }
        if (this.reportCrossOrIntraComponentClones()) {
            this.metricsIndex.removeEntries(deletedPaths, Arrays.asList(CROSS_COMPONENT_CLONED_UNITS_PARTITION, INTRA_COMPONENT_CLONED_UNITS_PARTITION));
        }
    }
}

