/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.Unit;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;

public class RepetitionDetector {
    private final int repetitionStep;
    private final int minimalRegionSize;

    public RepetitionDetector(int repetitionStep, int minimalRegionSize) {
        this.repetitionStep = repetitionStep;
        this.minimalRegionSize = minimalRegionSize;
        CCSMAssert.isTrue((repetitionStep < minimalRegionSize ? 1 : 0) != 0, (String)"Expecting repetition step to be smaller then region size.");
    }

    public RegionSet detectRepetitions(List<Unit> units) {
        RegionSet result = null;
        for (int startIndex = 0; startIndex <= units.size() - this.minimalRegionSize; ++startIndex) {
            Unit lastUnitComparison;
            Unit lastUnit = units.get(startIndex + this.minimalRegionSize - 1);
            if (!lastUnit.equals(lastUnitComparison = units.get(startIndex + this.minimalRegionSize - 1 - this.repetitionStep))) {
                startIndex = startIndex + this.minimalRegionSize - 1 - this.repetitionStep;
                continue;
            }
            int length = this.scanForPattern(units, startIndex);
            int adjustedLength = this.adjustLength(units, startIndex, length);
            if (adjustedLength >= this.minimalRegionSize) {
                if (result == null) {
                    result = new RegionSet();
                }
                result.add(new Region(startIndex, startIndex + adjustedLength - 1));
            }
            startIndex = startIndex + length - this.repetitionStep;
        }
        return result;
    }

    private int adjustLength(List<Unit> units, int startIndex, int length) {
        if (length >= this.minimalRegionSize && !units.get(startIndex).equals(units.get(startIndex + 1))) {
            return length - length % this.repetitionStep;
        }
        return length;
    }

    private int scanForPattern(List<Unit> units, int startIndex) {
        for (int i = startIndex + this.repetitionStep; i < units.size(); ++i) {
            if (units.get(i).equals(units.get(i - this.repetitionStep))) continue;
            return i - startIndex;
        }
        return units.size() - startIndex;
    }
}

