/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.AstPositionCalculator;
import com.teamscale.index.comment_analysis.classification.MethodFinder;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

public class Comment {
    private final String text;
    private final String textWithoutLinePrefix;
    private static final String LINE_PREFIX_PATTERN = "\\p{Punct}+";
    private final int tokenIndex;
    private final AstPositionCalculator.EAstPosition astPosition;
    private final String elementUniformPath;
    private final List<IToken> tokens;
    private final MethodFinder methodFinder;

    public Comment(String comment, int tokenIndex, AstPositionCalculator.EAstPosition astPosition, String elementUniformPath, List<IToken> tokens, MethodFinder methodFinder) {
        this.tokenIndex = tokenIndex;
        this.astPosition = astPosition;
        this.elementUniformPath = elementUniformPath;
        this.tokens = tokens;
        this.methodFinder = methodFinder;
        this.text = LanguageProperties.of((ELanguage)tokens.get(tokenIndex).getLanguage()).getCommentContent(comment);
        this.textWithoutLinePrefix = StringUtils.stripCommonLinePrefix((String)this.text, (boolean)true, (boolean)true, (String)LINE_PREFIX_PATTERN);
    }

    public MethodFinder getMethodFinder() {
        return this.methodFinder;
    }

    public AstPositionCalculator.EAstPosition getAstPosition() {
        return this.astPosition;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public String getText() {
        return this.text;
    }

    public String getTextWithoutLinePrefix() {
        return this.textWithoutLinePrefix;
    }

    public String getRawCommentText() {
        return this.getToken().getText();
    }

    public List<IToken> getNextTokens(int start, int count) {
        ArrayList<IToken> nextTokens = new ArrayList<IToken>();
        int end = Math.min(this.tokens.size(), start + count + 1);
        for (int i = start + 1; i < end; ++i) {
            nextTokens.add(this.tokens.get(i));
        }
        return nextTokens;
    }

    public UnmodifiableList<IToken> getTokens() {
        return CollectionUtils.asUnmodifiable(this.tokens);
    }

    public String getElementUniformPath() {
        return this.elementUniformPath;
    }

    public UnmodifiableList<String> getCommentTokens() {
        return CollectionUtils.asUnmodifiable(Arrays.asList(Patterns.SINGLE_WHITESPACE.split(this.getText())));
    }

    public String toString() {
        return this.text;
    }

    public IToken getToken() {
        return this.tokens.get(this.tokenIndex);
    }

    public ELanguage getLanguage() {
        return this.getToken().getLanguage();
    }
}

