/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileEditVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileHistoryVersionComparison;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="analysis-profile-versions", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class AnalysisProfileVersionedIndex
implements IGlobalIndex {
    private final ValueIndex<AnalysisProfileVersionHistory> delegate;
    public static final String INDEX_NAME = "analysis-profile-versions";
    public static final String SYSTEM_NAME = "[System]";
    public static final String PROFILE_IMPORTED = "Analysis Profile imported";
    public static final String PROFILE_CREATED = "Analysis Profile created";
    public static final String DEFAULT_PROFILE = "Default Profile";
    public static final String SYSTEM_PROFILE_UPDATE = "Profile updated by System";
    public static final String SYSTEM_PROFILE_UPDATE_NEW_CHECKS = "Profile updated by System (Newly available checks added)";

    public AnalysisProfileVersionedIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<AnalysisProfileVersionHistory> getAllHistories() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public @Nullable AnalysisProfile getProfile(String analysisProfileName, GlobalStorageSystem globalStorageSystem) throws StorageException {
        AnalysisProfileVersionHistory profileVersionHistory = (AnalysisProfileVersionHistory)this.delegate.getValue(analysisProfileName);
        if (profileVersionHistory == null) {
            return null;
        }
        return profileVersionHistory.getProfile(globalStorageSystem);
    }

    public @Nullable AnalysisProfileVersionHistory getAnalysisProfileVersionHistory(String profileName) throws StorageException {
        return (AnalysisProfileVersionHistory)this.delegate.getValue(profileName);
    }

    public void removeAnalysisProfileVersionHistory(String profileName) throws StorageException {
        this.delegate.removeValue(profileName);
    }

    public void setAnalysisProfileVersionHistory(String profileName, AnalysisProfileVersionHistory history) throws StorageException {
        this.delegate.setValue(profileName, (Object)history);
    }

    public PairList<String, AnalysisProfileVersionHistory> getAllAnalysisProfileHistories() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void addNewAnalysisProfileVersion(AnalysisProfile analysisProfile, String editedBy, String editComment, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String json = AnalysisProfileVersionedIndex.toJson(analysisProfile);
        AnalysisProfileVersionHistory analysisProfileVersionHistory = (AnalysisProfileVersionHistory)this.delegate.getValue(analysisProfile.getName());
        if (analysisProfileVersionHistory != null) {
            String currentAnalysisProfileAsJSON = analysisProfileVersionHistory.getLatestVersion().analysisProfileAsJSON();
            AnalysisProfile currentVersion = AnalysisProfileVersionedIndex.fromJson(currentAnalysisProfileAsJSON, analysisProfile.getName(), globalStorageSystem);
            AnalysisProfileHistoryVersionComparison difference = AnalysisProfileEditVersionComparison.getAnalysisProfileComparison((AnalysisProfile)currentVersion, (AnalysisProfile)analysisProfile);
            if (difference != null && difference.profileDifference().isEmpty()) {
                return;
            }
            analysisProfileVersionHistory.addVersion(Instant.now().toEpochMilli(), editedBy, editComment, json);
            this.delegate.setValue(analysisProfile.getName(), (Object)analysisProfileVersionHistory);
        } else {
            this.delegate.setValue(analysisProfile.getName(), (Object)AnalysisProfileVersionedIndex.beginNewAnalysisProfileHistory(analysisProfile.getName(), Instant.now().toEpochMilli(), editedBy, editComment, analysisProfile));
        }
    }

    public void updateCurrentProfileSilently(String analysisProfileName, AnalysisProfile analysisProfile) throws StorageException {
        AnalysisProfileVersionHistory versionHistory = (AnalysisProfileVersionHistory)this.delegate.getValue(analysisProfileName);
        if (versionHistory == null) {
            this.delegate.setValue(analysisProfileName, (Object)AnalysisProfileVersionedIndex.beginNewAnalysisProfileHistory(analysisProfileName, DateTimeUtils.millisNow(), SYSTEM_NAME, PROFILE_CREATED, analysisProfile));
            return;
        }
        AnalysisProfileEditVersion latestVersion = versionHistory.getLatestVersion();
        AnalysisProfileEditVersion updatedVersion = new AnalysisProfileEditVersion(latestVersion.versionNumber, latestVersion.lastEdited, latestVersion.editedBy, latestVersion.editComment2, AnalysisProfileVersionedIndex.toJson(analysisProfile));
        versionHistory.history.remove(versionHistory.history.size() - 1);
        versionHistory.history.add(updatedVersion);
        this.delegate.setValue(analysisProfileName, (Object)versionHistory);
    }

    private static AnalysisProfileVersionHistory beginNewAnalysisProfileHistory(String analysisProfileName, long lastEdited, String editedBy, String editComment, AnalysisProfile analysisProfile) throws StorageException {
        AnalysisProfileVersionHistory newHistory = new AnalysisProfileVersionHistory(analysisProfileName, new ArrayList<AnalysisProfileEditVersion>());
        newHistory.addVersion(lastEdited, editedBy, editComment, AnalysisProfileVersionedIndex.toJson(analysisProfile));
        return newHistory;
    }

    private static AnalysisProfile fromJson(String json, String analysisProfileName, GlobalStorageSystem globalStorageSystem) throws StorageException {
        try {
            return (AnalysisProfile)TeamscaleVersionContainer.fromJson((String)json, (Object)EAnalysisProfileVersion.context(globalStorageSystem), AnalysisProfile.class, (Enum)EAnalysisProfileVersion.CURRENT_VERSION, (String)analysisProfileName);
        }
        catch (MigrationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static String toJson(AnalysisProfile analysisProfile) throws StorageException {
        try {
            return TeamscaleVersionContainer.toJson((Object)analysisProfile, (Enum)EAnalysisProfileVersion.CURRENT_VERSION);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @IndexValueClass(containedInBackup=true)
    public record AnalysisProfileVersionHistory(String analysisProfileName, List<AnalysisProfileEditVersion> history) implements Serializable
    {
        private void addVersion(long lastEdited, String editedBy, String editComment, String analysisProfileAsJSON) {
            this.history.add(new AnalysisProfileEditVersion(this.history.size(), lastEdited, editedBy, editComment, analysisProfileAsJSON));
        }

        public List<AnalysisProfile> getProfiles(GlobalStorageSystem globalStorageSystem) throws StorageException {
            ArrayList<AnalysisProfile> profiles = new ArrayList<AnalysisProfile>();
            for (AnalysisProfileEditVersion profileVersion : this.history) {
                profiles.add(AnalysisProfileVersionedIndex.fromJson(profileVersion.analysisProfileAsJSON, this.analysisProfileName, globalStorageSystem));
            }
            return profiles;
        }

        public AnalysisProfileEditVersion getLatestVersion() {
            return this.history.get(this.history.size() - 1);
        }

        public List<AnalysisProfileEditVersion> getAllVersions() {
            return this.history;
        }

        public AnalysisProfile getProfile(GlobalStorageSystem globalStorageSystem) throws StorageException {
            return AnalysisProfileVersionedIndex.fromJson(this.getLatestVersion().analysisProfileAsJSON, this.analysisProfileName, globalStorageSystem);
        }

        public @Nullable AnalysisProfile getProfileForVersionNumber(int versionNumber, GlobalStorageSystem globalStorageSystem) throws StorageException {
            if (versionNumber >= this.history().size() || versionNumber < 0) {
                return null;
            }
            String analysisProfileAsJSON = this.history().get(versionNumber).analysisProfileAsJSON();
            return AnalysisProfileVersionedIndex.fromJson(analysisProfileAsJSON, this.analysisProfileName, globalStorageSystem);
        }

        public void updateAnalysisProfileEditVersion(AnalysisProfileEditVersion profileEditVersion) {
            this.history().set(profileEditVersion.versionNumber, profileEditVersion);
        }
    }

    @IndexValueClass(containedInBackup=true)
    public record AnalysisProfileEditVersion(@JsonProperty(value="versionNumber") int versionNumber, @JsonProperty(value="lastEdited") long lastEdited, @JsonProperty(value="editedBy") @Nullable String editedBy, @JsonProperty(value="editComment") @Nullable String editComment2, @JsonProperty(value="analysisProfile") @Nullable String analysisProfileAsJSON) implements Serializable
    {
    }
}

