/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.IConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CppConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CppDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CppDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.CsConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.CsDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.CsDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.JavaConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.JavaDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.JavaDefUseHeuristic;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;

public class DataFlowHeuristicFactory {
    public static final Set<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.JAVA, new ELanguage[]{ELanguage.ABAP, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C});

    public static IDataFlowHeuristic createDataFlowHeuristic(ELanguage language) throws ConQATException {
        return switch (language) {
            case ELanguage.JAVA -> new JavaDataFlowHeuristic();
            case ELanguage.ABAP -> new AbapDataFlowHeuristic();
            case ELanguage.CS -> new CsDataFlowHeuristic();
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new CppDataFlowHeuristic();
            default -> throw new ConQATException("Data flow analysis for language " + String.valueOf(language) + " not yet supported!");
        };
    }

    static IDefUseHeuristic createDefUseHeuristic(ELanguage language, List<ShallowEntity> entities) throws ConQATException {
        return switch (language) {
            case ELanguage.JAVA -> new JavaDefUseHeuristic();
            case ELanguage.ABAP -> new AbapDefUseHeuristic(entities);
            case ELanguage.CS -> new CsDefUseHeuristic();
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new CppDefUseHeuristic();
            default -> throw new ConQATException("Data flow analysis for language " + String.valueOf(language) + " not yet supported!");
        };
    }

    public static IConditionHeuristic createConditionHeuristic(ELanguage language, IDefUseHeuristic defUseHeuristic) throws ConQATException {
        return switch (language) {
            case ELanguage.JAVA -> new JavaConditionHeuristic(defUseHeuristic);
            case ELanguage.ABAP -> new AbapConditionHeuristic(defUseHeuristic);
            case ELanguage.CS -> new CsConditionHeuristic(defUseHeuristic);
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new CppConditionHeuristic(defUseHeuristic);
            default -> throw new ConQATException("Data flow analysis for language " + String.valueOf(language) + " not yet supported!");
        };
    }

    public static boolean supportsLanguage(ELanguage language) {
        return SUPPORTED_LANGUAGES.contains(language);
    }
}

