/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.MethodRuleBase;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CPPMethodRule
extends MethodRuleBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ETokenType> OPENING_TYPES = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK, ETokenType.LT);
    private static final List<ETokenType> CLOSING_TYPES = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK, ETokenType.GT);

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity methodEntity = entities.get(0);
        if (TokenStreamUtils.containsSequence((List)methodEntity.includedTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.GOTO, ETokenType.MULT, ETokenType.IDENTIFIER})) {
            CPPMethodRule.extractAndRegisterAllTargetLabels(entities, context);
        }
        return super.transform(entities, context, creator);
    }

    private static void extractAndRegisterAllTargetLabels(List<ShallowEntity> entities, DataFlowContext context) {
        List labelEntities = ShallowEntityTraversalUtils.selectEntities(entities, entity -> "label".equals(entity.getSubtype()));
        for (ShallowEntity labelEntity : labelEntities) {
            String labelName = ((IToken)labelEntity.ownStartTokens().getFirst()).getText();
            context.getCodeLabelManager().registerLabel(labelName);
        }
    }

    @Override
    protected ControlFlowNode insertAdditionalInitializerNodes(ControlFlowNode parameterNode, List<ShallowEntity> entities, DataFlowContext context) {
        int parameterStartIndex;
        int parameterEndIndex;
        if (!"constructor".equals(entities.get(0).getSubtype())) {
            return parameterNode;
        }
        UnmodifiableList methodEntityStartTokens = entities.get(0).ownStartTokens();
        int colonIndex = TokenStreamUtils.firstTokenMatching((List)methodEntityStartTokens, (int)((parameterEndIndex = TokenStreamUtils.findFirstTopLevel((List)methodEntityStartTokens, (int)(parameterStartIndex = TokenStreamUtils.firstTokenMatching((List)methodEntityStartTokens, (ITokenMatcher)ETokenType.LPAREN) + 1), (ITokenMatcher)ETokenType.RPAREN, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN))) + 1), (ITokenMatcher)ETokenType.COLON);
        if (colonIndex != -1) {
            int initializerEndIndex = methodEntityStartTokens.size();
            if (TokenStreamUtils.endsWith((List)methodEntityStartTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE})) {
                initializerEndIndex -= 2;
            } else if (TokenStreamUtils.endsWith((List)methodEntityStartTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE}) || TokenStreamUtils.endsWith((List)methodEntityStartTokens, (ETokenType[])new ETokenType[]{ETokenType.SEMICOLON})) {
                --initializerEndIndex;
            }
            UnmodifiableList initializationListTokens = methodEntityStartTokens.subList(parameterEndIndex + 2, initializerEndIndex);
            ControlFlowNode initializationNode = new ControlFlowNode((List<IToken>)initializationListTokens, new VariableReadWriteInfo());
            for (IToken token : initializationListTokens) {
                if (token.getType() != ETokenType.IDENTIFIER || !context.getDefUseHeuristic().isKnownVariableName(token.getText())) continue;
                initializationNode.getReadWriteInfo().getReads().add(token.getText());
            }
            ControlFlowNode.link(parameterNode, initializationNode);
            return initializationNode;
        }
        return parameterNode;
    }

    private static Optional<List<IToken>> extractParameterListFromOperatorOverloading(ShallowEntity methodEntity, List<IToken> functionSignatureTokens, int searchEndIndex) {
        int operatorKeywordIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)0, (ITokenMatcher)ETokenType.OPERATOR);
        if (operatorKeywordIndex == -1) {
            return Optional.empty();
        }
        ETokenType operatorTokenType = functionSignatureTokens.get(operatorKeywordIndex + 1).getType();
        if (EnumSet.of(ETokenType.IDENTIFIER, ETokenType.NEW, ETokenType.DELETE, ETokenType.STRING_LITERAL).contains(operatorTokenType)) {
            return Optional.empty();
        }
        if (operatorTokenType == ETokenType.LPAREN) {
            return Optional.ofNullable(CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, operatorKeywordIndex + 3));
        }
        int paramLeftParenIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)(operatorKeywordIndex + 1), (int)searchEndIndex, (ITokenMatcher)ETokenType.LPAREN);
        if (paramLeftParenIndex != -1) {
            return Optional.ofNullable(CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, paramLeftParenIndex));
        }
        return Optional.empty();
    }

    private static Optional<List<IToken>> extractParameterListFromFunctionReturningFunctionPointer(ShallowEntity methodEntity, List<IToken> functionSignatureTokens) {
        int pointerToStartIndex = TokenStreamUtils.firstTokenOfTypeSequence(functionSignatureTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.MULT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        if (pointerToStartIndex != -1) {
            return Optional.ofNullable(CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, pointerToStartIndex + 2));
        }
        return Optional.empty();
    }

    @Override
    protected List<IToken> extractParameterListTokens(ShallowEntity methodEntity) {
        List operatorParameterTokens;
        List<IToken> functionSignatureTokens = CPPMethodRule.extractFunctionSignatureTokens(methodEntity);
        if (functionSignatureTokens.isEmpty()) {
            return List.of();
        }
        int searchEndIndex = functionSignatureTokens.size() - 1;
        if ((methodEntity.getSubtype().equals("operator") || methodEntity.getSubtype().equals("operator declaration")) && (operatorParameterTokens = (List)CPPMethodRule.extractParameterListFromOperatorOverloading(methodEntity, functionSignatureTokens, searchEndIndex).orElse(null)) != null) {
            return operatorParameterTokens;
        }
        searchEndIndex = CPPMethodRule.getSearchEndIndexIfTrailingReturnOrInitializationList(functionSignatureTokens, searchEndIndex);
        int paramLeftParenIndex = CPPMethodRule.getParamLeftParenIndex(functionSignatureTokens, searchEndIndex);
        int lessThanIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)0, (int)searchEndIndex, (ITokenMatcher)ETokenType.LT);
        if (lessThanIndex != -1) {
            return CPPMethodRule.extractParameterListFromTernaryExpressionOrTemplatedFunction(methodEntity, functionSignatureTokens, searchEndIndex, lessThanIndex, paramLeftParenIndex);
        }
        if (CPPMethodRule.isInlinedLambdaExpression(functionSignatureTokens, searchEndIndex)) {
            return List.of();
        }
        List functionReturningFunctionPointerParameterTokens = CPPMethodRule.extractParameterListFromFunctionReturningFunctionPointer(methodEntity, functionSignatureTokens).orElse(null);
        if (functionReturningFunctionPointerParameterTokens != null) {
            return functionReturningFunctionPointerParameterTokens;
        }
        return CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, paramLeftParenIndex);
    }

    private static List<IToken> extractFunctionSignatureTokens(ShallowEntity methodEntity) {
        Object functionSignatureTokens = methodEntity.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)functionSignatureTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.LBRACK})) {
            int annotationEnd = TokenStreamUtils.firstTokenOfTypeSequence((List)functionSignatureTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.RBRACK, ETokenType.RBRACK});
            if (annotationEnd == -1) {
                return List.of();
            }
            functionSignatureTokens = functionSignatureTokens.subList(annotationEnd + 2, functionSignatureTokens.size());
        }
        return functionSignatureTokens;
    }

    private static int getParamLeftParenIndex(List<IToken> functionSignatureTokens, int searchEndIndex) {
        int paramLeftParenIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)0, (int)searchEndIndex, (ITokenMatcher)ETokenType.LPAREN);
        if (TokenStreamUtils.contains(functionSignatureTokens, (int)0, (int)paramLeftParenIndex, (ETokenType)ETokenType.DECLTYPE) || TokenStreamUtils.endsWith(functionSignatureTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.INTEGER_LITERAL, ETokenType.RBRACK, ETokenType.LBRACE})) {
            paramLeftParenIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)(paramLeftParenIndex + 1), (int)searchEndIndex, (ITokenMatcher)ETokenType.LPAREN);
        }
        return paramLeftParenIndex;
    }

    private static int getSearchEndIndexIfTrailingReturnOrInitializationList(List<IToken> functionSignatureTokens, int searchEndIndex) {
        int colonOrPointerToIndex = TokenStreamUtils.findFirstTopLevel(functionSignatureTokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.POINTERTO}), OPENING_TYPES, CLOSING_TYPES);
        if (colonOrPointerToIndex != -1) {
            searchEndIndex = colonOrPointerToIndex;
        }
        return searchEndIndex;
    }

    private static boolean isInlinedLambdaExpression(List<IToken> functionSignatureTokens, int searchEndIndex) {
        return functionSignatureTokens.get(0).getType() == ETokenType.LBRACK && functionSignatureTokens.get(searchEndIndex - 1).getType() == ETokenType.RBRACK;
    }

    private static List<IToken> extractParameterListFromTernaryExpressionOrTemplatedFunction(ShallowEntity methodEntity, List<IToken> functionSignatureTokens, int searchEndIndex, int lessThanIndex, int paramLeftParenIndex) {
        int greaterThanIndex = TokenStreamUtils.findMatchingClosingToken(functionSignatureTokens, (int)(lessThanIndex + 1), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT);
        if (greaterThanIndex == -1) {
            return CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, paramLeftParenIndex);
        }
        if (paramLeftParenIndex < lessThanIndex || paramLeftParenIndex > greaterThanIndex) {
            return CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, paramLeftParenIndex);
        }
        paramLeftParenIndex = TokenStreamUtils.firstTokenMatching(functionSignatureTokens, (int)(greaterThanIndex + 1), (int)searchEndIndex, (ITokenMatcher)ETokenType.LPAREN);
        return CPPMethodRule.getParameterTokens(methodEntity, functionSignatureTokens, paramLeftParenIndex);
    }

    private static List<IToken> getParameterTokens(ShallowEntity methodEntity, List<IToken> functionSignatureTokens, int paramLeftParenIndex) {
        if (paramLeftParenIndex == -1) {
            LOGGER.warn("Did not find opening parameter left parenthesis for file:" + functionSignatureTokens.get(0).getOriginId() + " in function signature: " + String.valueOf(methodEntity));
            return List.of();
        }
        int paramRightParenIndex = TokenStreamUtils.findMatchingClosingToken(functionSignatureTokens, (int)(paramLeftParenIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (paramRightParenIndex == -1) {
            LOGGER.warn("Did not find closing parameter right parenthesis for file: " + functionSignatureTokens.get(0).getOriginId() + " in function signature: " + String.valueOf(methodEntity));
            return List.of();
        }
        return functionSignatureTokens.subList(paramLeftParenIndex + 1, paramRightParenIndex);
    }
}

