/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cs;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeDataFlowHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules.CsCaseLabelRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules.GotoRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules.MethodRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules.UsingRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules.YieldRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.AnonymousBlockRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ForRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ReturnRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.SimpleStatementRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ExitStatementEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTypeMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SimpleStatementMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SubTypeMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.PairList;

public class CsDataFlowHeuristic
extends CLikeDataFlowHeuristicBase {
    private static final PairList<IShallowEntityMatcher, IControlFlowRule> RULES = new PairList();

    @Override
    public PairList<String, List<ShallowEntity>> extractExecutables(String uniformPath, List<ShallowEntity> entities) {
        PairList executables = new PairList();
        List methods = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(entities, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!this.hasMethodBody(method) || !CsDataFlowHeuristic.isEntrypoint(method)) continue;
            executables.add((Object)method.getName(), Collections.singletonList(method));
        }
        return executables;
    }

    @Override
    public boolean hasMethodBody(ShallowEntity method) {
        return super.hasMethodBody(method) && !method.getSubtype().contains("delegate");
    }

    @Override
    protected PairList<IShallowEntityMatcher, IControlFlowRule> getRules() {
        PairList rules = new PairList(RULES);
        CsDataFlowHeuristic.addDefaultRules((PairList<IShallowEntityMatcher, IControlFlowRule>)rules);
        return rules;
    }

    static {
        RULES.add((Object)new ShallowEntityOrMatcher(new SubTypeMatcher("checked"), new SubTypeMatcher("unchecked"), new SubTypeMatcher("lock"), new SubTypeMatcher("unsafe")), (Object)new AnonymousBlockRule());
        RULES.add((Object)new ShallowEntityOrMatcher(FOR_SUBTYPE, new SubTypeMatcher("foreach")), (Object)new ForRule(ETokenType.IN));
        RULES.add((Object)new ExitStatementEntityMatcher("System.Environment.Exit", "Environment.Exit", "Exit"), (Object)new ReturnRule());
        RULES.add((Object)new ExitStatementEntityMatcher("Assert.Fail", "Fail", "Assert.Inconclusive", "Inconclusive", "Assert.Ignore", "Ignore"), (Object)new ReturnRule());
        RULES.add((Object)new SubTypeMatcher("using"), (Object)new UsingRule());
        RULES.add((Object)new SubTypeMatcher("fixed"), (Object)new UsingRule());
        RULES.add((Object)YIELD_SUBTYPE, (Object)new YieldRule());
        RULES.add((Object)new SimpleStatementMatcher("goto"), (Object)new GotoRule());
        RULES.add((Object)new SubTypeMatcher("lambda expression"), (Object)new SimpleStatementRule(false));
        RULES.add((Object)ShallowEntityTypeMatcher.METHOD_MATCHER, (Object)new MethodRule());
        RULES.add((Object)ALL_CASE_LABELS, (Object)new CsCaseLabelRule(CASE_SUBTYPE_BELOW_SWITCH, DEFAULT_SUBTYPE_BELOW_SWITCH, BREAK_SUBTYPE, RETURN_OR_THROW_STATEMENTS));
    }
}

