/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.AcceptAllFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.EmptyDependencyExtractor;
import com.teamscale.index.dependencies.FakeTypeExtractor;
import com.teamscale.index.dependencies.IDependencyExtractor;
import com.teamscale.index.dependencies.IFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.IProjectModuleAnalyzer;
import com.teamscale.index.dependencies.ITypeExtractor;
import com.teamscale.index.dependencies.IVariableWriteDependencyStrategy;
import com.teamscale.index.dependencies.NearestNeighborFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.ProjectModuleAwareFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.abap.AbapDependencyExtractor;
import com.teamscale.index.dependencies.abap.AbapTypeExtractor;
import com.teamscale.index.dependencies.abap.cds.AbapCdsDependencyExtractor;
import com.teamscale.index.dependencies.abap.cds.AbapCdsTypeExtractor;
import com.teamscale.index.dependencies.abap.ddic.AbapDdicDependencyExtractor;
import com.teamscale.index.dependencies.abap.ddic.AbapDdicTypeExtractor;
import com.teamscale.index.dependencies.cpp.CppDependencyExtractor;
import com.teamscale.index.dependencies.cpp.CppTypeExtractor;
import com.teamscale.index.dependencies.cs.CsDependencyExtractor;
import com.teamscale.index.dependencies.cs.CsTypeExtractor;
import com.teamscale.index.dependencies.cs.VisualStudioProjectModuleAnalyzer;
import com.teamscale.index.dependencies.dart.DartDependencyExtractor;
import com.teamscale.index.dependencies.gosu.GosuDependencyExtractor;
import com.teamscale.index.dependencies.hana_view.HanaViewDependencyExtractor;
import com.teamscale.index.dependencies.hana_view.HanaViewTypeExtractor;
import com.teamscale.index.dependencies.iec.StructuredTextDependencyExtractor;
import com.teamscale.index.dependencies.iec.StructuredTextTypeExtractor;
import com.teamscale.index.dependencies.iec.StructuredTextVariableWriteDependencyStrategy;
import com.teamscale.index.dependencies.java.JavaDependencyExtractor;
import com.teamscale.index.dependencies.java.JvmTypeExtractor;
import com.teamscale.index.dependencies.javascript.JavascriptDependencyExtractor;
import com.teamscale.index.dependencies.javascript.JavascriptTypeExtractor;
import com.teamscale.index.dependencies.kotlin.KotlinDependencyExtractor;
import com.teamscale.index.dependencies.matlab.MatlabDependencyExtractor;
import com.teamscale.index.dependencies.matlab.MatlabTypeExtractor;
import com.teamscale.index.dependencies.php.PhpDependencyExtractor;
import com.teamscale.index.dependencies.php.PhpTypeExtractor;
import com.teamscale.index.dependencies.python.PythonDependencyExtractor;
import com.teamscale.index.dependencies.python.PythonTypeExtractor;
import com.teamscale.index.dependencies.simulink.SimulinkDependencyExtractor;
import com.teamscale.index.dependencies.simulink.SimulinkTypeExtractor;
import com.teamscale.index.dependencies.swift.ObjectiveCTypeExtractor;
import com.teamscale.index.dependencies.swift.SwiftTypeExtractor;
import com.teamscale.index.resource.TokenElementIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class DependencyAnalysisFactory {
    private static final UnmodifiableSet<IProjectModuleAnalyzer> PROJECT_MODULE_ANALYZERS = CollectionUtils.asUnmodifiableHashSet((Object[])new IProjectModuleAnalyzer[]{new VisualStudioProjectModuleAnalyzer()});

    private DependencyAnalysisFactory() {
    }

    public static ITypeExtractor createTypeExtractor(ELanguage language, TokenElementIndex contentIndex) {
        return switch (language) {
            case ELanguage.GOSU, ELanguage.JAVA, ELanguage.KOTLIN -> new JvmTypeExtractor();
            case ELanguage.CS -> new CsTypeExtractor();
            case ELanguage.ABAP -> new AbapTypeExtractor();
            case ELanguage.ABAP_DDIC -> new AbapDdicTypeExtractor();
            case ELanguage.ABAP_CDS -> new AbapCdsTypeExtractor();
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new CppTypeExtractor(contentIndex);
            case ELanguage.JAVASCRIPT -> new JavascriptTypeExtractor();
            case ELanguage.MATLAB -> new MatlabTypeExtractor();
            case ELanguage.PHP -> new PhpTypeExtractor();
            case ELanguage.HANA_VIEW -> new HanaViewTypeExtractor();
            case ELanguage.IEC61131 -> new StructuredTextTypeExtractor();
            case ELanguage.PYTHON -> new PythonTypeExtractor(contentIndex);
            case ELanguage.SIMULINK -> new SimulinkTypeExtractor();
            case ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP -> new ObjectiveCTypeExtractor();
            case ELanguage.SWIFT -> new SwiftTypeExtractor();
            default -> new FakeTypeExtractor();
        };
    }

    public static IDependencyExtractor createDependencyExtractor(ELanguage language) {
        switch (language) {
            case GOSU: {
                return new GosuDependencyExtractor();
            }
            case JAVA: {
                return new JavaDependencyExtractor();
            }
            case CS: {
                return new CsDependencyExtractor();
            }
            case ABAP: {
                return new AbapDependencyExtractor();
            }
            case ABAP_DDIC: {
                return new AbapDdicDependencyExtractor();
            }
            case ABAP_CDS: {
                return new AbapCdsDependencyExtractor();
            }
            case CPP: 
            case CPP_MS_CLI: 
            case C: {
                return new CppDependencyExtractor();
            }
            case JAVASCRIPT: {
                return new JavascriptDependencyExtractor();
            }
            case MATLAB: {
                return new MatlabDependencyExtractor();
            }
            case PHP: {
                return new PhpDependencyExtractor();
            }
            case HANA_VIEW: {
                return new HanaViewDependencyExtractor();
            }
            case IEC61131: {
                return new StructuredTextDependencyExtractor();
            }
            case PYTHON: {
                return new PythonDependencyExtractor();
            }
            case SIMULINK: {
                if (EFeatureToggle.DISABLE_SIMULINK_DEPENDENCY_EXTRACTION.isEnabled()) break;
                return new SimulinkDependencyExtractor();
            }
            case KOTLIN: {
                return new KotlinDependencyExtractor();
            }
            case DART: {
                return new DartDependencyExtractor();
            }
        }
        return new EmptyDependencyExtractor();
    }

    public static IVariableWriteDependencyStrategy createVariableWriteDependencyStrategy(ELanguage language) {
        if (language == ELanguage.IEC61131) {
            return new StructuredTextVariableWriteDependencyStrategy();
        }
        return IVariableWriteDependencyStrategy.NOP;
    }

    public static IFileDependencyFilteringStrategy createTypeDependencyMappingStrategy(ELanguage language) {
        return switch (language) {
            case ELanguage.CS -> new ProjectModuleAwareFileDependencyFilteringStrategy();
            case ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new NearestNeighborFileDependencyFilteringStrategy();
            default -> new AcceptAllFileDependencyFilteringStrategy();
        };
    }

    public static Set<IProjectModuleAnalyzer> getProjectModuleAnalyzers() {
        return PROJECT_MODULE_ANALYZERS;
    }

    public static boolean isProjectModule(String uniformPath) {
        HashSet<String> keys = new HashSet<String>(Arrays.asList(uniformPath));
        HashSet<String> filteredKeys = new HashSet<String>();
        Set<IProjectModuleAnalyzer> projectModuleAnalyzers = DependencyAnalysisFactory.getProjectModuleAnalyzers();
        for (IProjectModuleAnalyzer projectModuleAnalyzer : projectModuleAnalyzers) {
            filteredKeys.addAll(projectModuleAnalyzer.filterKeys(keys));
        }
        return !filteredKeys.isEmpty();
    }
}

