/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cs;

import com.teamscale.index.dependencies.IProjectModuleAnalyzer;
import com.teamscale.index.dependencies.ProjectModule;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.resource.parser.ESolutionFormatVersion;
import org.conqat.engine.dotnet.resource.parser.ProjectParser;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.resource.util.UniformPathUtils;

public class VisualStudioProjectModuleAnalyzer
implements IProjectModuleAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VS_PROJECT_FILE_EXTENSION = "csproj";

    @Override
    public List<String> filterKeys(Collection<String> keys) {
        Predicate<String> isProjectFilePredicate = key -> VS_PROJECT_FILE_EXTENSION.equalsIgnoreCase(UniformPathUtils.getExtension((String)key));
        return keys.stream().filter(isProjectFilePredicate).collect(Collectors.toList());
    }

    @Override
    public Optional<ProjectModule> extractModule(BasicTokenElementInfo moduleFile) {
        try {
            ProjectParser.VisualStudioProject project = ProjectParser.parse((String)moduleFile.getText());
            Set<String> sourceFiles = VisualStudioProjectModuleAnalyzer.resolveRelativePaths(moduleFile, project.getRelativeSources());
            Set<String> projectReferences = VisualStudioProjectModuleAnalyzer.resolveRelativePaths(moduleFile, project.getProjectReferences());
            return Optional.of(new ProjectModule(moduleFile.getUniformPath(), sourceFiles, projectReferences, project.isSdkStyle(), project.isSdkStyle()));
        }
        catch (ConQATException e) {
            LOGGER.error("Error parsing project module " + moduleFile.getUniformPath() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ESolutionFormatVersion.UnsupportedFormatException e) {
            LOGGER.warn("Ignoring " + moduleFile.getUniformPath() + " with unsupported format");
        }
        return Optional.empty();
    }

    private static Set<String> resolveRelativePaths(BasicTokenElementInfo baseElement, Collection<String> relativePaths) {
        HashSet<String> result = new HashSet<String>();
        for (String sourceFile : relativePaths) {
            String normalizedSourcePath = UniformPathUtils.normalizeAllSeparators((String)sourceFile);
            if (normalizedSourcePath.startsWith("$(")) {
                result.add(normalizedSourcePath);
                continue;
            }
            result.add(UniformPathUtils.resolveRelativePath((String)baseElement.getUniformPath(), (String)normalizedSourcePath));
        }
        return result;
    }
}

