/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.ExternalAnalysisDeletionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionCreationUtils;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.StoreAnalysisResultsInExternalStorageTrigger;
import com.teamscale.index.external.input.external_storage.migration.FinalizeStorageBackendMigrationTrigger;
import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationException;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.ClusterByCodeCommitStrategy;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitClusteringStrategyBase;
import com.teamscale.index.external.input.external_storage.migration.migrators.ExternalAnalysisResultsMigratorProvider;
import com.teamscale.index.external.input.external_storage.migration.migrators.IExternalAnalysisResultsMigrator;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisShortStatusInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RevisionResolver;
import com.teamscale.index.testimpact.CommitAndRevision;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public class StorageBackendMigrationTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private CommitResolvingStorageSystem projectStorageSystem;

    public void execute() throws Exception {
        JobParameter parameter = (JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class);
        InternalProjectId internalProjectId = parameter.projectId();
        ExternalStorageBackend targetStorage = parameter.externalStorage();
        this.projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)internalProjectId);
        ListMap<String, CommitAndPartition> uploadCommitsByBranch = this.getExternalUploadCommitsByBranch();
        UnmodifiableSet branches = uploadCommitsByBranch.getKeys();
        ListMap<String, CommitDescriptor> codeCommitsByBranch = ((RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null)).getCodeCommitsOnBranches((Set<String>)branches);
        LOGGER.info("Found code commits in branches {}", codeCommitsByBranch);
        CommitClusteringStrategyBase commitClusteringStrategy = StorageBackendMigrationTrigger.getCommitClusteringStrategy();
        LOGGER.trace("Using commit clustering strategy {}", (Object)commitClusteringStrategy);
        ListMap<String, CommitCluster> clusteredCommitsByBranch = commitClusteringStrategy.clusterCommits(codeCommitsByBranch, uploadCommitsByBranch);
        for (CommitCluster commitCluster : (List)clusteredCommitsByBranch.getValues()) {
            this.migrateCommitCluster(commitCluster, internalProjectId, targetStorage);
        }
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.indexLayer, JobDescriptor.createMaintenanceTriggerWithParameter(FinalizeStorageBackendMigrationTrigger.class, (Object)new FinalizeStorageBackendMigrationTrigger.JobParameter(internalProjectId, targetStorage), (String)"Migrated all external analysis results."));
    }

    private static CommitClusteringStrategyBase getCommitClusteringStrategy() {
        LOGGER.info("All uploads will be migrated to their respective preceding code commits.");
        return new ClusterByCodeCommitStrategy();
    }

    private void migrateCommitCluster(CommitCluster commitCluster, InternalProjectId projectId, ExternalStorageBackend targetStorage) {
        try {
            ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)this.projectStorageSystem.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
            HashMap<String, ExternalAnalysisImportInfos> importInfosByPartition = new HashMap<String, ExternalAnalysisImportInfos>();
            for (CommitAndPartition commitAndPartition : commitCluster.commits()) {
                ExternalAnalysisImportInfos importInfos = importInfosByPartition.computeIfAbsent(commitAndPartition.partition(), partition -> new ExternalAnalysisImportInfos());
                importInfos.addAll(this.migrateResults(commitAndPartition));
            }
            for (Map.Entry entry : importInfosByPartition.entrySet()) {
                String partition2 = (String)entry.getKey();
                ExternalAnalysisImportInfos importInfos = (ExternalAnalysisImportInfos)entry.getValue();
                ExternalAnalysisSessionInfo session = this.createUploadSession(commitCluster, projectId, partition2, targetStorage);
                this.upload(session, importInfos, sessionIndex, projectId);
            }
            this.registerPendingDeletions(commitCluster);
            LOGGER.traceExit();
        }
        catch (Exception e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Could not process upload commit for {}. Skipping and processing next batch.", (Object)commitCluster.toString());
        }
    }

    private void registerPendingDeletions(CommitCluster commitCluster) throws StorageException {
        LOGGER.trace("Marking uploads in {} for deletion", (Object)commitCluster.toString());
        ExternalAnalysisDeletionIndex resultDeletionIndex = (ExternalAnalysisDeletionIndex)this.projectStorageSystem.openProjectIndex(ExternalAnalysisDeletionIndex.class, null);
        for (CommitDescriptor migratedUpload : commitCluster.extractCommitDescriptors()) {
            resultDeletionIndex.addCommit(migratedUpload);
        }
    }

    private ExternalAnalysisSessionInfo createUploadSession(CommitCluster commitCluster, InternalProjectId projectId, String partition, ExternalStorageBackend targetStorage) throws StorageException {
        String targetRevision = this.getReferenceRevision(commitCluster.storageTargetCommit());
        String repository = this.getRepository(targetRevision, projectId);
        LOGGER.trace("Creating session info ...");
        try {
            return (ExternalAnalysisSessionInfo)LOGGER.traceExit((Object)ExternalAnalysisSessionCreationUtils.createSession(new ExternalAnalysisSessionCreationUtils.SessionParameters(Optional.of(targetStorage), partition, new CommitAndRevision(commitCluster.storageTargetCommit().toUnresolvedCommitDescriptor(), targetRevision, repository), "Auto-migrated upload", false, repository), projectId, this.indexLayer, "internal-migration", (PredicateWithException<CommitDescriptor, StorageException>)((PredicateWithException)commit -> false), (SupplierWithException<IStore, StorageException>)((SupplierWithException)() -> this.projectStorageSystem.openStoreChecked("external-analysis-results", ExternalAnalysisResultIndex.class, (IStorageSystem)this.projectStorageSystem, true, null))));
        }
        catch (UploadRejectedException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void upload(ExternalAnalysisSessionInfo session, ExternalAnalysisImportInfos importInfos, ExternalAnalysisImportSessionIndex sessionIndex, InternalProjectId projectId) throws StorageException {
        LOGGER.trace("Uploading results for session {}. Contained import infos: {}", (Object)session.getSessionId(), (Object)importInfos.getInfos().size());
        if (!session.isOpen()) {
            LOGGER.error("Session was already closed before upload: {}.", (Object)session.getSessionId());
            return;
        }
        sessionIndex.insertImportInfos(session, importInfos);
        session.setCommitted();
        sessionIndex.setSessionInfo(session.getSessionId(), session);
        if (sessionIndex.markSessionAsScheduled(session)) {
            StoreAnalysisResultsInExternalStorageTrigger.schedule(projectId, this.indexLayer, "External analysis results are being migrated.");
        } else {
            LOGGER.error("Session was unexpectedly already scheduled for upload: {}.", (Object)session.getSessionId());
        }
    }

    private ExternalAnalysisImportInfos migrateResults(CommitAndPartition commitAndPartition) throws StorageException {
        LOGGER.trace("Migrating results for {}", (Object)commitAndPartition);
        ExternalAnalysisResultIndex externalAnalysisResultIndex = (ExternalAnalysisResultIndex)this.projectStorageSystem.openProjectIndex(ExternalAnalysisResultIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commitAndPartition.commit()));
        List<String> allElementPaths = externalAnalysisResultIndex.getAllElementPaths(commitAndPartition.partition());
        List<ExternalAnalysisResults> analysisResults = externalAnalysisResultIndex.getAnalysisResults(commitAndPartition.partition(), allElementPaths);
        ExternalAnalysisImportInfos importInfos = new ExternalAnalysisImportInfos();
        for (int i = 0; i < analysisResults.size(); ++i) {
            String currentPath = allElementPaths.get(i);
            ExternalAnalysisResults resultsForCurrentPath = analysisResults.get(i);
            Set<IExternalAnalysisResultsMigrator> migrators = ExternalAnalysisResultsMigratorProvider.getMigratorsFor(resultsForCurrentPath.getCanonicalTypeNames());
            LOGGER.trace("Using migrators: {}", migrators);
            for (IExternalAnalysisResultsMigrator migrator : migrators) {
                try {
                    importInfos.addAll(migrator.migrate(resultsForCurrentPath, currentPath));
                }
                catch (StorageBackendMigrationException e) {
                    LOGGER.error("Unable to migrate partition {} in commit {}", (Object)commitAndPartition.partition(), (Object)commitAndPartition.commit(), (Object)e);
                }
            }
        }
        return importInfos;
    }

    private @Nullable String getRepository(String targetRevision, InternalProjectId projectId) throws StorageException {
        if (targetRevision == null) {
            return null;
        }
        Optional<Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>> revisionAndRepository = RevisionResolver.resolveRevisionAndRepository(targetRevision, null, null, projectId, this.indexLayer);
        return (String)LOGGER.traceExit((Object)revisionAndRepository.map(commitDescriptorRevisionAndRepositoryPair -> ((RepositoryRevisionIndex.RevisionAndRepository)commitDescriptorRevisionAndRepositoryPair.getSecond()).repositoryIdentifier()).orElse(null));
    }

    private @Nullable String getReferenceRevision(CommitDescriptor referenceRevisionCommit) throws StorageException {
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        RepositoryLogEntryAggregate repositoryLogIndexEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(referenceRevisionCommit);
        return (String)LOGGER.traceExit((Object)Optional.ofNullable(repositoryLogIndexEntry).map(RepositoryLogEntryAggregate::getRevision).orElse(null));
    }

    private ListMap<String, CommitAndPartition> getExternalUploadCommitsByBranch() throws StorageException {
        LOGGER.traceEntry("Reading external upload commits by branch...", new Supplier[0]);
        ListMap uploadCommitsByBranch = (ListMap)((ExternalAnalysisStatusIndex)this.projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null)).computeWithLock(StorageBackendMigrationTrigger::computeExternalUploadCommitsByBranch);
        return (ListMap)LOGGER.traceExit((Object)uploadCommitsByBranch);
    }

    private static ListMap<String, CommitAndPartition> computeExternalUploadCommitsByBranch(ExternalAnalysisStatusIndex.LockedIndexAccess statusIndex) throws StorageException {
        List<ExternalAnalysisPartitionInfo> externalUploadPartitions = statusIndex.getPartitionInfos();
        LOGGER.trace("Found external upload partitions: {}", externalUploadPartitions);
        ListMap uploadCommitsByBranch = new ListMap();
        for (ExternalAnalysisPartitionInfo partitionInfo : externalUploadPartitions) {
            String partition = partitionInfo.getName();
            PairList<CommitDescriptor, ExternalAnalysisShortStatusInfo> commitsForPartition = statusIndex.getCommitsForPartition(partition);
            UnmodifiableList relevantCommits = commitsForPartition.filter((commit, status) -> status.isUpload() && !status.isStoredExternally()).getFirstList();
            uploadCommitsByBranch.addAll(relevantCommits.stream().map(commit -> new CommitAndPartition((CommitDescriptor)commit, partition)).collect(Collectors.groupingBy(commitAndPartition -> commitAndPartition.commit().getBranchName(), Collectors.toList())));
        }
        return uploadCommitsByBranch;
    }

    public record JobParameter(InternalProjectId projectId, ExternalStorageBackend externalStorage) {
    }
}

