/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.migrators;

import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationException;
import com.teamscale.index.external.input.external_storage.migration.migrators.IExternalAnalysisResultsMigrator;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.report.EReportFormat;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.util.JsonUtils;

abstract class ExternalAnalysisResultToPreparsedReportMigratorBase<T extends ExternalAnalysisResult<?>>
implements IExternalAnalysisResultsMigrator {
    private static final String PREPARSED_REPORT_FILE_NAME = "migrated-preparsed.json";

    ExternalAnalysisResultToPreparsedReportMigratorBase() {
    }

    @Override
    public ExternalAnalysisImportInfos migrate(ExternalAnalysisResults resultsToMigrate, String path) throws StorageBackendMigrationException {
        try {
            List<T> filteredResults = this.getResultsHandledByMigrator(resultsToMigrate);
            return this.migrateAll(filteredResults, path);
        }
        catch (Throwable e) {
            throw new StorageBackendMigrationException(e);
        }
    }

    private List<T> getResultsHandledByMigrator(ExternalAnalysisResults resultsToMigrate) {
        return resultsToMigrate.getByType(this.getMigratedType());
    }

    private ExternalAnalysisImportInfos migrateAll(List<T> results, String path) throws Exception {
        ExternalAnalysisImportInfos importInfos = new ExternalAnalysisImportInfos();
        for (ExternalAnalysisResult result : results) {
            importInfos.addAll(this.migrateAndWrapAsPreparsedReport(result, path));
        }
        return importInfos;
    }

    private ExternalAnalysisImportInfos migrateAndWrapAsPreparsedReport(T result, String path) throws Exception {
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder("", EReportFormat.PREPARSED);
        builder.addReport(PREPARSED_REPORT_FILE_NAME, ExternalAnalysisResultToPreparsedReportMigratorBase.encodePreparsedReport(this.convert(result, path)));
        return builder.build();
    }

    private static String encodePreparsedReport(ExternalAnalysisImportInfo<?> data) {
        return JsonUtils.serializeToJSONPrettyPrint(data);
    }

    protected abstract ExternalAnalysisImportInfo<?> convert(T var1, String var2) throws Exception;

    protected abstract Class<T> getMigratedType();

    @Override
    public Set<Class<? extends ExternalAnalysisResult<?>>> getHandledTypes() {
        return Set.of(this.getMigratedType());
    }
}

