/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.result;

import com.teamscale.index.external.result.ExternalAnalysisResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisResultFindings
extends ExternalAnalysisResult<List<IndexFinding>> {
    private static final long serialVersionUID = 1L;
    private final List<IndexFinding> findings;
    private final @Nullable List<IndexFinding> deletedFindings;

    public ExternalAnalysisResultFindings(List<IndexFinding> findings) {
        this(findings, Collections.emptyList());
    }

    public ExternalAnalysisResultFindings(List<IndexFinding> findings, List<IndexFinding> deletedFindings) {
        this.findings = new ArrayList<IndexFinding>(findings);
        this.deletedFindings = new ArrayList<IndexFinding>(deletedFindings);
        findings.sort(IndexFinding.STABLE_INDEX_FINDING_COMPARATOR);
        deletedFindings.sort(IndexFinding.STABLE_INDEX_FINDING_COMPARATOR);
    }

    @Override
    public List<IndexFinding> getData() {
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    public void removeIf(Predicate<? super IndexFinding> filter) {
        this.findings.removeIf(filter);
    }

    public List<IndexFinding> getDeletedFindings() {
        if (this.deletedFindings == null) {
            return Collections.emptyList();
        }
        return this.deletedFindings;
    }
}

