/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class LintFindingsSynchronizerBase
extends FindingsSynchronizingAnalyzingStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String partition;
    private final Set<String> fileExtensions;
    private static final List<String> ALLOWED_SETTING_FILE_EXTENSIONS = Arrays.asList(".json", ".yml", ".yaml");
    public static final String ALLOW_EXECUTABLE_CONFIG_FILE_FLAG = "com.teamscale.allow-executable-lint-config-file";

    protected LintFindingsSynchronizerBase(String partition, Collection<String> fileExtensions) {
        this.partition = partition;
        this.fileExtensions = new HashSet<String>(fileExtensions);
    }

    public void execute() throws StorageException {
        try {
            CodeScopeAware<Set<TokenElementInfo>> elementsToAnalyze = this.getElementsToAnalyze();
            CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope = this.lintFiles(elementsToAnalyze);
            Set<String> analyzedPaths = elementsToAnalyze.getValues().stream().flatMap(Collection::stream).map(BasicTokenElementInfo::getUniformPath).collect(Collectors.toSet());
            this.synchronizeFindings(findingsPerCodeScope, this.partition, analyzedPaths);
        }
        catch (ConQATException e) {
            LOGGER.error("Error running {}: {}", ((Object)((Object)this)).getClass(), (Object)e, (Object)e);
        }
    }

    private CodeScopeAware<Set<TokenElementInfo>> getElementsToAnalyze() throws StorageException {
        HashSet<TokenElementInfo> elementsToAnalyze = new HashSet<TokenElementInfo>();
        elementsToAnalyze.addAll(this.getAddedOrChangedElementsFromContentDelta());
        elementsToAnalyze.addAll(this.getElementsFromAdditionalDeltaSources());
        CodeScopeAware elementsToAnalyzeByCodeScope = CodeScopeUtils.groupElementsByCodeScope(elementsToAnalyze);
        for (CodeScopeName codeScope : elementsToAnalyzeByCodeScope.getCodeScopeNames()) {
            UnmodifiableSet elementsInCodeScope = UnmodifiableSet.of((Set)((Set)elementsToAnalyzeByCodeScope.getValue(codeScope)));
            Collection<TokenElementInfo> additionalElements = this.getAdditionalRelevantElements((UnmodifiableCollection<TokenElementInfo>)elementsInCodeScope);
            additionalElements = LintFindingsSynchronizerBase.filterForElementsInSameScope(additionalElements, codeScope, (UnmodifiableSet<TokenElementInfo>)elementsInCodeScope);
            HashSet fullListOfElementsInCodeScope = CollectionUtils.unionSet((Collection)elementsInCodeScope, (Collection[])new Collection[]{additionalElements});
            elementsToAnalyzeByCodeScope.setValue(codeScope, (Object)fullListOfElementsInCodeScope);
        }
        return elementsToAnalyzeByCodeScope;
    }

    private List<TokenElementInfo> getAddedOrChangedElementsFromContentDelta() throws StorageException {
        Set<String> contentDeltaRelevantFiles = this.contentDelta.getAddedOrChangedKeysAsStrings().stream().filter(this::isIncludedInAnalysis).collect(Collectors.toSet());
        return this.getContentIndexCache().getValues(contentDeltaRelevantFiles).stream().filter(Objects::nonNull).toList();
    }

    protected static Set<TokenElementInfo> filterForElementsInSameScope(Collection<TokenElementInfo> additionalElements, CodeScopeName codeScope, UnmodifiableSet<TokenElementInfo> elementsDependingOnAdditionalElements) {
        CodeScopeAware<Set> additionalElementsPerCodeScope = CodeScopeUtils.groupElementsByCodeScope(additionalElements, HashSet::new);
        LintFindingsSynchronizerBase.logMessageIfOverarchingCodeScopes(additionalElementsPerCodeScope, codeScope, elementsDependingOnAdditionalElements);
        Set<TokenElementInfo> additionalElementsForCodeScope = (Set<TokenElementInfo>)additionalElementsPerCodeScope.getValueOrNull(codeScope);
        if (additionalElementsForCodeScope == null) {
            additionalElementsForCodeScope = Collections.emptySet();
        }
        return additionalElementsForCodeScope;
    }

    private static void logMessageIfOverarchingCodeScopes(CodeScopeAware<Set<TokenElementInfo>> additionalElementsPerCodeScope, CodeScopeName codeScope, UnmodifiableSet<TokenElementInfo> elementsDependingOnAdditionalElements) {
        List<CodeScopeName> overarchingCodeScopes = additionalElementsPerCodeScope.getCodeScopeNames().stream().filter(otherCodeScope -> !otherCodeScope.equals((Object)codeScope)).toList();
        if (overarchingCodeScopes.isEmpty()) {
            return;
        }
        LOGGER.warn("Analysis may produce incomplete or incorrect results because files from code scope '{}' depend on files that reside in these other code scopes: {}", (Object)codeScope, (Object)StringUtils.concat(overarchingCodeScopes, (String)", "));
        Map elementsByOverarchingCodeScope = overarchingCodeScopes.stream().collect(Collectors.toMap(Function.identity(), overarchingCodeScope -> ((Set)additionalElementsPerCodeScope.getValue(overarchingCodeScope)).stream().toList()));
        LOGGER.debug("The files {} from code scope '{}' depend on these files from other code scopes: {}", elementsDependingOnAdditionalElements, (Object)codeScope, elementsByOverarchingCodeScope);
    }

    protected Collection<TokenElementInfo> getElementsFromAdditionalDeltaSources() throws StorageException {
        return Collections.emptySet();
    }

    protected Collection<TokenElementInfo> getAdditionalRelevantElements(UnmodifiableCollection<TokenElementInfo> initialElements) throws StorageException {
        return Collections.emptySet();
    }

    private CodeScopeAware<ListMap<String, IndexFinding>> lintFiles(CodeScopeAware<Set<TokenElementInfo>> tokenElementsPerCodeScope) throws ConQATException {
        CodeScopeAware findingsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : tokenElementsPerCodeScope.getCodeScopeNames()) {
            Set elementsInCodeScope = (Set)tokenElementsPerCodeScope.getValue(codeScopeName);
            ListMap<String, IndexFinding> findings = this.lintFiles(elementsInCodeScope, codeScopeName);
            findingsPerCodeScope.setValue(codeScopeName, findings);
        }
        return findingsPerCodeScope;
    }

    protected ListMap<String, IndexFinding> lintFiles(Collection<TokenElementInfo> elementsInCodeScope, CodeScopeName codeScopeName) throws ConQATException {
        Optional<String> report = this.executeLint(elementsInCodeScope, codeScopeName);
        if (report.isEmpty()) {
            return new ListMap();
        }
        return this.parseReport(report.get());
    }

    protected abstract Optional<String> executeLint(Collection<TokenElementInfo> var1, CodeScopeName var2) throws ConQATException;

    protected abstract ListMap<String, IndexFinding> parseReport(String var1) throws ConQATException;

    protected static boolean checkSettingsFile(String settingsFile) {
        if (settingsFile == null || settingsFile.isEmpty()) {
            return false;
        }
        if (!FileSystemUtils.isReadableFile((Path)Paths.get(settingsFile, new String[0]))) {
            LOGGER.error("Cannot read settings file: {}", (Object)settingsFile);
            return false;
        }
        return true;
    }

    protected static void assertConfigFileExtensionsIsAllowed(String configurationFilePath) {
        boolean allowExecutableSettingsFile = Boolean.getBoolean(ALLOW_EXECUTABLE_CONFIG_FILE_FLAG);
        if (StringUtils.isEmpty((String)configurationFilePath) || allowExecutableSettingsFile) {
            return;
        }
        if (!StringUtils.endsWithOneOf((String)configurationFilePath.toLowerCase(), (String[])((String[])CollectionUtils.toArray(ALLOWED_SETTING_FILE_EXTENSIONS, String.class)))) {
            throw new SecurityException("Invalid settings file extension for ESLint: '" + configurationFilePath + "'. For security reasons, only the file extensions " + String.valueOf(ALLOWED_SETTING_FILE_EXTENSIONS) + " are enabled by default. Use the JVM flag -Dcom.teamscale.allow-executable-lint-config-file=true to allow arbitrary (potentially executable) setting file extensions like '.js' (discouraged!)");
        }
    }

    protected final boolean isIncludedInAnalysis(String uniformPath) {
        return this.fileExtensions.contains(UniformPathUtils.getExtension((String)uniformPath));
    }

    protected static List<String> createTemporaryFiles(CanonicalFile tempDirectory, Collection<TokenElementInfo> tokenElementInfos, FunctionWithException<String, String, ConQATException> uniformPathTransformer) throws IOException, ConQATException {
        Path tempDirectoryPath = tempDirectory.toPath();
        Files.createDirectories(tempDirectoryPath, new FileAttribute[0]);
        ArrayList<String> relativeFilePaths = new ArrayList<String>();
        for (TokenElementInfo tokenElementInfo : tokenElementInfos) {
            String uniformPath = (String)uniformPathTransformer.apply((Object)tokenElementInfo.getUniformPath());
            Path path = tempDirectoryPath.resolve(uniformPath);
            FileSystemUtils.writeFileUTF8((Path)path, (String)tokenElementInfo.getText());
            relativeFilePaths.add(tempDirectoryPath.relativize(path).toString());
        }
        return relativeFilePaths;
    }
}

