/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.findings.golangcilint.GoLangCILintUtils;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

public class GoLangCILintReportReader
extends FindingReportAnalyzerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TYPE_CHECK_ID = "typecheck";
    private static final Pattern LINE_SPLIT = Pattern.compile("\\)\n");

    public GoLangCILintReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    public ListMap<String, IndexFinding> parseReport(String report) {
        String[] lines;
        ListMap findings = new ListMap();
        if (StringUtils.isEmpty((String)report)) {
            return findings;
        }
        for (String line : lines = LINE_SPLIT.split(report)) {
            if (line.trim().endsWith(TYPE_CHECK_ID)) {
                LOGGER.warn(line);
                continue;
            }
            Pair<String, IndexFinding> uniformPathAndFinding = this.parseUniformPathAndFinding(line);
            if (uniformPathAndFinding == null) continue;
            findings.add((Object)((String)uniformPathAndFinding.getFirst()), (Object)((IndexFinding)uniformPathAndFinding.getSecond()));
        }
        return findings;
    }

    private @Nullable Pair<String, IndexFinding> parseUniformPathAndFinding(String issueLine) {
        if ((issueLine = issueLine.replace("\n", "").trim()).isEmpty()) {
            return null;
        }
        int indexOfColonAndSpace = issueLine.indexOf(": ");
        if (indexOfColonAndSpace == -1) {
            LOGGER.error("Issue line has incorrect format. Expected file location to end with ': '. Issue line is {}", (Object)issueLine);
            return null;
        }
        String filePathAndLineInfos = issueLine.substring(0, indexOfColonAndSpace);
        TextRegionLocation textRegionLocation = this.parseTextRegionLocation(filePathAndLineInfos);
        if (textRegionLocation == null) {
            return null;
        }
        String findingMessageAndPluginLinterId = issueLine.substring(indexOfColonAndSpace + 1);
        int lastIndexOfRightParenthesis = findingMessageAndPluginLinterId.lastIndexOf("(");
        if (lastIndexOfRightParenthesis == -1) {
            LOGGER.error("Issue line has incorrect format. Expected '(' before plugin/check name. Issue line is {} ", (Object)issueLine);
            return null;
        }
        String findingMessage = findingMessageAndPluginLinterId.substring(0, lastIndexOfRightParenthesis).trim();
        String pluginLinterId = findingMessageAndPluginLinterId.substring(lastIndexOfRightParenthesis + 1);
        findingMessage = "depguard".equals(pluginLinterId = StringUtils.stripSuffix((String)pluginLinterId, (String)")").trim()) ? GoLangCILintReportReader.escapeDepguardFindingMessage(findingMessage) : MarkupUtils.escapeMarkdownRelevantSymbols((String)findingMessage);
        return Pair.createPair((Object)textRegionLocation.getUniformPath(), (Object)new IndexFinding(GoLangCILintUtils.createUniqueCheckId(pluginLinterId), "golangci-lint", findingMessage, (ElementLocation)textRegionLocation));
    }

    private static String escapeDepguardFindingMessage(String findingMessage) {
        String startingText = "import '";
        if (findingMessage.startsWith(startingText)) {
            int firstIndexOfSingleQuote = findingMessage.indexOf("'");
            int nextIndexOfSingleQuote = findingMessage.indexOf("'", firstIndexOfSingleQuote + 1);
            if (nextIndexOfSingleQuote == -1) {
                return MarkupUtils.escapeMarkdownRelevantSymbols((String)findingMessage);
            }
            String packageUrl = findingMessage.substring(firstIndexOfSingleQuote + 1, nextIndexOfSingleQuote);
            return findingMessage.replace(packageUrl, packageUrl.replace("/", "/<span></span>").replace(".", "<span>.</span>"));
        }
        return MarkupUtils.escapeMarkdownRelevantSymbols((String)findingMessage);
    }

    private @Nullable TextRegionLocation parseTextRegionLocation(String filePathAndLineInfos) {
        String[] parts = filePathAndLineInfos.split(":");
        String filePath = parts[0].replace('\\', '/');
        Optional<String> optUniformPath = this.matchingPathsLookup.lookupBestPath(filePath, PathLookupOptions.defaults());
        if (optUniformPath.isEmpty()) {
            LOGGER.error("No matching uniform path found for file path: {}. Location info: {}", (Object)filePath, (Object)filePathAndLineInfos);
            return null;
        }
        int line = Integer.parseInt(parts[1]);
        return new TextRegionLocation(optUniformPath.get(), -1, -1, line, line);
    }
}

