/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.ZipToGitImporter;
import com.teamscale.index.gitbridge.abap.ElementMove;
import com.teamscale.index.gitbridge.abap.IWorkTreeFilter;
import com.teamscale.index.gitbridge.abap.InconsistentAbapRepositoryException;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.ZipFile;

public class AbapWorkTreeManager {
    private final Map<UniqueAbapElementName, String> workTreeMap = new HashMap<UniqueAbapElementName, String>();
    private final ZipToGitImporter zipImporter;
    private static final Logger LOGGER = LogManager.getLogger();

    public AbapWorkTreeManager(ZipToGitImporter zipImporter, boolean initializeWorkTreeMap) throws GitBridgeException {
        this.zipImporter = zipImporter;
        if (initializeWorkTreeMap) {
            try {
                this.updateWorkTreeMap(null);
            }
            catch (InconsistentAbapRepositoryException e) {
                throw new GitBridgeException("Inconsistent ABAP repository detected when initializing work tree map.", e);
            }
        }
    }

    private void updateWorkTreeMap(String subPath) throws GitBridgeException, InconsistentAbapRepositoryException {
        String[] patterns = AbapUtils.ABAP_SOURCE_FILES_PATTERNS;
        if (subPath == null) {
            this.workTreeMap.clear();
        } else {
            patterns = (String[])Arrays.stream(patterns).map(pattern -> UniformPathUtils.cleanPath((String)UniformPathUtils.concatenate((String[])new String[]{subPath, pattern}))).toArray(String[]::new);
        }
        for (String path : this.zipImporter.findPathsInWorkTree(patterns)) {
            UniqueAbapElementName name = AbapUtils.createElementNameFromPath((String)path);
            if (subPath == null && this.workTreeMap.containsKey(name)) {
                throw new InconsistentAbapRepositoryException("Multiple locations in work tree for " + String.valueOf(name) + ": " + path + " , " + this.workTreeMap.get(name));
            }
            this.workTreeMap.put(name, path);
        }
    }

    public List<String> extractZipAndUpdateWorkTreeMap(ZipFile zip) throws GitBridgeException {
        List<String> pathsOfModifiedElements = this.zipImporter.extractZipToWorkTree(zip, "sources/");
        ArrayList<String> movedFilesToDelete = new ArrayList<String>();
        for (String path : pathsOfModifiedElements) {
            UniqueAbapElementName element = AbapUtils.createElementNameFromPath((String)path);
            String oldPath = this.workTreeMap.get(element);
            if (oldPath != null && !oldPath.equals(path)) {
                movedFilesToDelete.add(oldPath);
                LOGGER.warn("Moved " + String.valueOf(element) + " from '" + oldPath + "' to new location at '" + path + ", but no move was recored in moved.xml.");
            }
            this.workTreeMap.put(element, path);
        }
        this.delete(movedFilesToDelete, "move");
        return pathsOfModifiedElements;
    }

    public List<String> getWorkTreePaths(List<UniqueAbapElementName> elements) {
        ArrayList<String> paths = new ArrayList<String>();
        for (UniqueAbapElementName element : elements) {
            String path = this.workTreeMap.get(element);
            if (path == null) {
                LOGGER.warn("ABAP element " + String.valueOf(element) + " not found in worktree, ignored.");
                continue;
            }
            paths.add(path);
        }
        return paths;
    }

    public String getWorkTreePathOfAbapFile(String abapFilePath) {
        return this.workTreeMap.get(AbapUtils.createElementNameFromPath((String)abapFilePath));
    }

    public boolean removeElementsFromWorkTree(List<UniqueAbapElementName> elementsToDelete) throws GitBridgeException {
        ArrayList<String> filesToDelete = new ArrayList<String>();
        for (UniqueAbapElementName elementToDelete : elementsToDelete) {
            String file;
            if (elementToDelete.getObjectType() == EAbapObjectType.TABL && !this.workTreeMap.containsKey(elementToDelete)) {
                elementToDelete = new UniqueAbapElementName(elementToDelete.getObjectName(), EAbapObjectType.STRU);
            }
            if ((file = this.workTreeMap.remove(elementToDelete)) != null) {
                filesToDelete.add(file);
                continue;
            }
            LOGGER.warn("Element " + String.valueOf(elementToDelete) + ", which should be deleted, was not found in the work tree. Teamscale repository may be out of sync with ABAP repository. Synchronize by performing a full export.");
        }
        return this.delete(filesToDelete, "delete");
    }

    public Pair<String, String> moveElement(ElementMove move, UniqueAbapElementName element) throws GitBridgeException {
        String sourcePath = this.workTreeMap.get(element);
        if (element.getObjectType() == EAbapObjectType.TABL && sourcePath == null) {
            sourcePath = this.workTreeMap.get(new UniqueAbapElementName(element.getObjectName(), EAbapObjectType.STRU));
        }
        if (sourcePath == null) {
            return null;
        }
        String destinationPath = move.buildDestinationPath(sourcePath);
        this.move(sourcePath, destinationPath);
        this.workTreeMap.put(element, destinationPath);
        return Pair.createPair((Object)sourcePath, (Object)destinationPath);
    }

    public void movePath(String sourcePath, String destinationPath) throws GitBridgeException {
        if (this.zipImporter.isFile(sourcePath)) {
            this.move(sourcePath, destinationPath);
        } else {
            this.zipImporter.move(sourcePath, destinationPath, false);
        }
        try {
            this.updateWorkTreeMap(destinationPath);
        }
        catch (InconsistentAbapRepositoryException e) {
            throw new GitBridgeException("Inconsistent ABAP repository detected when moving " + sourcePath + " to " + destinationPath, e);
        }
    }

    public void reset() throws InconsistentAbapRepositoryException, GitBridgeException {
        this.updateWorkTreeMap(null);
    }

    public Set<UniqueAbapElementName> getElementsFromWorkTree(IWorkTreeFilter filter) throws GitBridgeException {
        HashSet<UniqueAbapElementName> includes = new HashSet<UniqueAbapElementName>();
        for (Map.Entry<UniqueAbapElementName, String> workTreeEntry : this.workTreeMap.entrySet()) {
            String path;
            UniqueAbapElementName element = workTreeEntry.getKey();
            if (!filter.isIncluded(element, path = workTreeEntry.getValue())) continue;
            includes.add(element);
        }
        return includes;
    }

    private boolean delete(List<String> abapFileNames, String operationForLogMessage) throws GitBridgeException {
        List<String> undeletedAbapFiles = this.zipImporter.delete(abapFileNames, false);
        if (!undeletedAbapFiles.isEmpty()) {
            LOGGER.error("Could not delete file " + String.valueOf(undeletedAbapFiles) + " during " + operationForLogMessage + " operation");
        }
        ArrayList<String> sciFilesToDelete = new ArrayList<String>();
        for (String abapFileName : abapFileNames) {
            sciFilesToDelete.add(CodeInspectorGitUtils.buildCodeInspectorFileName(abapFileName));
        }
        try {
            List<String> undeleteSciFiles = this.zipImporter.delete(sciFilesToDelete, true);
            if (!undeleteSciFiles.isEmpty()) {
                LOGGER.warn("Code Inspector Files " + String.valueOf(undeleteSciFiles) + " could not be deleted, as no such files exist.");
            }
        }
        catch (GitBridgeException e) {
            LOGGER.error("Error when deleting Code Inspector files", (Throwable)e);
        }
        return abapFileNames.size() > undeletedAbapFiles.size();
    }

    private void move(String sourceAbapFileName, String targetAbapFileName) throws GitBridgeException {
        this.zipImporter.move(sourceAbapFileName, targetAbapFileName, false);
        String sourceSciFileName = CodeInspectorGitUtils.buildCodeInspectorFileName(sourceAbapFileName);
        String targetSciFileName = CodeInspectorGitUtils.buildCodeInspectorFileName(targetAbapFileName);
        try {
            this.zipImporter.move(sourceSciFileName, targetSciFileName, true);
        }
        catch (GitBridgeException e) {
            LOGGER.error("Error when move Code Inspector file " + sourceSciFileName + " to " + targetSciFileName, (Throwable)e);
        }
    }
}

