/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.cache;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.jira.cache.JiraGlobalCacheIndex;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.client.JiraInstanceAwareClient;
import com.teamscale.index.issues.jira.parser.JiraIssueParser;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionConfiguration;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class JiraGlobalCacheUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JiraConnectionConfiguration configuration;
    private final long pollingIntervalSeconds;
    private final JiraGlobalCacheIndex index;
    private final JiraInstanceAwareClient jiraClient;
    private final int configurationId;

    public JiraGlobalCacheUpdater(JiraConnectionConfiguration configuration, long pollingIntervalSeconds, JiraGlobalCacheIndex index) throws BugTrackerException {
        this.configuration = configuration;
        this.pollingIntervalSeconds = pollingIntervalSeconds;
        this.index = index;
        JiraClient jiraCommonClient = new JiraClient(configuration.getUrl(), configuration.getUsername(), configuration.getPassword(), configuration.getCookies());
        this.jiraClient = jiraCommonClient.toInstanceAwareClient(JiraGlobalCacheUpdater.getJiraInstanceType(configuration, jiraCommonClient));
        this.configurationId = configuration.getConfigurationId();
    }

    private static EJiraInstanceType getJiraInstanceType(JiraConnectionConfiguration configuration, JiraClient jiraCommonClient) throws BugTrackerException {
        EJiraInstanceType configuredJiraInstanceType = configuration.getJiraInstanceType();
        if (configuredJiraInstanceType != null) {
            return configuredJiraInstanceType;
        }
        try {
            return jiraCommonClient.getInstanceType();
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheDataIfNeeded() throws StorageException, BugTrackerException, ServiceCallException {
        long lastGlobalUpdateTimestamp = this.index.getLastUpdateTimestamp(this.configurationId);
        if (this.isGlobalDataUpToDate(lastGlobalUpdateTimestamp)) {
            return;
        }
        Lock lock = this.index.obtainCacheUpdateLock();
        lock.lock();
        try {
            lastGlobalUpdateTimestamp = this.index.getLastUpdateTimestamp(this.configuration.getConfigurationId());
            if (this.isGlobalDataUpToDate(lastGlobalUpdateTimestamp)) {
                return;
            }
            Instant currentTime = DateTimeUtils.now();
            this.performCacheUpdate(lastGlobalUpdateTimestamp);
            LOGGER.debug("Time needed for Jira cache update: {} ms", new Supplier[]{() -> Duration.between(DateTimeUtils.now(), currentTime).toMillis()});
            this.index.setLastUpdateTimestamp(this.configuration.getConfigurationId(), currentTime.toEpochMilli());
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isGlobalDataUpToDate(long lastGlobalUpdateTimestamp) {
        if (lastGlobalUpdateTimestamp == 0L) {
            return false;
        }
        long currentPollingIntervalMillis = Instant.now().toEpochMilli() - lastGlobalUpdateTimestamp;
        return currentPollingIntervalMillis < this.pollingIntervalSeconds * 1000L;
    }

    private void performCacheUpdate(long lastScanTimestamp) throws BugTrackerException, StorageException, ServiceCallException {
        LOGGER.debug("Performing cache update for the last scan timestamp {}", (Object)lastScanTimestamp);
        PairList<String, String> retrievedIssues = this.retrieveIssues(lastScanTimestamp);
        this.index.updateIssueData(this.configuration.getConfigurationId(), retrievedIssues, Instant.now().toEpochMilli());
    }

    public void performCacheCleanupIfNeeded(Instant timestamp) throws StorageException, BugTrackerException, ServiceCallException {
        if (this.shouldSkipGlobalCacheCleanup(timestamp, this.configuration.getConfigurationId())) {
            return;
        }
        this.performGlobalCacheCleanup(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performGlobalCacheCleanup(Instant timestamp) throws StorageException, BugTrackerException, ServiceCallException {
        int configurationId = this.configuration.getConfigurationId();
        Lock lock = this.index.obtainCacheUpdateLock();
        lock.lock();
        try {
            if (this.shouldSkipGlobalCacheCleanup(timestamp, configurationId)) {
                return;
            }
            this.performCacheCleanup();
            this.index.setLastCleanupTimestamp(configurationId, timestamp.toEpochMilli());
        }
        finally {
            lock.unlock();
        }
    }

    private boolean shouldSkipGlobalCacheCleanup(Instant timestamp, int configurationId) throws StorageException {
        return !OnceEveryDayCleanupStrategy.shouldPerformCleanup(timestamp, Instant.ofEpochMilli(this.index.getLastCleanupTimestamp(configurationId)));
    }

    private void performCacheCleanup() throws StorageException, BugTrackerException, ServiceCallException {
        LOGGER.debug("Performing Cache Cleanup.");
        PairList<String, String> allJiraIssuesFromServer = this.retrieveAllIssues();
        LOGGER.debug("Fetched {} issues from the server", (Object)allJiraIssuesFromServer.size());
        List<String> issueIdsInIndex = this.index.getAllStoredIssueIds(this.configuration.getConfigurationId());
        HashSet deletedIssueKeys = CollectionUtils.differenceSet(issueIdsInIndex, (Collection[])new Collection[]{allJiraIssuesFromServer.extractFirstList()});
        LOGGER.debug("Found {} deleted issue keys.", (Object)deletedIssueKeys.size());
        if (!deletedIssueKeys.isEmpty()) {
            LOGGER.debug("Removing deleted issues.");
            this.index.removeIssues(this.configuration.getConfigurationId(), deletedIssueKeys);
        }
    }

    private PairList<String, String> retrieveAllIssues() throws BugTrackerException, ServiceCallException {
        return this.retrieveIssues(0L);
    }

    private PairList<String, String> retrieveIssues(long lastScanTimestamp) throws BugTrackerException, ServiceCallException {
        LOGGER.traceEntry("Retrieving issues for the last scan timestamp {}", new Object[]{lastScanTimestamp});
        Set<String> projects = this.getStillExistingProjects();
        if (projects.isEmpty() && !this.configuration.getProjects().isEmpty()) {
            LOGGER.warn("Could not locate any of the configured Jira projects. Please check access permissions of the Jira user and make sure that these projects are visible to the user.");
            return (PairList)LOGGER.traceExit((Object)PairList.emptyPairList());
        }
        LOGGER.debug("Performing cache update for the for the connector {} for the following projects: {}", (Object)this.configuration.getConfigurationId(), (Object)String.join((CharSequence)",", projects));
        UnmodifiableList fields = CollectionUtils.asUnmodifiable(CollectionUtils.unionSet((Collection)ExternalToolIssueCustomField.getIds(this.configuration.getResolvedCustomJiraFields()), (Collection[])new Collection[]{JiraIssueParser.FIELDS}).stream().toList());
        return this.jiraClient.fetchIssues(projects, lastScanTimestamp, (UnmodifiableList<String>)fields, this.configuration.getIssueTypes());
    }

    private Set<String> getStillExistingProjects() throws BugTrackerException, ServiceCallException {
        LOGGER.traceEntry("Checking which jira projects still exist.", new Supplier[0]);
        Map<String, String> projectNamesByJiraKey = this.jiraClient.getProjectNamesByKey();
        if (projectNamesByJiraKey.isEmpty()) {
            LOGGER.debug("Did not receive any names of still existing jira projects.");
        }
        HashSet<String> projectNames = new HashSet<String>(projectNamesByJiraKey.values());
        HashSet missingProjects = CollectionUtils.differenceSet(this.configuration.getProjects(), (Collection[])new Collection[]{projectNames, projectNamesByJiraKey.keySet()});
        if (!missingProjects.isEmpty()) {
            LOGGER.warn(() -> "Some Jira projects are no longer present or accessible on the Jira server: " + StringUtils.concat((Iterable)missingProjects, (String)", "));
        }
        return (Set)LOGGER.traceExit("Still existing projects: {}", (Object)CollectionUtils.filterToSet(this.configuration.getProjects(), projectKeyOrName -> projectNamesByJiraKey.containsKey(projectKeyOrName) || projectNames.contains(projectKeyOrName)));
    }
}

