/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public record JiraJsonIssue(@JsonProperty(value="key") String key, @JsonProperty(value="fields") Fields fields, @JsonProperty(value="renderedFields") RenderedFields renderedFields, @JsonProperty(value="changelog") ChangeLog changeLog) implements Serializable
{
    private static final long serialVersionUID = 1L;
    public static final String PROJECT_KEY = "project";

    public static void addAdditionalFields(Fields jiraIssueFields, String key, List<String> customFieldNames, List<String> customFieldValues, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields == null) {
            jiraIssueFields = new Fields();
        }
        JiraJsonIssue.addProjectKey(key, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addIssueTypeField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addPriorityField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addResolutionField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addFixVersionField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addComponentField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addLabelsField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addCustomFields(customFieldNames, customFieldValues, additionalFieldNames, additionalFieldValues);
    }

    public static TeamscaleIssue createTeamscaleIssue(String key, String connectorId, String url, Fields jiraIssueFields, String description, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields == null) {
            jiraIssueFields = new Fields();
        }
        return new TeamscaleIssue(new TeamscaleIssueId(connectorId, key), StringUtils.emptyIfNull((String)jiraIssueFields.summary), JiraJsonIssue.getUserNameOrEmpty(jiraIssueFields.assignee), JiraJsonIssue.getUserNameOrEmpty(jiraIssueFields.reporter), StringUtils.emptyIfNull((String)description), JiraJsonIssue.getTimeOrZero(jiraIssueFields.created), JiraJsonIssue.getTimeOrZero(jiraIssueFields.updated), JiraJsonIssue.getNameOrEmpty(jiraIssueFields.status), JiraJsonIssue.isClosed(jiraIssueFields.resolution), url, additionalFieldNames, additionalFieldValues, JiraJsonIssue.getParentIdOrNull(jiraIssueFields.issueLinks));
    }

    private static void addProjectKey(String key, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        additionalFieldNames.add(PROJECT_KEY);
        additionalFieldValues.add(key.split("-")[0]);
    }

    private static void addCustomFields(List<String> customFieldNames, List<String> customFieldValues, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        additionalFieldNames.addAll(customFieldNames);
        additionalFieldValues.addAll(customFieldValues);
    }

    private static void addLabelsField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.labels)) {
            additionalFieldNames.add("Labels");
            jiraIssueFields.labels.replaceAll(String::trim);
            additionalFieldValues.add(StringUtils.concat(jiraIssueFields.labels, (String)","));
        }
    }

    private static void addComponentField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.components)) {
            additionalFieldNames.add("Components");
            additionalFieldValues.add(StringUtils.concat((Iterable)CollectionUtils.map(jiraIssueFields.components, component -> component.name.trim()), (String)","));
        }
    }

    private static void addFixVersionField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.fixVersions)) {
            additionalFieldNames.add("Fix Versions");
            additionalFieldValues.add(StringUtils.concat((Iterable)CollectionUtils.map(jiraIssueFields.fixVersions, fixVersion -> fixVersion.name.trim()), (String)","));
        }
    }

    private static void addResolutionField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        String resolutionValue = "Unresolved";
        if (jiraIssueFields.resolution != null) {
            resolutionValue = jiraIssueFields.resolution.name;
        }
        additionalFieldNames.add("Resolution");
        additionalFieldValues.add(resolutionValue);
    }

    private static void addPriorityField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields.priority != null) {
            additionalFieldNames.add("Priority");
            additionalFieldValues.add(jiraIssueFields.priority.name);
        }
    }

    private static void addIssueTypeField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields.issueType != null) {
            additionalFieldNames.add("Type");
            additionalFieldValues.add(jiraIssueFields.issueType.name);
        }
    }

    private static String getParentIdOrNull(List<IssueLink> issueLinks) {
        if (issueLinks == null) {
            return null;
        }
        for (IssueLink issueLink : issueLinks) {
            if (!issueLink.type.name.equals("Parent") || issueLink.inwardIssue == null) continue;
            return issueLink.inwardIssue.key;
        }
        return null;
    }

    private static String getUserNameOrEmpty(User user) {
        if (user == null) {
            return "";
        }
        return StringUtils.isEmptyOrElse((String)user.name, (String)StringUtils.emptyIfNull((String)user.displayName));
    }

    private static String getNameOrEmpty(IFieldWithName field) {
        if (field == null) {
            return "";
        }
        return StringUtils.emptyIfNull((String)field.getName());
    }

    private static long getTimeOrZero(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    private static boolean isClosed(Resolution resolution) {
        if (resolution == null) {
            return false;
        }
        return !"Unresolved".equals(resolution.name);
    }

    public record Resolution(@JsonProperty(value="name") String name) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME = "Resolution";
        public static final String UNRESOLVED = "Unresolved";

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record Fields(@JsonProperty(value="summary") String summary, @JsonProperty(value="assignee") User assignee, @JsonProperty(value="reporter") User reporter, @JsonProperty(value="description") String description, @JsonProperty(value="created") Date created, @JsonProperty(value="updated") Date updated, @JsonProperty(value="issuetype") IssueType issueType, @JsonProperty(value="issuelinks") ArrayList<IssueLink> issueLinks, @JsonProperty(value="priority") Priority priority, @JsonProperty(value="status") Status status, @JsonProperty(value="resolution") Resolution resolution, @JsonProperty(value="fixVersions") ArrayList<FixVersion> fixVersions, @JsonProperty(value="components") ArrayList<Component> components, @JsonProperty(value="labels") ArrayList<String> labels) implements Serializable
    {
        private static final long serialVersionUID = 1L;
        public static final String LABELS_FIELD_NAME = "Labels";

        public Fields() {
            this(null, null, null, null, null, null, null, null, null, null, new Resolution("Unresolved"), null, null, null);
        }
    }

    public record RenderedFields(@JsonProperty(value="description") String description) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }

    public record ChangeLog(@JsonProperty(value="histories") HistoryEntry[] histories) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }

    public record User(@JsonProperty(value="name") String name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="active") boolean active) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record Status(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static interface IFieldWithName {
        public String getName();
    }

    public record Component(@JsonProperty(value="name") String name) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME = "Components";

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record FixVersion(@JsonProperty(value="name") String name) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME = "Fix Versions";

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record Priority(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME = "Priority";

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record IssueType(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="id") String id) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;
        public static final String FIELD_NAME = "Type";

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record IssueLink(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="type") IssueLinkType type, @JsonProperty(value="inwardIssue") JiraJsonIssue inwardIssue) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record IssueLinkType(@JsonProperty(value="name") String name, @JsonProperty(value="inward") String inward) implements IFieldWithName,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return this.name;
        }
    }

    public record HistoryChangeItem(@JsonProperty(value="field") String field, @JsonProperty(value="fieldtype") String fieldType, @JsonProperty(value="from") String from, @JsonProperty(value="fromString") String fromString) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }

    public record HistoryEntry(@JsonProperty(value="created") Date created, @JsonProperty(value="items") HistoryChangeItem[] items) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "HistoryEntry[created=" + String.valueOf(this.created) + ", items=" + Arrays.toString(this.items) + "]";
        }

        public HistoryEntry mergeWith(HistoryEntry history) {
            int oldItemsSize = this.items.length;
            HistoryChangeItem[] mergedItems = Arrays.copyOf(this.items, oldItemsSize + history.items.length);
            System.arraycopy(history.items, 0, mergedItems, oldItemsSize, history.items.length);
            return new HistoryEntry(this.created, mergedItems);
        }
    }
}

