/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.configuration.model.option.EJiraIssueUpdateCategory;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.issues.jira.voting.JiraVotingInput;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.FindingIssuesMappingIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

final class JiraIssuesToUpdateCalculator {
    private final CommitDescriptor schedulingCommit;
    private final ProjectStorageSystem projectStorageSystem;

    public static Set<TeamscaleIssueId> forDebugService(JobDescriptor jobDescriptor) {
        String concatenatedIssueIds = jobDescriptor.getParameter();
        List<String> issueIds = List.of(Objects.requireNonNull(concatenatedIssueIds).split(","));
        return CollectionUtils.mapToSet(issueIds, TeamscaleIssueId::fromInternalId);
    }

    public static Set<TeamscaleIssueId> forCommit(CommitDescriptor schedulingCommit, Set<EJiraIssueUpdateCategory> updateCategories, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return new JiraIssuesToUpdateCalculator(schedulingCommit, projectStorageSystem).getIssuesToUpdate(updateCategories);
    }

    public static Set<TeamscaleIssueId> forResolvedFindings(ProjectStorageSystem projectStorageSystem, Collection<JiraVotingInput> jiraVotingInput) throws StorageException {
        List findingChurns = jiraVotingInput.stream().map(JiraVotingInput::findingChurnList).flatMap(Optional::stream).toList();
        Set removedFindingIds = findingChurns.stream().map(FindingChurnList::getRemovedFindings).flatMap(Collection::stream).map(TrackedFinding::getId).collect(Collectors.toSet());
        return ((FindingIssuesMappingIndex)projectStorageSystem.openProjectIndex(FindingIssuesMappingIndex.class, null)).getIssuesForFindingIds(new ArrayList<String>(removedFindingIds));
    }

    private JiraIssuesToUpdateCalculator(@NonNull CommitDescriptor schedulingCommit, @NonNull ProjectStorageSystem projectStorageSystem) {
        this.schedulingCommit = schedulingCommit;
        this.projectStorageSystem = projectStorageSystem;
    }

    private Set<TeamscaleIssueId> getIssuesToUpdate(Set<EJiraIssueUpdateCategory> categories) throws StorageException {
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)((RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null)).getEntry(this.schedulingCommit);
        if (logEntry == null || logEntry.getCommitTypes() == null) {
            return Collections.emptySet();
        }
        HashSet<TeamscaleIssueId> issuesToUpdate = new HashSet<TeamscaleIssueId>();
        Set<ECommitType> commitTypes = logEntry.getCommitTypes();
        if (commitTypes.contains((Object)ECommitType.EXTERNAL_ANALYSIS) && categories.contains(EJiraIssueUpdateCategory.TGA_COVERAGE)) {
            issuesToUpdate.addAll(this.getIssuesAffectedByCoverageUpload());
        }
        if (commitTypes.contains((Object)ECommitType.CODE_COMMIT)) {
            issuesToUpdate.addAll(this.getIssuesForCodeCommit());
        }
        if (commitTypes.contains((Object)ECommitType.BLACKLIST_COMMIT)) {
            issuesToUpdate.addAll(this.getIssuesAffectedByBlacklistingEvent());
        }
        return issuesToUpdate;
    }

    private List<TeamscaleIssueId> getIssuesForCodeCommit() throws StorageException {
        List<TeamscaleIssueId> issuesForCommit = ((RepositoryCommitIssueMappingIndex)this.projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null)).getIssuesForCommit(this.schedulingCommit);
        return CollectionUtils.emptyIfNull(issuesForCommit);
    }

    private Set<TeamscaleIssueId> getIssuesAffectedByBlacklistingEvent() throws StorageException {
        FindingBlacklistCommit commitInfo = (FindingBlacklistCommit)((Object)((FindingBlacklistStagingIndex)this.projectStorageSystem.openProjectIndex(FindingBlacklistStagingIndex.class, JiraIssuesToUpdateCalculator.getSchedulingCommitHistoryAccessOption(this.schedulingCommit))).getCommitInfo());
        if (commitInfo == null) {
            return Collections.emptySet();
        }
        Set findingIds = CollectionUtils.mapToSet(commitInfo.getBlacklistEvents(), FindingBlacklistEvent::getFindingId);
        return ((FindingIssuesMappingIndex)this.projectStorageSystem.openProjectIndex(FindingIssuesMappingIndex.class, null)).getIssuesForFindingIds(new ArrayList<String>(findingIds));
    }

    private Set<TeamscaleIssueId> getIssuesAffectedByCoverageUpload() throws StorageException {
        List partitionNames = ((LineCoverageIndex)this.projectStorageSystem.openProjectIndex(LineCoverageIndex.class, JiraIssuesToUpdateCalculator.getSchedulingCommitHistoryAccessOption(this.schedulingCommit))).getPartitions();
        Set<MethodLocation> newlyCoveredMethods = ((NewlyCoveredMethodsIndex)this.projectStorageSystem.openProjectIndex(NewlyCoveredMethodsIndex.class, null)).getNewlyCoveredMethodLocations(this.schedulingCommit, (List<String>)partitionNames, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
        JiraIssuesToUpdateCalculator.getSchedulingCommitHistoryAccessOption(this.schedulingCommit);
        return ((MethodIssueIndex)this.projectStorageSystem.openProjectIndex(MethodIssueIndex.class, JiraIssuesToUpdateCalculator.getSchedulingCommitHistoryAccessOption(this.schedulingCommit))).getIssuesFromPathBasedMappings(Lists.newArrayList(newlyCoveredMethods));
    }

    private static @NonNull HistoryAccessOption getSchedulingCommitHistoryAccessOption(CommitDescriptor schedulingCommit) {
        return HistoryAccessOption.readTimestamp((String)schedulingCommit.getBranchName(), (long)schedulingCommit.getTimestamp());
    }
}

