/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.teamscale;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.teamscale.CommitMessageIssueSynchronizer;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@ConnectorDescriptor
public class CommitMessageIssueTrackerConnectorDescriptor
extends ConnectorDescriptorBase {
    private static final String CONNECTOR_IDENTIFIER_PARAMETER_NAME = "Issue Connector identifier";
    private static final String ISSUE_SUBJECT_PATTERN = "Issue subject pattern in commit messages";
    private static final String ISSUE_SUBJECT_INSIDE_COMMIT_MESSAGE_PATTERN_DESCRIPTION = "The pattern used to extract an issue subject out of the first commit message referencing a new issue ID. This is a regular expression that must contain one capturing group (enclosed in parentheses). The capturing group matched in the first commit referencing a new issue ID will be considered that issue's subject. For example, 'CR#\\d+ (.*)' would set the subject of issue '42' from the commit 'CR#42 Fix build' to 'Fix build'. Use '(?:...)' to write non-capturing groups.";
    @ConfigExposed(name="Issue Connector identifier", description="A unique identifier used to reference the issue connector.", required=true)
    private String connectorIdentifier = "issues1";
    @ConfigExposed(name="Issue ID pattern in commit messages", description="The pattern used to recognize issue IDs in a commit messages. This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'CR#[ :]*(\\d+)' which would link the issue '42' to the commit 'CR#42 fixed build'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.")
    private String issueIdPattern = "(\\w+-\\d+)";
    @ConfigExposed(name="Issue subject pattern in commit messages", description="The pattern used to extract an issue subject out of the first commit message referencing a new issue ID. This is a regular expression that must contain one capturing group (enclosed in parentheses). The capturing group matched in the first commit referencing a new issue ID will be considered that issue's subject. For example, 'CR#\\d+ (.*)' would set the subject of issue '42' from the commit 'CR#42 Fix build' to 'Fix build'. Use '(?:...)' to write non-capturing groups.")
    private String issueSubjectPattern = "";
    @ConfigExposed(name="Issue ID transformation in commit messages", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A transformation expression in the form `original expression -> transformed expression` which can translate the issue references in commit messages to actual issue IDs in the issue tracker. For example, `JIRA-(\\d+) -> MY_PROJECT_KEY-$1` (using the **Issue ID pattern in commit messages** `(JIRA-\\d+)`).\n**Important**: `original expression` is applied to matches of the capturing groups in the **Issue ID pattern in commit messages** option (**not the entire commit message**).\nIn `transformed expression`, capturing groups from `original expression` can be referenced by `$1`, `$2`, ...")
    private PairList<String, String> issueIdTransformation = new PairList();

    public CommitMessageIssueTrackerConnectorDescriptor() {
        super((IConnectorEnum)EIssueTracker.COMMIT_MESSAGE, EConnectorType.ISSUE_TRACKER);
        this.autoExpose();
    }

    public String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    public String getConnectorIdentifierOptionName() {
        return CONNECTOR_IDENTIFIER_PARAMETER_NAME;
    }

    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateAndReturnPattern((String)this.issueIdPattern, (String)"Issue ID pattern in commit messages");
        ConnectorUtils.validateCapturingGroupInRegexPattern((String)this.issueSubjectPattern, (String)ISSUE_SUBJECT_PATTERN);
    }

    protected void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) throws StorageException {
    }

    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String uri) {
    }

    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        triggerCreator.createTrigger(new TriggerBuilder(CommitMessageIssueSynchronizer.class, ETriggerConcurrency.PARALLEL).setTriggerParameter("connector-id", this.connectorIdentifier).setTriggerParameter("subject-pattern", this.issueSubjectPattern));
        triggerCreator.createTrigger(this.createIssueMappingSynchronizer(), this.connectorIdentifier);
        triggerCreator.createTrigger(BugTrackerConnectorDescriptorBase.createPathIssueSynchronizer(), this.connectorIdentifier);
    }

    private TriggerBuilder createIssueMappingSynchronizer() {
        TriggerBuilder issueMappingSynchronizer = BugTrackerConnectorDescriptorBase.createIssueMappingSynchronizer(this.connectorIdentifier);
        issueMappingSynchronizer.setTriggerParameter("issue-in-commit-pattern", this.issueIdPattern);
        issueMappingSynchronizer.setTriggerParameter("issue-id-commit-rename-rule", ITriggerParameter.of(this.issueIdTransformation));
        return issueMappingSynchronizer;
    }
}

