/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.teamscale.core.tfs.wiql.IWiqlWhereOperator;
import com.teamscale.core.tfs.wiql.SimpleWiqlBuilder;
import com.teamscale.core.tfs.wiql.WiqlWhereClause;
import com.teamscale.index.issues.tfs.TfsWorkItemFilterParameters;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public class TfsWiqlHelper {
    public static String createWiqlQueryString(long changedOnOrAfterTimestamp, long olderThanId, Collection<String> projects, TfsWorkItemFilterParameters filterParameters, Collection<String> itemTypes, List<String> fields) {
        SimpleWiqlBuilder wiqlBuilder = new SimpleWiqlBuilder();
        wiqlBuilder.select(fields).from("WorkItems");
        if (changedOnOrAfterTimestamp >= 0L) {
            wiqlBuilder.where(new WiqlWhereClause[]{WiqlWhereClause.simple((String)"System.ChangedDate", (IWiqlWhereOperator.EWiqlSimpleOperator)IWiqlWhereOperator.EWiqlSimpleOperator.GE, (String)TfsWiqlHelper.convertTimestampToDateString(changedOnOrAfterTimestamp))});
        }
        if (olderThanId > 0L) {
            wiqlBuilder.where(new WiqlWhereClause[]{WiqlWhereClause.simple((String)"System.Id", (IWiqlWhereOperator.EWiqlSimpleOperator)IWiqlWhereOperator.EWiqlSimpleOperator.LT, (String)Long.toString(olderThanId))});
        }
        wiqlBuilder.where(new WiqlWhereClause[]{WiqlWhereClause.collection((String)"System.TeamProject", (IWiqlWhereOperator.EWiqlCollectionOperator)IWiqlWhereOperator.EWiqlCollectionOperator.IN, projects)});
        wiqlBuilder.where(new WiqlWhereClause[]{filterParameters.buildWiqlClause()});
        wiqlBuilder.where(new WiqlWhereClause[]{WiqlWhereClause.collection((String)"System.WorkItemType", (IWiqlWhereOperator.EWiqlCollectionOperator)IWiqlWhereOperator.EWiqlCollectionOperator.IN, itemTypes)});
        wiqlBuilder.orderBy(false, "System.Id");
        return wiqlBuilder.toString();
    }

    @VisibleForTesting
    static String convertTimestampToDateString(long timestamp) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC);
        return dateFormatter.format(Instant.ofEpochMilli(timestamp));
    }
}

