/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class ReviewCommentEngineParameters {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TrackedFindingsByIdIndex trackedFindingsByIdIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TrackedFindingsIndex trackedFindingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;

    public ReviewCommentEngineParameters() {
    }

    public ReviewCommentEngineParameters(TrackedFindingsByIdIndex trackedFindingsByIdIndex, TrackedFindingsIndex trackedFindingsIndex, MethodInfoIndex methodInfoIndex, TokenElementLineInfoIndex tokenElementLineInfoIndex) {
        this.trackedFindingsByIdIndex = trackedFindingsByIdIndex;
        this.trackedFindingsIndex = trackedFindingsIndex;
        this.methodInfoIndex = methodInfoIndex;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
    }

    public static ReviewCommentEngineParameters create(CommitDescriptor commit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        TrackedFindingsByIdIndex trackedFindingsByIdIndex = (TrackedFindingsByIdIndex)projectStorageSystem.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        TrackedFindingsIndex trackedFindingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        MethodInfoIndex methodInfoIndex = (MethodInfoIndex)projectStorageSystem.openProjectIndex(MethodInfoIndex.class, historyAccessOption);
        TokenElementLineInfoIndex tokenElementLineInfoIndex = (TokenElementLineInfoIndex)projectStorageSystem.openProjectIndex(TokenElementLineInfoIndex.class, historyAccessOption);
        return new ReviewCommentEngineParameters(trackedFindingsByIdIndex, trackedFindingsIndex, methodInfoIndex, tokenElementLineInfoIndex);
    }

    public MethodInfoIndex getMethodInfoIndex() {
        return this.methodInfoIndex;
    }

    public TrackedFindingsByIdIndex getTrackedFindingsByIdIndex() {
        return this.trackedFindingsByIdIndex;
    }

    public TrackedFindingsIndex getTrackedFindingsIndex() {
        return this.trackedFindingsIndex;
    }

    public TokenElementLineInfoIndex getTokenElementLineInfoIndex() {
        return this.tokenElementLineInfoIndex;
    }
}

