/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.project;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="external-findings-groups-descriptions", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={ExternalAnalysisGroup.class, ExternalFindingsDescription.class})
public class ExternalFindingsGroupDescriptionIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "external-findings-groups-descriptions";
    public static final String KEY_SEGMENT_SEPARATOR = ":";
    public static final String GROUP_PREFIX = "group:";
    public static final String DESCRIPTION_PREFIX = "description:";

    public ExternalFindingsGroupDescriptionIndex(IStore store) {
        super(store);
    }

    public ExternalAnalysisGroup getGroup(String name, EAnalysisTool analysisTool) throws StorageException {
        return (ExternalAnalysisGroup)StorageUtils.deserialize((byte[])this.store.getWithString(ExternalFindingsGroupDescriptionIndex.deriveGroupKey(name, analysisTool)));
    }

    public void storeGroups(List<ExternalAnalysisGroup> groups, EAnalysisTool analysisTool) throws IOException, StorageException {
        PairList byteKeysValues = new PairList(groups.size());
        for (ExternalAnalysisGroup group : groups) {
            String key = ExternalFindingsGroupDescriptionIndex.deriveGroupKey(group.getGroupName(), analysisTool);
            byteKeysValues.add((Object)StringUtils.stringToBytes((String)key), (Object)SerializationUtils.serializeToByteArray((Serializable)group));
        }
        this.store.put(byteKeysValues);
    }

    public void deleteGroup(String name, EAnalysisTool analysisTool) throws StorageException {
        this.store.removeWithString(ExternalFindingsGroupDescriptionIndex.deriveGroupKey(name, analysisTool));
    }

    private static String deriveGroupKey(String name, EAnalysisTool analysisTool) throws StorageException {
        if (name == null) {
            throw new StorageException("Finding group has no name.");
        }
        return GROUP_PREFIX + analysisTool.getReadableName() + KEY_SEGMENT_SEPARATOR + name;
    }

    private static String deriveDescriptionKey(String typeId, EAnalysisTool analysisTool) throws StorageException {
        if (typeId == null) {
            throw new StorageException("Finding group has no name.");
        }
        return DESCRIPTION_PREFIX + analysisTool.getReadableName() + KEY_SEGMENT_SEPARATOR + typeId;
    }

    public List<ExternalFindingsDescription> getDescriptions(EAnalysisTool analysisTool) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(DESCRIPTION_PREFIX + analysisTool.getReadableName() + KEY_SEGMENT_SEPARATOR, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public List<ExternalFindingsDescription> getAllDescriptions() throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(DESCRIPTION_PREFIX, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public PairList<ExternalFindingsDescription, EAnalysisTool> getAllDescriptionsWithTools() throws StorageException {
        PairList result = new PairList();
        PairList rawExternalFindings = new PairList();
        this.store.scan(DESCRIPTION_PREFIX, (IKeyValueCallback)new KeyValueCollectingCallback(rawExternalFindings));
        for (Pair rawExternalFinding : rawExternalFindings) {
            String key = StringUtils.bytesToString((byte[])((byte[])rawExternalFinding.getFirst()));
            EAnalysisTool tool = ExternalFindingsGroupDescriptionIndex.extractToolFromDescriptionKey(key);
            ExternalFindingsDescription findingsDescription = (ExternalFindingsDescription)StorageUtils.deserialize((byte[])((byte[])rawExternalFinding.getSecond()));
            result.add((Object)findingsDescription, (Object)tool);
        }
        return result;
    }

    private static EAnalysisTool extractToolFromDescriptionKey(String descriptionKey) {
        String keyWithoutPrefix = StringUtils.stripPrefix((String)descriptionKey, (String)DESCRIPTION_PREFIX);
        String toolName = keyWithoutPrefix.split(KEY_SEGMENT_SEPARATOR)[0];
        return EAnalysisTool.fromName((String)toolName);
    }

    public List<ExternalAnalysisGroup> getGroups(EAnalysisTool analysisTool) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(GROUP_PREFIX + analysisTool.getReadableName() + KEY_SEGMENT_SEPARATOR, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public List<ExternalAnalysisGroup> getAllGroups() throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(GROUP_PREFIX, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public ExternalFindingsDescription getDescription(String typeId, EAnalysisTool analysisTool) throws StorageException {
        return (ExternalFindingsDescription)StorageUtils.deserialize((byte[])this.store.getWithString(ExternalFindingsGroupDescriptionIndex.deriveDescriptionKey(typeId, analysisTool)));
    }

    public void storeDescriptions(List<ExternalFindingsDescription> descriptions, EAnalysisTool analysisTool) throws StorageException, IOException {
        PairList byteKeysValues = new PairList();
        for (ExternalFindingsDescription description : descriptions) {
            String key = ExternalFindingsGroupDescriptionIndex.deriveDescriptionKey(description.getTypeId(), analysisTool);
            byteKeysValues.add((Object)StringUtils.stringToBytes((String)key), (Object)SerializationUtils.serializeToByteArray((Serializable)description));
        }
        this.store.put(byteKeysValues);
    }

    public void deleteDescription(String typeId, EAnalysisTool analysisTool) throws StorageException {
        this.store.removeWithString(ExternalFindingsGroupDescriptionIndex.deriveDescriptionKey(typeId, analysisTool));
    }

    public void copyContentFrom(ExternalFindingsGroupDescriptionIndex otherIndex) throws StorageException {
        StorageUtils.copyStore((IStore)otherIndex.store, (IStore)this.store);
    }
}

