/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.teamscale.index.quality_report.QualityArtifactDescriptor;
import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public abstract class QualityArtifactIndexBase<QUALITY_ARTIFACT extends QualityArtifactDescriptor> {
    private final ValueIndex<QUALITY_ARTIFACT> delegate;

    protected QualityArtifactIndexBase(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable QUALITY_ARTIFACT getById(String id) throws StorageException {
        return (QUALITY_ARTIFACT)((QualityArtifactDescriptor)this.delegate.getValue(id));
    }

    public void storeQualityArtifactWithNewId(QUALITY_ARTIFACT artifact) throws StorageException {
        this.delegate.runLocked("update", () -> {
            String key = this.generateIdForNewArtifact();
            artifact.getMetaInfo().setId(key);
            this.delegate.setValue(key, (Object)artifact);
        });
    }

    public void remove(QUALITY_ARTIFACT artifact) throws StorageException {
        this.delegate.removeValue(((QualityArtifactDescriptor)artifact).getMetaInfo().getId());
    }

    private String generateIdForNewArtifact() throws StorageException {
        HashSet existingKeys = new HashSet(this.delegate.getAllKeys());
        int newKey = existingKeys.size() + 1;
        while (existingKeys.contains(String.valueOf(newKey))) {
            ++newKey;
        }
        return String.valueOf(newKey);
    }

    public PairList<String, QUALITY_ARTIFACT> getAllQualityArtifacts() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void setQualityArtifact(String id, QUALITY_ARTIFACT qualityArtifact) throws StorageException {
        this.delegate.setValue(id, qualityArtifact);
    }
}

