/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.query.ReplacePreprocessorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class GroupExpansionPreprocessor
extends ReplacePreprocessorBase {
    private static final String GROUP_KEYWORD = "membersof";
    private final GlobalStorageSystem globalStorageSystem;
    private UserIndex userIndex;
    private UserGroupIndex groupIndex;
    private final boolean validationOnly;

    public GroupExpansionPreprocessor(GlobalStorageSystem globalStorageSystem, boolean validationOnly) {
        this.globalStorageSystem = globalStorageSystem;
        this.validationOnly = validationOnly;
    }

    private UserGroup resolveGroup(String groupName, QueryToken token) throws QueryParsingException, StorageException {
        UserGroup group;
        if (this.groupIndex == null) {
            this.groupIndex = (UserGroupIndex)this.globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
        }
        if ((group = this.groupIndex.getUserGroup(groupName)) == null) {
            throw new QueryParsingException("Group " + groupName + " does not exist!", new QueryToken[]{token});
        }
        return group;
    }

    private Set<String> resolveUsers(UserGroup group) throws StorageException {
        if (this.validationOnly) {
            return Collections.emptySet();
        }
        if (this.userIndex == null) {
            this.userIndex = (UserIndex)this.globalStorageSystem.openGlobalIndex(UserIndex.class);
        }
        ArrayList usernames = new ArrayList(group.getUserNames());
        HashSet<String> result = new HashSet<String>(usernames);
        for (User user : this.userIndex.getUsers(usernames)) {
            if (user == null) continue;
            result.add(user.getEmailAddress());
            result.addAll((Collection<String>)user.getAliases());
            result.add(user.getFullName());
        }
        return result;
    }

    private static void insertUsernames(Collection<String> userNames, int tokenPosition, List<QueryToken> tokens) {
        tokens.add(new QueryToken(EQueryTokenType.BRACKET_OPEN, "[", (long)tokenPosition));
        boolean first = true;
        for (String userName : userNames) {
            if (!first) {
                tokens.add(new QueryToken(EQueryTokenType.COMMA, ",", (long)tokenPosition));
            }
            first = false;
            tokens.add(new QueryToken(EQueryTokenType.LITERAL, userName, (long)tokenPosition));
        }
        tokens.add(new QueryToken(EQueryTokenType.BRACKET_CLOSE, "]", (long)tokenPosition));
    }

    @Override
    protected String getKeyword() {
        return GROUP_KEYWORD;
    }

    @Override
    protected int insertReplacement(int index, List<QueryToken> tokens, List<QueryToken> result, Set<String> encounteredValues) throws StorageException, QueryParsingException {
        String groupName = GroupExpansionPreprocessor.extractParameterName(tokens, index + 1, this.getKeyword());
        UserGroup group = this.resolveGroup(groupName, tokens.get(index));
        TreeSet<String> userNames = new TreeSet<String>(this.resolveUsers(group));
        GroupExpansionPreprocessor.insertUsernames(userNames, tokens.get(index).getPosition(), result);
        return 3;
    }
}

