/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import com.teamscale.index.report.coverage.CoverageReportParserInvokerBase;
import com.teamscale.index.report.parser.IAbapScovHandlingParser;
import com.teamscale.index.report.parser.IUsageDataProvider;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestGapLineCoverageUtils;
import com.teamscale.index.testgap.abap.AbapScovMethodMappingIndex;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class SapCoverageReportParser
extends CoverageReportParserInvokerBase
implements IAbapScovHandlingParser,
IUsageDataProvider {
    private static final int COVERAGE_FILE_COUNT_SEPARATOR_LENGTH = "->".length();
    private AbapScovMethodMappingIndex mappingIndex;
    private FeatureCountsMap featureCounts;
    private List<String> featuresWithPositiveCounts;
    private List<Set<MethodLocation>> methodSets;
    private Set<MethodLocation> methodLocations;

    @Override
    public void setAbapScovMethodMappingIndex(AbapScovMethodMappingIndex index) {
        this.mappingIndex = index;
    }

    @Override
    protected void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        CCSMAssert.isNotNull((Object)this.mappingIndex, (String)"Mapping index not properly initialized!");
        try {
            this.featureCounts = SapCoverageReportParser.parseFeaturesToCountsMap(report);
            this.convertFeaturesToCoverage(retriever, this.featureCounts);
        }
        catch (StorageException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private void convertFeaturesToCoverage(CoverageInfoRetriever retriever, FeatureCountsMap featureCountsMap) throws StorageException {
        this.featuresWithPositiveCounts = CollectionUtils.filter(featureCountsMap.featuresToCounts.keySet(), feature -> featureCountsMap.featuresToCounts.get(feature) > 0L);
        this.methodSets = this.mappingIndex.getMappings(this.featuresWithPositiveCounts);
        this.methodLocations = CollectionUtils.unionSetAll(this.methodSets);
        Map<String, List<MethodLocation>> locationsByUniformPath = this.methodLocations.stream().collect(Collectors.groupingBy(methodLocation -> methodLocation.getUniformPath().toStringAsMigrationFrontier()));
        ArrayList<String> uniformPaths = new ArrayList<String>(locationsByUniformPath.keySet());
        List<TokenElementLineInfo> tokenElementLineInfos = this.tokenElementLineInfoIndex.getLineInfos(uniformPaths);
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = (String)uniformPaths.get(i);
            TokenElementLineInfo tokenElementLineInfo = tokenElementLineInfos.get(i);
            if (tokenElementLineInfo == null) {
                LOGGER.warn("Could not obtain content for '" + uniformPath + "'. Coverage discarded for this file.");
                continue;
            }
            LineCoverageInfo lineCoverageInfo = retriever.getOrCreateLineCoverageInfo(uniformPath);
            lineCoverageInfo.setMethodAccurate(true);
            TestGapLineCoverageUtils.appendToLineCoverageInfo(tokenElementLineInfo.getRawLineOffsetConverter(), locationsByUniformPath.get(uniformPath), lineCoverageInfo);
        }
    }

    private static FeatureCountsMap parseFeaturesToCountsMap(String report) throws ReportParserException {
        FeatureCountsMap result = new FeatureCountsMap();
        boolean isOptionParsing = true;
        for (String line : StringUtils.splitLinesAsList((String)report)) {
            if (StringUtils.isEmpty((String)line)) continue;
            if (isOptionParsing && line.startsWith("#")) {
                SapCoverageReportParser.parseOption(line, result);
                continue;
            }
            isOptionParsing = false;
            String countPart = StringUtils.getLastPart((String)line, (String)"->");
            String feature = line.substring(0, line.length() - countPart.length() - COVERAGE_FILE_COUNT_SEPARATOR_LENGTH);
            try {
                result.featuresToCounts.put(feature, Long.parseLong(countPart));
            }
            catch (NumberFormatException e) {
                throw new ReportParserException("Invalid report format: " + countPart + " is not a valid count!", (Throwable)e);
            }
        }
        return result;
    }

    private static void parseOption(String optionLine, FeatureCountsMap result) throws ReportParserException {
        if (!optionLine.startsWith("#all-delta=")) {
            throw new ReportParserException("Unsupported option line in coverage report: " + optionLine);
        }
        result.isAllDelta = Boolean.parseBoolean(StringUtils.stripPrefix((String)optionLine, (String)"#all-delta="));
    }

    @Override
    public PairList<MethodLocation, Long> extractUsageDataDelta(@Nullable String previousReportContent) throws ReportParserException {
        Map<String, Long> featureDeltas = this.determineFeatureDeltas(previousReportContent);
        Map<MethodLocation, Long> methodDeltas = SapCoverageReportParser.mapFeatureDeltasToMethodDeltas(featureDeltas, this.featuresWithPositiveCounts, this.methodSets);
        PairList locationAndDeltas = new PairList();
        for (MethodLocation newId : this.methodLocations) {
            locationAndDeltas.add((Object)newId, (Object)methodDeltas.get(newId));
        }
        return locationAndDeltas;
    }

    static Map<MethodLocation, Long> mapFeatureDeltasToMethodDeltas(Map<String, Long> featureDeltas, List<String> features, List<Set<MethodLocation>> methodSets) {
        ArrayList<String> unmappedFeatures = new ArrayList<String>();
        HashMap<MethodLocation, Long> methodDeltas = new HashMap<MethodLocation, Long>();
        for (int i = 0; i < features.size(); ++i) {
            long featureDelta = featureDeltas.get(features.get(i));
            Set<MethodLocation> methodLocations = methodSets.get(i);
            if (methodLocations.isEmpty()) {
                unmappedFeatures.add(features.get(i));
            }
            for (MethodLocation location : methodLocations) {
                methodDeltas.merge(location, featureDelta, Long::sum);
            }
        }
        if (!unmappedFeatures.isEmpty()) {
            LOGGER.warn("Could not map the following SCOV IDs to methods in the code: " + String.valueOf(unmappedFeatures));
        }
        return methodDeltas;
    }

    private Map<String, Long> determineFeatureDeltas(@Nullable String previousReportContent) throws ReportParserException {
        if (this.featureCounts.isAllDelta || previousReportContent == null) {
            return this.featureCounts.featuresToCounts;
        }
        Map<String, Long> previousFeatureCounts = SapCoverageReportParser.parseFeaturesToCountsMap((String)previousReportContent).featuresToCounts;
        HashMap<String, Long> deltaCounts = new HashMap<String, Long>();
        this.featureCounts.featuresToCounts.forEach((feature, uploadedCount) -> {
            long previousCount = previousFeatureCounts.getOrDefault(feature, 0L);
            long delta = uploadedCount - previousCount;
            if (delta < 0L) {
                delta = uploadedCount;
            }
            deltaCounts.put((String)feature, delta);
        });
        return deltaCounts;
    }

    private static class FeatureCountsMap {
        private boolean isAllDelta = false;
        private final Map<String, Long> featuresToCounts = new HashMap<String, Long>();

        private FeatureCountsMap() {
        }
    }
}

