/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.commons.lang.ToStringHelpers;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MergeBaseInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="mergeBase")
    private final CommitDescriptor mergeBase;
    @JsonProperty(value="branchPoint")
    private final CommitDescriptor branchPoint;
    @JsonProperty(value="oldestNonMergeAncestorOfSource")
    private final ParentedCommitDescriptor oldestNonMergeAncestorOfSource;
    @JsonProperty(value="ancestorsOfSource")
    private final List<ParentedCommitDescriptor> ancestorsOfSource;

    @JsonCreator
    public MergeBaseInfo(@JsonProperty(value="mergeBase") CommitDescriptor mergeBase, @JsonProperty(value="branchPoint") CommitDescriptor branchPoint, @JsonProperty(value="oldestNonMergeAncestorOfSource") ParentedCommitDescriptor oldestNonMergeAncestorOfSource, @JsonProperty(value="ancestorsOfSource") Collection<ParentedCommitDescriptor> ancestorsOfSource) {
        this.mergeBase = (CommitDescriptor)Preconditions.checkNotNull((Object)mergeBase);
        this.branchPoint = branchPoint;
        this.oldestNonMergeAncestorOfSource = oldestNonMergeAncestorOfSource;
        this.ancestorsOfSource = ancestorsOfSource.stream().sorted(CommitDescriptor.BY_TIMESTAMP_COMPARATOR).collect(Collectors.toList());
    }

    public CommitDescriptor getMergeBase() {
        return this.mergeBase;
    }

    public Optional<CommitDescriptor> getBranchPoint() {
        return Optional.ofNullable(this.branchPoint);
    }

    public List<ParentedCommitDescriptor> getAncestorsOfSource() {
        return Collections.unmodifiableList(this.ancestorsOfSource);
    }

    public Optional<ParentedCommitDescriptor> getOldestNonMergeAncestorOfSource() {
        return Optional.ofNullable(this.oldestNonMergeAncestorOfSource);
    }

    public List<CommitDescriptor> getRelevantCommits() {
        HashSet<ParentedCommitDescriptor> ancestorSet = new HashSet<ParentedCommitDescriptor>(this.ancestorsOfSource);
        return this.ancestorsOfSource.stream().filter(commit -> MergeBaseInfo.isRelevantCommit(commit, ancestorSet)).collect(Collectors.toList());
    }

    private static boolean isRelevantCommit(ParentedCommitDescriptor commit, Set<CommitDescriptor> ancestorSet) {
        return !commit.isMergeCommit() || ancestorSet.containsAll((Collection<?>)commit.getParentCommits());
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

