/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.google.common.collect.Sets;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.dependencies.DependencyAnalysisFactory;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsSynchronizer;
import com.teamscale.index.metadata.abap.AbapFileMetadataReader;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.AcceptAllMergedRevisionsFilter;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.ContentPipelineRepositoryLogFileIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.ITokenElementInfoExtractor;
import com.teamscale.index.repository.LanguageMappingSupport;
import com.teamscale.index.repository.MergeAncestorExplorer;
import com.teamscale.index.repository.MergedRevisionsFilter;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.ReportMappingSupport;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeInfo;
import com.teamscale.index.repository.RepositoryChangeRetrieverUtils;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.RepositoryChangesProcessorBase;
import com.teamscale.index.repository.RepositoryContentUpdaterCodeScopeSupport;
import com.teamscale.index.repository.RepositoryContentUpdaterFilteringSupport;
import com.teamscale.index.repository.RepositoryContentUpdaterUtils;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryPathTransformationSupport;
import com.teamscale.index.repository.base.RepositoryContentCacheIndex;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.iec.StructuredTextElementInfoExtractorBachmann;
import com.teamscale.index.repository.iec.StructuredTextElementInfoExtractorPCWORX;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.CompileCommandReportContentIndex;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.GeneralReportContentIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.SapScovReportContentIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import com.teamscale.index.resource.element_details.ProjectModuleTokenElementDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.core.stream.IIteratorWithException;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.LanguageInfo;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class RepositoryContentUpdaterBase
extends RepositoryChangesProcessorBase {
    public static final String AUTHOR_TRANSFORMATION_PARAMETER = "author-transformation";
    public static final String ENCODING_PARAMETER = "encoding";
    public static final String PARTITION_PATTERN_PARAMETER = "partition-pattern";
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    private static final Logger LOGGER = LogManager.getLogger();
    private final PairList<UniformPath, byte[]> binaryElementValues = new PairList();
    private final PairList<UniformPath, ReportContentIndexBase.ReportContent> reportContentValues = new PairList();
    private final List<BasicTokenElementInfo> tokenElementValues = new ArrayList<BasicTokenElementInfo>();
    private final PairList<UniformPath, CodeScopeName> codeScopeMappingValues = new PairList();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @StepParameter(value="branch-rename-pattern", optional=true)
    private final PairList<String, String> branchTransformation = new PairList();
    @VisibleForTesting
    protected IRepositoryConnection repositoryConnection;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BinaryElementIndex binaryElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private GeneralReportContentIndex generalReportContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CompileCommandReportContentIndex compileCommandReportContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SapScovReportContentIndex sapScovReportContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisReportArchiveIndex externalAnalysisReportArchiveIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeScopesMappingIndex codeScopesMappingIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<BasicTokenElementIndex> parentBasicTokenElementIndexes;
    @StepParameter(value="hidden-element-connector", optional=true)
    protected boolean hiddenElementConnector = false;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected ContentPipelineRepositoryLogFileIndex logFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectRepositoryChangeIndex projectChangeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogIndex globalLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected CommitDescriptorIndex commitDescriptorIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    @VisibleForTesting
    protected RepositoryContentCacheIndex contentCache;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectConnectorStatusIndex connectorStatusIndex;
    @StepParameter(value="encoding", optional=true)
    private String encoding = null;
    @StepParameter(value="partition-pattern", optional=true)
    private String partitionPattern = null;
    @StepParameter(value="connector-id")
    private String connectorId;
    @StepParameter(value="author-transformation", optional=true)
    private final PairList<String, String> authorTransformation = new PairList();
    private StringTransformation compiledAuthorTransformation;
    @StepParameterObject
    private final RepositoryContentUpdaterFilteringSupport filteringSupport = new RepositoryContentUpdaterFilteringSupport();
    @StepParameterObject
    private final LanguageMappingSupport languageMappingSupport = new LanguageMappingSupport();
    @StepParameterObject
    protected final ReportMappingSupport reportMappingSupport = new ReportMappingSupport();
    @StepParameterObject
    @VisibleForTesting
    protected final RepositoryPathTransformationSupport pathTransformationSupport = new RepositoryPathTransformationSupport(() -> this.repositoryConnection.getConnectionIdentifier());
    @StepParameterObject
    private final RepositoryContentUpdaterCodeScopeSupport codeScopeSupport = new RepositoryContentUpdaterCodeScopeSupport();
    private final List<ITokenElementInfoExtractor> tokenElementInfoExtractors = Arrays.asList(new StructuredTextElementInfoExtractorPCWORX(), new StructuredTextElementInfoExtractorBachmann());
    private boolean hasAbapLanguagesWithMetaDataSupport = false;
    private final Set<RepositoryChangeEntry> hiddenEntries = new HashSet<RepositoryChangeEntry>();
    private final Set<RepositoryChangeEntry> tooLargeEntries = new HashSet<RepositoryChangeEntry>();

    @Override
    protected void processChangedEntries(List<RepositoryChangeEntry> entries, List<RepositoryChangeEntry> allEntries, boolean firstRunOfDelta) throws RepositoryException, ConQATException {
        LOGGER.debug("Processing change entries. Entries: \n{}", new Supplier[]{() -> String.join((CharSequence)"\n", entries.stream().map(RepositoryChangeEntry::toString).toList())});
        this.hasAbapLanguagesWithMetaDataSupport = this.calculateHasAbapLanguagesWithMetaDataSupport();
        BranchRenamingCommitTreeFacade branchRenamingFacade = new BranchRenamingCommitTreeFacade(StringTransformation.fromStringPairs(this.branchTransformation), this.commitTreeIndex);
        ICommitTreeNode schedulingCommitCommitTreeNode = this.getCurrentCommitTreeNode(branchRenamingFacade);
        try {
            this.repositoryConnection = this.createRepositoryConnection();
            if (firstRunOfDelta) {
                this.extendEntriesFromOtherParentNodes(entries, allEntries, branchRenamingFacade, schedulingCommitCommitTreeNode);
                this.extendEntriesIfRequired(entries, allEntries, schedulingCommitCommitTreeNode);
                allEntries = this.getPatchedEntries(allEntries, schedulingCommitCommitTreeNode);
                this.storeGlobalLogEntry(allEntries, schedulingCommitCommitTreeNode, branchRenamingFacade);
                this.updateBranchInformation();
            }
            this.handleEntries(this.getPatchedEntries(entries, schedulingCommitCommitTreeNode), branchRenamingFacade);
        }
        catch (RepositoryException e) {
            this.storeConnectorDownStatus("Error fetching content: " + e.getMessage());
            throw e;
        }
        finally {
            this.closeConnectionSafely();
        }
    }

    private void handleEntries(List<RepositoryChangeEntry> entries, BranchRenamingCommitTreeFacade branchRenamingFacade) throws ConQATException, RepositoryException {
        if (entries.isEmpty()) {
            return;
        }
        this.loadAndProcessRepositoryContent(entries, branchRenamingFacade);
        this.persistContent();
        this.removeDeletedElements(entries);
        if (!this.hiddenElementConnector) {
            this.calculateHiddenEntriesFromDeletions(entries);
            entries.removeAll(this.hiddenEntries);
            this.updateRepositoryLogFileIndex(entries);
            this.updateProjectRepositoryChangeIndex(entries);
        }
    }

    protected void extendEntriesIfRequired(List<RepositoryChangeEntry> entries, List<RepositoryChangeEntry> allEntries, ICommitTreeNode commitTreeNode) throws ConQATException {
    }

    private boolean calculateHasAbapLanguagesWithMetaDataSupport() throws StorageException {
        ProjectConfiguration config = (ProjectConfiguration)this.projectMetaIndex.getValue(ProjectConfiguration.class);
        if (config == null) {
            return false;
        }
        return !Sets.intersection((Set)config.getConfiguredLanguages(), (Set)AbapFileMetadataReader.LANGUAGES_WITH_ABAP_METADATA_FILES).isEmpty();
    }

    protected void storeConnectorDownStatus(String error) throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(this.getConnectionIdentifier(), ProjectConnectorStatus.EConnectorStatus.ERROR, error);
    }

    private void updateBranchInformation() throws StorageException {
        if (!this.hiddenElementConnector) {
            this.projectChangeIndex.mergeCommitTree(this.commitTreeIndex.loadTree(), this.projectMetaIndex.getDefaultBranchName(), this.repositoryConnection.getConnectionIdentifier());
        }
    }

    private void closeConnectionSafely() {
        try {
            if (this.repositoryConnection != null) {
                this.repositoryConnection.close();
            }
        }
        catch (RepositoryException e) {
            LOGGER.error("Error while closing repository connection: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private ICommitTreeNode getCurrentCommitTreeNode(BranchRenamingCommitTreeFacade branchRenamingFacade) {
        return branchRenamingFacade.getNodeByBranchAndAdjustedTimestamp(branchRenamingFacade.unrenameBranch(this.getSchedulingCommit().getBranchName()), this.getSchedulingCommit().getTimestamp());
    }

    private void extendEntriesFromOtherParentNodes(List<RepositoryChangeEntry> entries, List<RepositoryChangeEntry> allEntries, BranchRenamingCommitTreeFacade branchRenamingFacade, ICommitTreeNode schedulingCommitCommitTreeNode) throws ConQATException {
        try {
            PairList<ICommitTreeNode, EChangeEntryOrigin> requiredNodesAndChangeOrigin = RepositoryContentUpdaterUtils.determineRequiredAdditionalNodesToBeScanned((ParentedCommitDescriptor)this.getSchedulingCommit(), schedulingCommitCommitTreeNode, branchRenamingFacade, this.commitDescriptorIndex, true, new MergeAncestorExplorer(this.getMergedRevisionsFilter(branchRenamingFacade), this.getMergedRevisionsFilter(branchRenamingFacade)), LOGGER);
            List additionalEntries = this.determineAdditionalRepositoryLogEntries(allEntries, requiredNodesAndChangeOrigin, branchRenamingFacade, schedulingCommitCommitTreeNode);
            additionalEntries = CollectionUtils.filter(additionalEntries, entry -> this.repositoryConnection.fileExistsAfterForkMerge(entry.getRepositoryPath(), schedulingCommitCommitTreeNode.getRevision(), entry.getChangeEntryOrigin(), entry.getChangeType()));
            entries.addAll(additionalEntries);
            allEntries.addAll(additionalEntries);
        }
        catch (RepositoryException e) {
            throw new ConQATException((Throwable)e);
        }
        catch (CommitResolutionException e) {
            LOGGER.error("Failed to extend entries from other parent nodes.", (Throwable)e);
        }
    }

    protected MergedRevisionsFilter getMergedRevisionsFilter(BranchRenamingCommitTreeFacade branchRenamingFacade) {
        return new AcceptAllMergedRevisionsFilter(branchRenamingFacade);
    }

    private List<RepositoryChangeEntry> getPatchedEntries(List<RepositoryChangeEntry> entries, ICommitTreeNode commitTreeNode) throws ConQATException {
        List parentNodes;
        LOGGER.debug("Checking if entries should be patched for revision {}", (Object)commitTreeNode.getRevision());
        CommitDescriptor firstParent = ((ParentedCommitDescriptor)this.getSchedulingCommit()).getFirstParentCommit();
        if (firstParent != null && ((parentNodes = commitTreeNode.getNonEmptyParents()).isEmpty() || !RepositoryContentUpdaterBase.isSameCommit((ICommitTreeNode)parentNodes.getFirst(), firstParent))) {
            return this.getPatchedChangeTypes(entries, this.basicTokenElementIndex);
        }
        return entries;
    }

    private static boolean isSameCommit(ICommitTreeNode commitTreeNode, CommitDescriptor commitDescriptor) {
        return commitTreeNode.getAdjustedTimestamp().orElseThrow() == commitDescriptor.getTimestamp() && commitTreeNode.getRevision().getBranchName().equals(commitDescriptor.getBranchName());
    }

    private List<RepositoryChangeEntry> determineAdditionalRepositoryLogEntries(List<RepositoryChangeEntry> entries, PairList<ICommitTreeNode, EChangeEntryOrigin> requiredNodes, BranchRenamingCommitTreeFacade branchRenamingFacade, ICommitTreeNode schedulingCommitCommitTreeNode) throws RepositoryException, StorageException {
        HashSet<UniformPath> seenPaths = new HashSet<UniformPath>(CollectionUtils.map(entries, RepositoryChangeEntry::getRepositoryPath));
        ArrayList<RepositoryChangeEntry> result = new ArrayList<RepositoryChangeEntry>();
        for (Pair requiredNodeEntry : requiredNodes) {
            this.determineAdditionalRepositoryLogEntries((Pair<ICommitTreeNode, EChangeEntryOrigin>)requiredNodeEntry, result, seenPaths, branchRenamingFacade, schedulingCommitCommitTreeNode, (EChangeEntryOrigin)((Object)requiredNodeEntry.getSecond()));
        }
        return result;
    }

    private void determineAdditionalRepositoryLogEntries(Pair<ICommitTreeNode, EChangeEntryOrigin> requiredNode, List<RepositoryChangeEntry> result, Set<UniformPath> seenPaths, BranchRenamingCommitTreeFacade branchRenamingFacade, ICommitTreeNode schedulingCommitCommitTreeNode, EChangeEntryOrigin changeEntryOrigin) throws RepositoryException, StorageException {
        List<? extends ICommitTreeNode> nonEmptyParents = RepositoryChangeRetrieverUtils.determineNonEmptyParentsIncludingForkInformation((ICommitTreeNode)requiredNode.getFirst(), this.repositoryConnection, this.commitDescriptorIndex, branchRenamingFacade);
        if (nonEmptyParents.isEmpty()) {
            Set paths = UniformPathCompatibilityUtil.convertSet(this.repositoryConnection.crawl(((ICommitTreeNode)requiredNode.getFirst()).getRevision()));
            paths.stream().filter(seenPaths::add).forEach(path -> this.addChangeEntryToResult((UniformPath)path, schedulingCommitCommitTreeNode.getRevision(), (EChangeEntryOrigin)((Object)((Object)requiredNode.getSecond())), (ICommitTreeNode)requiredNode.getFirst(), result));
            return;
        }
        RepositoryChangeSet changeSet = RepositoryChangeRetrieverUtils.determineChangeSet((ICommitTreeNode)requiredNode.getFirst(), nonEmptyParents.getFirst(), branchRenamingFacade, this.repositoryConnection);
        if (changeSet != null) {
            List<UniformPath> paths = changeSet.getChangePaths().stream().map(UniformPathCompatibilityUtil::convert).filter(path -> RepositoryContentUpdaterBase.addToSeenPaths(path, seenPaths, changeSet, requiredNode)).toList();
            for (UniformPath path2 : paths) {
                this.addChangeEntry(result, schedulingCommitCommitTreeNode.getRevision().getRevision(), changeSet, path2, changeEntryOrigin);
            }
        }
    }

    private void addChangeEntryToResult(UniformPath path, CommitTreeRevision revision, EChangeEntryOrigin changeOrigin, ICommitTreeNode commitTreeNode, List<RepositoryChangeEntry> result) {
        RepositoryChangeEntry changeEntry = new RepositoryChangeEntry(path, revision.getRevision(), ERepositoryChangeType.ADD, this.getSchedulingCommit(), changeOrigin);
        LOGGER.debug("Adding additional entry {} from node {}", (Object)changeEntry, (Object)commitTreeNode);
        result.add(changeEntry);
    }

    private static boolean addToSeenPaths(UniformPath path, Set<UniformPath> seenPaths, RepositoryChangeSet changeSet, Pair<ICommitTreeNode, EChangeEntryOrigin> requiredNode) {
        boolean wasAdded = seenPaths.add(path);
        if (wasAdded) {
            LOGGER.debug("Adding additional repository log entry (type {}) for path {} from revision {}.", (Object)changeSet.getChangeInfo(path.getPathSegmentsString()), (Object)path, (Object)((ICommitTreeNode)requiredNode.getFirst()).getRevision());
        }
        return wasAdded;
    }

    private void addChangeEntry(List<RepositoryChangeEntry> result, String revision, RepositoryChangeSet changeSet, UniformPath path, EChangeEntryOrigin changeEntryOrigin) {
        RepositoryChangeInfo changeInfo = changeSet.getChangeInfo(path.toStringAsMigrationFrontier());
        result.add(new RepositoryChangeEntry(path, revision, changeInfo.getChangeType(), this.getSchedulingCommit(), changeInfo.getOriginPath(), changeInfo.getOriginCommit(), changeEntryOrigin));
    }

    List<RepositoryChangeEntry> getPatchedChangeTypes(List<RepositoryChangeEntry> repositoryChangeEntries, BasicTokenElementIndex tokenElementIndex) throws ConQATException {
        LOGGER.trace("Patching changes types for:\n{}", (Object)String.join((CharSequence)"\n", repositoryChangeEntries.stream().map(element -> element == null ? "null" : element.toString()).toList()));
        List uniformPaths = CollectionUtils.mapWithException(repositoryChangeEntries, this.pathTransformationSupport::getUniformPath);
        List<BasicTokenElementInfo> tokenElements = tokenElementIndex.getTokenElementsFor(uniformPaths);
        LOGGER.trace("Uniform paths -> token elements:\n{}", PairList.zip((List)uniformPaths, tokenElements).stream().map(pair -> String.valueOf(pair.getFirst()) + " -> " + String.valueOf(pair.getSecond())));
        ArrayList<RepositoryChangeEntry> filteredRepositoryChangeEntries = new ArrayList<RepositoryChangeEntry>(repositoryChangeEntries.size());
        for (int i = 0; i < repositoryChangeEntries.size(); ++i) {
            RepositoryChangeEntry repositoryChangeEntry = repositoryChangeEntries.get(i);
            if (this.reportMappingSupport.isReportPath(repositoryChangeEntry)) {
                filteredRepositoryChangeEntries.add(repositoryChangeEntry);
                continue;
            }
            boolean isElementPresent = tokenElements.get(i) != null;
            ERepositoryChangeType patchedChangeType = RepositoryContentUpdaterBase.patchChangeType(repositoryChangeEntry, isElementPresent);
            if (patchedChangeType == null) continue;
            repositoryChangeEntry.setChangeType(patchedChangeType);
            filteredRepositoryChangeEntries.add(repositoryChangeEntry);
        }
        LOGGER.trace("Entries after patching:\n{}", new Supplier[]{() -> String.join((CharSequence)"\n", filteredRepositoryChangeEntries.stream().map(RepositoryChangeEntry::toString).toList())});
        return filteredRepositoryChangeEntries;
    }

    private static ERepositoryChangeType patchChangeType(RepositoryChangeInfo repositoryChangeInfo, boolean isElementPresent) {
        ERepositoryChangeType changeType = repositoryChangeInfo.getChangeType();
        if (!isElementPresent && changeType == ERepositoryChangeType.DELETE) {
            return null;
        }
        if (!isElementPresent && changeType == ERepositoryChangeType.EDIT) {
            return ERepositoryChangeType.ADD;
        }
        if (isElementPresent && changeType == ERepositoryChangeType.ADD) {
            return ERepositoryChangeType.EDIT;
        }
        return changeType;
    }

    private void storeGlobalLogEntry(List<RepositoryChangeEntry> entries, ICommitTreeNode commitTreeNode, BranchRenamingCommitTreeFacade branchRenamingFacade) throws RepositoryException, ConQATException {
        int numAdded = 0;
        int numChanged = 0;
        int numDeleted = 0;
        EnumSet<ECommitType> commitTypes = EnumSet.noneOf(ECommitType.class);
        if (entries.isEmpty()) {
            commitTypes.add(ECommitType.CODE_COMMIT);
        } else {
            block5: for (RepositoryChangeEntry entry : entries) {
                if (this.reportMappingSupport.isReportPath(entry)) {
                    commitTypes.add(ECommitType.EXTERNAL_ANALYSIS);
                    continue;
                }
                commitTypes.add(RepositoryContentUpdaterBase.getCommitType(entry.getRepositoryPath()));
                switch (entry.getChangeType()) {
                    case ADD: {
                        ++numAdded;
                        continue block5;
                    }
                    case EDIT: {
                        ++numChanged;
                        continue block5;
                    }
                    case DELETE: {
                        ++numDeleted;
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown repository change type: " + String.valueOf((Object)entry.getChangeType())));
            }
        }
        this.addGlobalLogEntry(commitTreeNode, numAdded, numChanged, numDeleted, commitTypes, branchRenamingFacade);
    }

    private static ECommitType getCommitType(UniformPath uniformPath) {
        if (UniformPathUtils.isArchitectureFile((UniformPath)uniformPath)) {
            return ECommitType.ARCHITECTURE_CHANGE;
        }
        return ECommitType.CODE_COMMIT;
    }

    private void addGlobalLogEntry(ICommitTreeNode commitTreeNode, int numAdded, int numChanged, int numDeleted, EnumSet<ECommitType> commitTypes, BranchRenamingCommitTreeFacade branchRenamingFacade) throws RepositoryException, ConQATException {
        if (this.compiledAuthorTransformation == null) {
            this.compiledAuthorTransformation = StringTransformation.fromStringPairs(this.authorTransformation);
        }
        Object message = "Teamscale import";
        if (!StringUtils.isEmpty((String)this.repositoryConnection.getConnectionIdentifier())) {
            message = (String)message + " (" + this.repositoryConnection.getConnectionIdentifier() + ")";
        }
        String author = "Teamscale import";
        String mail = null;
        List<? extends ICommitTreeNode> nonEmptyParents = RepositoryChangeRetrieverUtils.determineNonEmptyParentsIncludingForkInformation(commitTreeNode, this.repositoryConnection, this.commitDescriptorIndex, branchRenamingFacade);
        if (!nonEmptyParents.isEmpty()) {
            Pair<String, String> authorAndCommitMessage = this.repositoryConnection.getAuthorAndCommitMessage(commitTreeNode.getRevision(), CollectionUtils.map(nonEmptyParents, ICommitTreeNode::getRevision));
            mail = this.repositoryConnection.getEmail(commitTreeNode.getRevision(), CollectionUtils.map(nonEmptyParents, ICommitTreeNode::getRevision));
            message = (String)authorAndCommitMessage.getSecond();
            author = this.compiledAuthorTransformation.apply((String)authorAndCommitMessage.getFirst());
        }
        if (this.hiddenElementConnector) {
            message = RepositoryLogEntry.getSourceLibraryChangeCommitMessage((String)message);
            commitTypes = EnumSet.copyOf(commitTypes);
            commitTypes.add(ECommitType.SOURCE_LIBRARY_CHANGE);
        }
        RepositoryLogEntry repositoryLogEntry = new RepositoryLogEntry(commitTreeNode.getRevision().getRevision(), this.getSchedulingCommit(), (String)message, author, mail, numAdded, numChanged, numDeleted, this.repositoryConnection.getConnectionIdentifier(), commitTypes, null);
        if (this.repositoryConnection.isCodeRepository()) {
            this.globalLogIndex.setPrimaryLogEntry(repositoryLogEntry);
        } else {
            this.globalLogIndex.addSecondaryLogEntry(repositoryLogEntry);
        }
    }

    protected abstract IRepositoryConnection createRepositoryConnection() throws RepositoryException;

    private void loadAndProcessRepositoryContent(List<RepositoryChangeEntry> entries, BranchRenamingCommitTreeFacade branchRenamingFacade) throws ConQATException, RepositoryException {
        List<RepositoryChangeEntry> modifiedEntries = RepositoryContentUpdaterUtils.filterModifiedEntries(entries, this.repositoryConnection);
        LOGGER.debug("Processing filtered entries: \n{}", new Supplier[]{() -> String.join((CharSequence)"\n", modifiedEntries.stream().map(RepositoryChangeEntry::toString).toList())});
        if (modifiedEntries.isEmpty()) {
            return;
        }
        Charset encoding = this.determineEncoding();
        Pattern partitionPattern = this.determinePartitionPattern();
        LOGGER.debug("Loading and processing contents for revision '{}' and paths:\n{}", new Supplier[]{() -> RepositoryContentUpdaterUtils.createCommitTreeRevision((RepositoryChangeEntry)entries.getFirst()), () -> String.join((CharSequence)"\n", entries.stream().map(RepositoryChangeEntry::toString).toList())});
        List modifiedEntryPaths = CollectionUtils.map(modifiedEntries, RepositoryChangeEntry::getRepositoryPath);
        CCSMAssert.isTrue((modifiedEntries.size() == modifiedEntryPaths.size() ? 1 : 0) != 0, (String)"`Filtered entries` and `paths` must have same size.");
        IStreamWithException<byte[], RepositoryException> modifiedPathContents = this.getContentForPaths(modifiedEntryPaths, RepositoryContentUpdaterBase.getUnrenamedRevision(entries, branchRenamingFacade));
        try (IIteratorWithException zippedIterator = IStreamWithException.wrap(modifiedEntries.stream()).withException(RepositoryException.class).zip(modifiedPathContents).toIterator();){
            while (zippedIterator.hasNext()) {
                Pair entryAndContent = (Pair)zippedIterator.next();
                RepositoryChangeEntry changeEntry = (RepositoryChangeEntry)entryAndContent.getFirst();
                byte[] content = (byte[])entryAndContent.getSecond();
                if (content == null) {
                    LOGGER.warn("Skipping change entry due to missing file content: {}", (Object)changeEntry);
                    continue;
                }
                this.loadAndProcessRepositoryContent(changeEntry, content, encoding, partitionPattern);
            }
            if (!this.tooLargeEntries.isEmpty()) {
                entries.removeAll(this.tooLargeEntries);
                this.patchGlobalRepositoryLogEntryForLargeEntries();
            }
        }
    }

    private void patchGlobalRepositoryLogEntryForLargeEntries() throws StorageException {
        RepositoryLogEntryAggregate aggregateEntry = (RepositoryLogEntryAggregate)this.globalLogIndex.getEntry(this.getSchedulingCommit());
        if (aggregateEntry == null) {
            LOGGER.warn("Could not update number of changed files. Number of changed files for the current commit might be incorrect.");
            return;
        }
        RepositoryLogEntry logEntry = Objects.requireNonNull(aggregateEntry).getPrimaryEntry();
        int numAdded = logEntry.getNumAddedFiles();
        int numChanged = logEntry.getNumChangedFiles();
        int numDeleted = logEntry.getNumDeletedFiles();
        block5: for (RepositoryChangeEntry changeEntry : this.tooLargeEntries) {
            switch (changeEntry.changeType) {
                case ADD: {
                    --numAdded;
                    continue block5;
                }
                case EDIT: {
                    --numChanged;
                    continue block5;
                }
                case DELETE: {
                    --numDeleted;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)changeEntry.changeType));
        }
        RepositoryLogEntryAggregate newAggregate = new RepositoryLogEntryAggregate(new RepositoryLogEntry(logEntry.getRevision(), logEntry.getCommit(), logEntry.getMessage(), logEntry.getAuthor(), logEntry.getEmail(), numAdded, numChanged, numDeleted, logEntry.getRepositoryIdentifier(), logEntry.getCommitTypes(), logEntry.getUploadTimestamp()));
        for (RepositoryLogEntry secondaryEntry : aggregateEntry.getSecondaryLogEntries()) {
            newAggregate.addSecondaryLogEntry(secondaryEntry);
        }
        this.globalLogIndex.setEntry(newAggregate);
    }

    private static @NonNull CommitTreeRevision getUnrenamedRevision(List<RepositoryChangeEntry> entries, BranchRenamingCommitTreeFacade branchRenamingFacade) {
        CommitTreeRevision revision = RepositoryContentUpdaterUtils.createCommitTreeRevision(entries.getFirst());
        CommitTreeRevision unrenamedRevision = branchRenamingFacade.unrenameBranch(revision);
        if (!unrenamedRevision.equals((Object)revision)) {
            LOGGER.debug("Un-renamed revision {} to {}", (Object)revision, (Object)unrenamedRevision);
        }
        return unrenamedRevision;
    }

    private void loadAndProcessRepositoryContent(RepositoryChangeEntry changeEntry, byte[] content, Charset encoding, Pattern partitionPattern) throws ConQATException {
        UniformPath uniformPath = this.pathTransformationSupport.recordPathTransformation(changeEntry);
        Optional<EReportFormat> reportFormat = this.reportMappingSupport.determineReportFormat(changeEntry);
        if (reportFormat.isPresent()) {
            this.reportContentValues.add((Object)uniformPath, (Object)new ReportContentIndexBase.ReportContent(reportFormat.get(), this.getSchedulingCommit().getTimestamp(), content, encoding, RepositoryContentUpdaterBase.determinePartition(uniformPath, partitionPattern), this.connectorId));
        } else {
            String fileContent = StringUtils.bytesToString((byte[])content, (Charset)encoding);
            LanguageInfo languageInfo = this.languageMappingSupport.determineLanguageInfo(uniformPath.toStringAsMigrationFrontier(), fileContent);
            boolean hidden = false;
            if (languageInfo.getLanguage() == ELanguage.SIMULINK) {
                hidden = this.insertSimulinkFile(uniformPath, content, languageInfo.getIsFileLanguageSetByUser());
            } else if (languageInfo.getLanguage() != null) {
                if (this.filteringSupport.isFileTooLarge(languageInfo.getLanguage(), content, changeEntry.getRepositoryPath().toStringAsMigrationFrontier())) {
                    this.tooLargeEntries.add(changeEntry);
                    return;
                }
                hidden = this.insertTokenElement(uniformPath, content, fileContent, languageInfo.getLanguage(), languageInfo.getIsFileLanguageSetByUser(), encoding);
            }
            if (hidden) {
                this.hiddenEntries.add(changeEntry);
            }
        }
    }

    private boolean insertSimulinkFile(UniformPath uniformPath, byte[] content, boolean isFileLanguageSetByUser) throws ConQATException {
        String placeholderText;
        if (SimulinkUtils.isSimulinkModelPath((String)uniformPath.toStringAsMigrationFrontier())) {
            placeholderText = "Model placeholder. Id: " + String.valueOf(UUID.randomUUID());
        } else if (SimulinkUtils.isSimulinkDataDictionary((String)uniformPath.toStringAsMigrationFrontier())) {
            placeholderText = "Data dictionary placeholder. Id: " + Long.toHexString(XXHashUtils.xxhash64((byte[])content));
        } else {
            LOGGER.error("Ignoring file {} because it is marked as language Simulink, but is not recognized as model or data dictionary.", (Object)uniformPath);
            return false;
        }
        this.binaryElementValues.add((Object)uniformPath, (Object)content);
        CodeScopeName codeScopeName = this.codeScopeSupport.determineCodeScope(uniformPath.toStringAsMigrationFrontier(), null);
        this.codeScopeMappingValues.add((Object)uniformPath, (Object)codeScopeName);
        boolean hiddenFile = this.hiddenElementConnector || this.mustHideFile(ELanguage.SIMULINK, uniformPath, content);
        List<TokenElementDetailBase> details = this.determineDetails(uniformPath, codeScopeName, hiddenFile);
        this.tokenElementValues.add(new BasicTokenElementInfo(uniformPath, ELanguage.SIMULINK, isFileLanguageSetByUser, placeholderText, Collections.emptyList(), details));
        return hiddenFile;
    }

    private Charset determineEncoding() throws RepositoryException {
        if (StringUtils.isEmpty((String)this.encoding)) {
            return FileSystemUtils.SYSTEM_CHARSET;
        }
        try {
            return CommonUtils.obtainEncoding((String)this.encoding);
        }
        catch (ConQATException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Pattern determinePartitionPattern() {
        if (StringUtils.isEmpty((String)this.partitionPattern)) {
            return null;
        }
        return Pattern.compile(this.partitionPattern);
    }

    private static String getTextContent(byte[] content, Charset encoding) throws AssertionError {
        return RepositoryContentUpdaterUtils.getTextContent(content, encoding);
    }

    @VisibleForTesting
    IStreamWithException<byte[], RepositoryException> getContentForPaths(List<UniformPath> paths, CommitTreeRevision revision) throws RepositoryException {
        try {
            if (!this.repositoryConnection.shouldCacheContent()) {
                return this.repositoryConnection.getContent(UniformPathCompatibilityUtil.asUniformPathStrings(paths), revision);
            }
            LOGGER.debug("Retrieving content for revision {} and paths:\n{}", new Supplier[]{() -> this.repositoryConnection.getRevisionIdentifier(revision), () -> paths.stream().map(UniformPath::toString).collect(Collectors.joining("\n"))});
            List<byte[]> contents = this.contentCache.getContent(this.repositoryConnection.getRevisionIdentifier(revision), UniformPathCompatibilityUtil.asUniformPathStrings(paths));
            List indicesWithUncachedPaths = CollectionUtils.getNullIndices(contents);
            ArrayList uncachedPaths = CollectionUtils.getIndices(paths, (List)indicesWithUncachedPaths);
            CollectionUtils.setValuesAtIndices(contents, (List)indicesWithUncachedPaths, this.retrieveAndCacheContent(uncachedPaths, revision));
            return IStreamWithException.wrap(contents.stream()).withException(RepositoryException.class);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private List<byte[]> retrieveAndCacheContent(List<UniformPath> nonCachedPaths, CommitTreeRevision revision) throws RepositoryException, StorageException {
        ArrayList<byte[]> contents = new ArrayList<byte[]>();
        if (nonCachedPaths.isEmpty()) {
            return contents;
        }
        LOGGER.debug("Uncached paths:\n{}", new Supplier[]{() -> nonCachedPaths.stream().map(UniformPath::toString).collect(Collectors.joining("\n"))});
        IStreamWithException<byte[], RepositoryException> resultsToCache = this.repositoryConnection.getContent(UniformPathCompatibilityUtil.asUniformPathStrings(nonCachedPaths), revision);
        PairList contentToCache = new PairList(nonCachedPaths.size());
        IStreamWithException.wrap(nonCachedPaths.stream()).withException(RepositoryException.class).zip(resultsToCache).forEach(toCache -> {
            byte @Nullable [] resultToCache = (byte[])toCache.getSecond();
            contents.add(resultToCache);
            contentToCache.add((Object)((UniformPath)toCache.getFirst()), (Object)resultToCache);
        });
        this.contentCache.cacheContent((PairList<UniformPath, byte[]>)contentToCache, this.repositoryConnection.getRevisionIdentifier(revision));
        return contents;
    }

    private static String determinePartition(UniformPath uniformPath, Pattern partitionPattern) {
        if (partitionPattern == null) {
            return null;
        }
        Matcher matcher = partitionPattern.matcher(uniformPath.toString());
        if (!matcher.find()) {
            LOGGER.warn("Could not extract the partition from {} using pattern {}", (Object)uniformPath, (Object)partitionPattern.pattern());
            return null;
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String group = matcher.group(i);
            if (group == null) continue;
            return group;
        }
        return matcher.group();
    }

    private boolean insertTokenElement(UniformPath uniformPath, byte[] content, String fileContent, ELanguage language, boolean isFileLanguageSetByUser, Charset encoding) throws ConQATException {
        ITokenElementInfoExtractor tokenElementInfoExtractor = null;
        for (ITokenElementInfoExtractor extractor : this.tokenElementInfoExtractors) {
            if (!extractor.canExtractFromSourceFile(language, content, uniformPath.toStringAsMigrationFrontier())) continue;
            tokenElementInfoExtractor = extractor;
            break;
        }
        if (tokenElementInfoExtractor != null) {
            BasicTokenElementInfo tokenElementInfo = tokenElementInfoExtractor.getElementInfo(language, content, uniformPath.toStringAsMigrationFrontier());
            CodeScopeName codeScopeName = this.codeScopeSupport.determineCodeScope(uniformPath.toStringAsMigrationFrontier(), fileContent);
            tokenElementInfo.addDetail((TokenElementDetailBase)RepositoryContentUpdaterBase.getCodeScopeDetail(codeScopeName));
            this.codeScopeMappingValues.add((Object)uniformPath, (Object)codeScopeName);
            this.tokenElementValues.add(tokenElementInfo);
            return false;
        }
        String textContent = RepositoryContentUpdaterBase.getTextContent(content, encoding);
        List<Deletion> deletions = this.determineDeletions(uniformPath, language, textContent);
        CodeScopeName codeScopeName = this.codeScopeSupport.determineCodeScope(uniformPath.toStringAsMigrationFrontier(), textContent);
        this.codeScopeMappingValues.add((Object)uniformPath, (Object)codeScopeName);
        boolean hiddenFile = this.hiddenElementConnector || this.mustHideFile(language, uniformPath, content);
        BasicTokenElementInfo tokenElementInfo = new BasicTokenElementInfo(uniformPath, language, isFileLanguageSetByUser, textContent, deletions, this.determineDetails(uniformPath, codeScopeName, hiddenFile));
        this.tokenElementValues.add(tokenElementInfo);
        return hiddenFile;
    }

    private List<Deletion> determineDeletions(UniformPath uniformPath, ELanguage language, String textContent) throws ConQATException {
        List deletions = this.filteringSupport.determineDeletions(uniformPath.toStringAsMigrationFrontier(), textContent, language);
        List<Deletion> additionalDeletions = this.determineAdditionalDeletions(uniformPath, language, textContent);
        if (additionalDeletions.isEmpty()) {
            return deletions;
        }
        deletions.addAll(additionalDeletions);
        deletions = Deletion.compactDeletions(deletions);
        RepositoryContentUpdaterBase.sanitizeDeletions(deletions, uniformPath, textContent);
        return deletions;
    }

    private static void sanitizeDeletions(List<Deletion> deletions, UniformPath uniformPath, String textContent) {
        for (int i = 0; i < deletions.size(); ++i) {
            Deletion deletion = deletions.get(i);
            if (deletion.getEndOffset() > textContent.length()) {
                LOGGER.error("Generated a deletion with end offset > text length for file {}. Truncating deletion to text size.", (Object)uniformPath);
                deletions.set(i, new Deletion(Math.max(deletion.getStartOffset(), textContent.length() - 1), textContent.length(), deletion.isGap()));
                continue;
            }
            if (deletion.getStartOffset() <= deletion.getEndOffset()) continue;
            LOGGER.error("Generated a deletion with start offset > end offset for file {}. Removing deletion.", (Object)uniformPath);
            deletions.remove(i);
            --i;
        }
    }

    protected List<Deletion> determineAdditionalDeletions(UniformPath uniformPath, ELanguage language, String textContent) {
        return Collections.emptyList();
    }

    private boolean mustHideFile(ELanguage language, UniformPath uniformPath, byte[] content) {
        return AbapThirdPartyPathsSynchronizer.isAbapThirdPartyPathsFile(language, uniformPath.toStringAsMigrationFrontier(), content) || this.isAbapMetadataFile(language, uniformPath);
    }

    private boolean isAbapMetadataFile(ELanguage language, UniformPath uniformPath) {
        return this.hasAbapLanguagesWithMetaDataSupport && language == ELanguage.LINE && AbapFileMetadataReader.isMetadataFile((String)uniformPath.toStringAsMigrationFrontier());
    }

    private List<TokenElementDetailBase> determineDetails(UniformPath uniformPath, CodeScopeName codeScopeName, boolean hiddenElementConnector) throws StorageException {
        ArrayList<TokenElementDetailBase> details = new ArrayList<TokenElementDetailBase>();
        if (hiddenElementConnector) {
            details.add(new HiddenTokenElementDetail());
        }
        if (DependencyAnalysisFactory.isProjectModule(uniformPath.toStringAsMigrationFrontier())) {
            details.add(new ProjectModuleTokenElementDetail());
        }
        if (this.repositoryConnection.isTestCode(uniformPath.toStringAsMigrationFrontier())) {
            details.add(new PartOfTestCodeDetail());
            this.filteringSupport.resourceTypeIndex.setTestCode(uniformPath.toStringAsMigrationFrontier());
        }
        details.add(RepositoryContentUpdaterBase.getCodeScopeDetail(codeScopeName));
        return details;
    }

    private void persistContent() throws StorageException {
        if (!this.binaryElementValues.isEmpty()) {
            this.binaryElementIndex.setContents(this.binaryElementValues);
        }
        this.splitAndPersistToIndividualReportContentIndexes();
        if (!this.reportContentValues.isEmpty()) {
            this.externalAnalysisReportArchiveIndex.storeReports(this.getSchedulingCommit(), this.reportContentValues.mapFirst(UniformPath::toStringAsMigrationFrontier));
        }
        if (!this.tokenElementValues.isEmpty()) {
            this.basicTokenElementIndex.setTokenElements(this.tokenElementValues);
            this.codeScopesMappingIndex.setMappings(this.codeScopeMappingValues);
        }
        this.pathTransformationSupport.persistRecordedPathTransformations();
    }

    private void splitAndPersistToIndividualReportContentIndexes() throws StorageException {
        PairList compileCommandReportContentValues = new PairList();
        PairList generalReportContentValues = new PairList();
        PairList sapScovReportContentValues = new PairList();
        block4: for (int i = 0; i < this.reportContentValues.size(); ++i) {
            UniformPath uniformPath = (UniformPath)this.reportContentValues.getFirst(i);
            ReportContentIndexBase.ReportContent content = (ReportContentIndexBase.ReportContent)this.reportContentValues.getSecond(i);
            switch (content.format) {
                case COMPILATION_DATABASE: {
                    compileCommandReportContentValues.add((Object)uniformPath, (Object)content);
                    continue block4;
                }
                case SAP_COVERAGE: {
                    sapScovReportContentValues.add((Object)uniformPath, (Object)content);
                }
                default: {
                    generalReportContentValues.add((Object)uniformPath, (Object)content);
                }
            }
        }
        if (!generalReportContentValues.isEmpty()) {
            this.generalReportContentIndex.setReportContents((PairList<UniformPath, ReportContentIndexBase.ReportContent>)generalReportContentValues);
        }
        if (!compileCommandReportContentValues.isEmpty()) {
            this.compileCommandReportContentIndex.setReportContents((PairList<UniformPath, ReportContentIndexBase.ReportContent>)compileCommandReportContentValues);
        }
        if (!sapScovReportContentValues.isEmpty()) {
            this.sapScovReportContentIndex.setReportContents((PairList<UniformPath, ReportContentIndexBase.ReportContent>)sapScovReportContentValues);
        }
    }

    private void removeDeletedElements(List<RepositoryChangeEntry> entries) throws ConQATException {
        ArrayList allDeletedPaths;
        ArrayList<UniformPath> deletedCodePaths = new ArrayList<UniformPath>();
        ArrayList<UniformPath> deletedCompileCommandPaths = new ArrayList<UniformPath>();
        ArrayList<UniformPath> deletedSapScovPaths = new ArrayList<UniformPath>();
        ArrayList<UniformPath> deletedGeneralReportPaths = new ArrayList<UniformPath>();
        this.convertEntriesToDeletedPaths(entries, deletedCodePaths, deletedCompileCommandPaths, deletedSapScovPaths, deletedGeneralReportPaths);
        if (!deletedCompileCommandPaths.isEmpty()) {
            this.compileCommandReportContentIndex.removeReportContents(UniformPathCompatibilityUtil.asUniformPathStrings(deletedCompileCommandPaths));
        }
        if (!deletedSapScovPaths.isEmpty()) {
            this.sapScovReportContentIndex.removeReportContents(UniformPathCompatibilityUtil.asUniformPathStrings(deletedSapScovPaths));
        }
        if (!deletedGeneralReportPaths.isEmpty()) {
            this.generalReportContentIndex.removeReportContents(UniformPathCompatibilityUtil.asUniformPathStrings(deletedGeneralReportPaths));
        }
        if (!deletedCodePaths.isEmpty()) {
            this.codeScopesMappingIndex.removeMappings(deletedCodePaths);
            this.basicTokenElementIndex.removeTokenElements(UniformPathCompatibilityUtil.asUniformPathStrings(deletedCodePaths));
            this.binaryElementIndex.removeContents(UniformPathCompatibilityUtil.asUniformPathStrings(deletedCodePaths));
        }
        if (!(allDeletedPaths = CollectionUtils.unionList(deletedCompileCommandPaths, (Collection[])new Collection[]{deletedSapScovPaths, deletedGeneralReportPaths, deletedCodePaths})).isEmpty()) {
            this.pathTransformationSupport.removeStoredPathTransformations(allDeletedPaths);
        }
    }

    private void calculateHiddenEntriesFromDeletions(List<RepositoryChangeEntry> entries) throws ConQATException {
        PairList entryWithPath = new PairList();
        for (RepositoryChangeEntry entry2 : entries) {
            UniformPath uniformPath;
            if (entry2.changeType != ERepositoryChangeType.DELETE || this.reportMappingSupport.determineReportFormat(uniformPath = this.pathTransformationSupport.getUniformPath(entry2)).isPresent()) continue;
            entryWithPath.add((Object)entry2, (Object)uniformPath.getPathSegmentsString());
        }
        HashSet<RepositoryChangeEntry> nonHiddenEntries = new HashSet<RepositoryChangeEntry>();
        for (BasicTokenElementIndex parentBasicTokenElementIndex : this.parentBasicTokenElementIndexes) {
            List<@Nullable BasicTokenElementInfo> infos = parentBasicTokenElementIndex.getTokenElements((List<String>)entryWithPath.getSecondList());
            for (int i = 0; i < infos.size(); ++i) {
                BasicTokenElementInfo elementInfo = infos.get(i);
                if (elementInfo == null || !elementInfo.getFirstDetailOfType(HiddenTokenElementDetail.class).isEmpty()) continue;
                nonHiddenEntries.add((RepositoryChangeEntry)entryWithPath.getFirst(i));
            }
        }
        this.hiddenEntries.addAll(entryWithPath.getFirstList().stream().filter(entry -> !nonHiddenEntries.contains(entry)).collect(Collectors.toSet()));
    }

    private void convertEntriesToDeletedPaths(List<RepositoryChangeEntry> entries, List<UniformPath> deletedCodePaths, List<UniformPath> deletedCompileCommandPaths, List<UniformPath> deletedSapScovPaths, List<UniformPath> deletedGeneralReportPaths) throws ConQATException {
        for (RepositoryChangeEntry change : entries) {
            if (change.getChangeType() != ERepositoryChangeType.DELETE || !this.repositoryConnection.isIncluded(change.getRepositoryPath().toStringAsMigrationFrontier())) continue;
            UniformPath uniformPath = this.pathTransformationSupport.getUniformPath(change);
            Optional<EReportFormat> format = this.reportMappingSupport.determineReportFormat(uniformPath);
            if (format.isEmpty()) {
                deletedCodePaths.add(uniformPath);
                continue;
            }
            if (format.get() == EReportFormat.COMPILATION_DATABASE) {
                deletedCompileCommandPaths.add(uniformPath);
                continue;
            }
            if (format.get() == EReportFormat.SAP_COVERAGE) {
                deletedGeneralReportPaths.add(uniformPath);
                deletedSapScovPaths.add(uniformPath);
                continue;
            }
            deletedGeneralReportPaths.add(uniformPath);
        }
    }

    private void updateRepositoryLogFileIndex(List<RepositoryChangeEntry> entries) throws ConQATException {
        ArrayList<RepositoryLogFileEntry> repositoryLogFileEntries = new ArrayList<RepositoryLogFileEntry>();
        for (RepositoryChangeEntry entry : entries) {
            UniformPath uniformPath = this.pathTransformationSupport.getUniformPath(entry);
            if (this.reportMappingSupport.isReportPath(entry)) continue;
            boolean deleted = entry.getChangeType() == ERepositoryChangeType.DELETE;
            repositoryLogFileEntries.add(new RepositoryLogFileEntry(entry.getCommit(), uniformPath, ECommitType.CODE_COMMIT, null, deleted));
        }
        this.logFileIndex.insertEntries(repositoryLogFileEntries);
    }

    private void updateProjectRepositoryChangeIndex(List<RepositoryChangeEntry> entries) throws ConQATException {
        ArrayList<RepositoryChangeEntry> newEntries = new ArrayList<RepositoryChangeEntry>();
        for (RepositoryChangeEntry entry : entries) {
            UniformPath uniformPath = this.pathTransformationSupport.getUniformPath(entry);
            if (this.reportMappingSupport.isReportPath(entry)) continue;
            newEntries.add(new RepositoryChangeEntry(uniformPath, this.pathTransformationSupport.getUniformOriginPath(entry), entry));
        }
        this.projectChangeIndex.addChangedFiles(newEntries);
    }

    private static CodeScopeDetail getCodeScopeDetail(CodeScopeName codeScopeName) {
        return new CodeScopeDetail(codeScopeName);
    }

    protected abstract String getConnectionIdentifier();
}

