/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.options.DataPrivacyOption;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.user.UserAliasLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class RepositoryLogFileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<RepositoryLogFileHistoryEntry> augmentWithHistoryInformation(List<RepositoryLogFileEntry> entries, ElementHistoryIndex historyIndex) throws StorageException {
        List uniformPaths = CollectionUtils.map(entries, RepositoryLogFileEntry::getUniformPath);
        List<ElementHistoryEntry> historyEntries = historyIndex.getHistoryEntries(UniformPathCompatibilityUtil.asUniformPathStrings((Collection)uniformPaths));
        Set pathsToIgnore = historyEntries.stream().filter(e -> e != null && e.getChangeType() == EElementHistoryChangeType.MOVE).map(ElementHistoryEntry::getOriginPath).map(UniformPathCompatibilityUtil::convert).collect(Collectors.toSet());
        ArrayList<RepositoryLogFileHistoryEntry> result = new ArrayList<RepositoryLogFileHistoryEntry>();
        for (int i = 0; i < entries.size(); ++i) {
            ElementHistoryEntry historyEntry = historyEntries.get(i);
            UniformPath uniformPath = (UniformPath)uniformPaths.get(i);
            if (pathsToIgnore.contains(uniformPath)) continue;
            if (historyEntry == null) {
                LOGGER.error("No history entry found for {}", (Object)uniformPath);
                continue;
            }
            result.add(new RepositoryLogFileHistoryEntry(uniformPath, historyEntry));
        }
        return result;
    }

    public static <T extends IRepositoryLogEntry> List<T> applyDataPrivacyFilterToLog(List<T> entries, GlobalStorageSystem globalStorageSystem, ServicePermissions permissions, User currentUser, UserAliasLookup userAliasLookup) throws StorageException {
        DataPrivacyOption dataPrivacyOption = DataPrivacyOption.getDataPrivacyOption((GlobalStorageSystem)globalStorageSystem);
        if (dataPrivacyOption.limitDevelopersLogToOwnCommits && !permissions.userHasProjectPermission(EProjectPermission.VIEW_ALL_USER_DATA)) {
            return CollectionUtils.filter(entries, element -> currentUser.getUsername().equals(userAliasLookup.resolveAuthorOf((IRepositoryLogEntry)element).map(User::getUsername).orElse(element.getAuthor())));
        }
        return entries;
    }

    private RepositoryLogFileUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

