/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.shutdown.ShutdownLock;
import com.teamscale.core.shutdown.ShutdownManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.eclipse.jgit.lib.Repository;

public class GitWriteLockManager {
    private static final String INDEX_LOCK_FILE_NAME = "index.lock";
    private static final Duration MAX_LOCK_FILE_WAIT_TIME = Duration.ofMinutes(15L);
    private static final Map<Path, GitDirectoryLock> EXISTING_LOCKS = Collections.synchronizedMap(new HashMap());

    public static GitDirectoryLock lockGitRepositoryForWriting(Repository repository) throws RepositoryException {
        return GitWriteLockManager.lockGitDirectoryForWriting(repository.getDirectory().toPath());
    }

    public static GitDirectoryLock lockGitDirectoryForWriting(Path gitMetadataDirectory) throws RepositoryException {
        GitDirectoryLock lock = EXISTING_LOCKS.computeIfAbsent(gitMetadataDirectory, x -> new GitDirectoryLock());
        lock.lock();
        Path lockFile = gitMetadataDirectory.resolve(INDEX_LOCK_FILE_NAME);
        Instant timeout = DateTimeUtils.now().plus(MAX_LOCK_FILE_WAIT_TIME);
        while (Files.exists(lockFile, new LinkOption[0]) && DateTimeUtils.now().isBefore(timeout) && !ShutdownManager.getInstance().isShutdownStarted()) {
            ThreadUtils.sleep((long)10L);
        }
        lock.beginNoShutdownRegion();
        return lock;
    }

    public static final class GitDirectoryLock
    implements AutoCloseable {
        private final Lock delegate = new ReentrantLock();
        private final ShutdownLock shutdownLock = ShutdownManager.getInstance().obtainShutdownLock();
        private int reentrantLockCount;

        private void lock() {
            this.delegate.lock();
        }

        private void beginNoShutdownRegion() throws RepositoryException {
            boolean couldEnterNoShutdownRegion;
            if (this.reentrantLockCount == 0 && !(couldEnterNoShutdownRegion = this.shutdownLock.enterNoShutdownRegion())) {
                this.delegate.unlock();
                throw new RepositoryException("Teamscale is already shutting down");
            }
            ++this.reentrantLockCount;
        }

        public void unlock() {
            --this.reentrantLockCount;
            if (this.reentrantLockCount == 0) {
                this.shutdownLock.exitNoShutdownRegion();
            }
            this.delegate.unlock();
        }

        @Override
        public void close() {
            this.unlock();
        }
    }
}

