/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import java.util.HashSet;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="bitbucket-server-webhook-events", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED}, valueClasses={byte[].class})
public class BitbucketServerWebhookEventIndex
implements IProjectIndex {
    private final ValueIndex<HashSet<String>> delegateIndex;

    public BitbucketServerWebhookEventIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public void addWebhookEvent(String repositoryName, String event) throws StorageException {
        HashSet<String> values = this.getWebhookEvents(repositoryName);
        values.add(event);
        this.delegateIndex.setValue(repositoryName, values);
    }

    public HashSet<String> getWebhookEvents(String repositoryName) throws StorageException {
        HashSet value = (HashSet)this.delegateIndex.getValue(repositoryName);
        if (value == null) {
            return new HashSet<String>();
        }
        return value;
    }

    public boolean containsWebhookEvent(String repositoryName, String event) throws StorageException {
        HashSet<String> values = this.getWebhookEvents(repositoryName);
        return values.contains(event);
    }

    public PairList<String, HashSet<String>> getAllRepositoriesToWebhookEvents() throws StorageException {
        return this.delegateIndex.getAllEntries();
    }
}

