/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnectorDescriptor;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import java.net.URI;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;

public final class GerritFilesRetriever
implements IFilesRetriever {
    private final @NonNull ServerOptionIndex serverOptionIndex;
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @NonNull ExternalCredentials credentials;

    public GerritFilesRetriever(@NonNull ServerOptionIndex serverOptionIndex, @NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials) {
        this.serverOptionIndex = serverOptionIndex;
        this.connectorConfiguration = connectorConfiguration;
        this.credentials = credentials;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        String projectName = GerritRepositoryConnectorDescriptor.getGerritProjectName(this.connectorConfiguration);
        URI location = GitRepositoryConnector.adjustGitUrlAndConvertToUri(this.credentials.uri, UniformPathUtils.concatenate((String[])new String[]{"a", projectName}));
        return GitPreviewUtils.retrieveFilesFromGit(location, this.connectorConfiguration, this.serverOptionIndex, this.credentials, true);
    }
}

